
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Checks behavior of "schema-type" configuration parameter.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-schema-type">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-schema-type</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration-getParameter">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration-getParameter</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration-setParameter">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration-setParameter</a>
*/
public final class domconfigschematype1 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    */
   public domconfigschematype1(final DOMTestDocumentBuilderFactory factory)  {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      DOMImplementation domImpl;
      Document doc;
      DOMConfiguration domConfig;
      DocumentType nullDocType = null;

      boolean canSet;
      String state;
      String parameter = "sChEma-type";
      String xmlSchemaType = "http://www.w3.org/2001/XMLSchema";
      String dtdType = "http://www.w3.org/TR/REC-xml";
      domImpl = getImplementation();
      doc = domImpl.createDocument("http://www.w3.org/1999/xhtml", "html", nullDocType);
      domConfig = doc.getDomConfig();
      canSet = domConfig.canSetParameter(parameter, Boolean.TRUE);
      assertFalse("canSetTrue", canSet);

      try {
      state = (String) domConfig.getParameter(parameter);
      
      } catch (DOMException ex) {
           switch (ex.code) {
      case 8 : 
               return ;
          default:
          throw ex;
          }
      } 
canSet = domConfig.canSetParameter(parameter, ((Object) /*DOMString */dtdType));
      
      if (canSet) {
          domConfig.setParameter(parameter, ((Object) /*DOMString */dtdType));
      state = (String) domConfig.getParameter(parameter);
      assertEquals("setDTDEffective", dtdType, state);
      } else {
          
      {
         boolean success = false;
         try {
            domConfig.setParameter(parameter, ((Object) /*DOMString */dtdType));
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NOT_SUPPORTED_ERR);
         }
         assertTrue("throw_NOT_SUPPORTED_ERR_dtd", success);
      }
}
        
    canSet = domConfig.canSetParameter(parameter, ((Object) /*DOMString */xmlSchemaType));
      
      if (canSet) {
          domConfig.setParameter(parameter, ((Object) /*DOMString */xmlSchemaType));
      state = (String) domConfig.getParameter(parameter);
      assertEquals("setSchemaEffective", xmlSchemaType, state);
      } else {
          
      {
         boolean success = false;
         try {
            domConfig.setParameter(parameter, ((Object) /*DOMString */xmlSchemaType));
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NOT_SUPPORTED_ERR);
         }
         assertTrue("throw_NOT_SUPPORTED_ERR_schema", success);
      }
}
        
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/domconfigschematype1";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(domconfigschematype1.class, args);
   }
}

