
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method replaceChild replaces the child node oldChild with newChild in the list of 
 *  children, and returns the oldChild node.
 *  Using replaceChild on the documentElement of a newly created Document node, attempt to replace an
 *         element child of this documentElement node with a child that was imported from another document.  
 *         Verify the nodeName of the replaced element node. 
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-785887307">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-785887307</a>
*/
public final class nodereplacechild14 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodereplacechild14(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Document newDoc;
      Element docElem;
      Element elem;
      Element elem2;
      Node imported;
      Element replaced;
      DOMImplementation domImpl;
      String nodeName;
      Node appendedChild;
      DocumentType nullDocType = null;

      doc = (Document) load("hc_staff", false);
      elem = doc.createElementNS("http://www.w3.org/DOM/Test", "dom3:doc1elem");
      domImpl = doc.getImplementation();
      newDoc = domImpl.createDocument("http://www.w3.org/DOM/test", "dom3:doc", nullDocType);
      elem2 = newDoc.createElementNS("http://www.w3.org/DOM/Test", "dom3:doc2elem");
      imported = newDoc.importNode(elem, true);
      docElem = newDoc.getDocumentElement();
      appendedChild = docElem.appendChild(imported);
      appendedChild = docElem.appendChild(elem2);
      replaced = (Element) docElem.replaceChild(imported, elem2);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild14", "dom3:doc2elem", nodeName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodereplacechild14";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodereplacechild14.class, args);
   }
}

