
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001-2004 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *     The range of valid child node indices is 0 thru length -1
 *    
 *    Create a list of all the children elements of the third
 *    employee and traverse the list from index=0 thru
 *    length -1.     
* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-203510337">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-203510337</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136</a>
*/
public final class nodelisttraverselist extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodelisttraverselist(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elementList;
      Node employeeNode;
      NodeList employeeList;
      Node child;
      String childName;
      java.util.List result = new java.util.ArrayList();
      
      int length;
      java.util.List expectedWhitespace = new java.util.ArrayList();
      expectedWhitespace.add("#text");
      expectedWhitespace.add("employeeId");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("name");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("position");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("salary");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("gender");
      expectedWhitespace.add("#text");
      expectedWhitespace.add("address");
      expectedWhitespace.add("#text");
      
      java.util.List expectedNoWhitespace = new java.util.ArrayList();
      expectedNoWhitespace.add("employeeId");
      expectedNoWhitespace.add("name");
      expectedNoWhitespace.add("position");
      expectedNoWhitespace.add("salary");
      expectedNoWhitespace.add("gender");
      expectedNoWhitespace.add("address");
      
      doc = (Document) load("staff", false);
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.getChildNodes();
      length = (int) employeeList.getLength();
      for (int indexN100A4 = 0; indexN100A4 < employeeList.getLength(); indexN100A4++) {
          child = (Node) employeeList.item(indexN100A4);
    childName = child.getNodeName();
      result.add(childName);
        }
      
      if (equals(6, length)) {
          assertEquals("nowhitespace", expectedNoWhitespace, result);
      } else {
          assertEquals("whitespace", expectedWhitespace, result);
      }
        
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodelisttraverselist";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodelisttraverselist.class, args);
   }
}

