/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.ext.stax.datahandler.DataHandlerWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.QNameAwareOMDataSource;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axiom.om.ds.jaxb.DataHandlerWriterAttachmentMarshaller;
import org.apache.axiom.om.ds.jaxb.MTOMXMLStreamWriterAttachmentMarshaller;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.util.stax.xop.XOPDecodingStreamWriter;

public class JAXBOMDataSource
extends AbstractPushOMDataSource
implements QNameAwareOMDataSource {
    private final JAXBContext context;
    private final Object object;
    private QName cachedQName;

    public JAXBOMDataSource(JAXBContext context, Object object) {
        this.context = context;
        this.object = object;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            if (writer instanceof MTOMXMLStreamWriter) {
                MTOMXMLStreamWriter mtomWriter = (MTOMXMLStreamWriter)writer;
                if (mtomWriter.isOptimized()) {
                    marshaller.setAttachmentMarshaller((AttachmentMarshaller)new MTOMXMLStreamWriterAttachmentMarshaller(mtomWriter));
                }
            } else {
                DataHandlerWriter dataHandlerWriter;
                try {
                    dataHandlerWriter = (DataHandlerWriter)writer.getProperty(DataHandlerWriter.PROPERTY);
                }
                catch (IllegalArgumentException ex) {
                    dataHandlerWriter = null;
                }
                if (dataHandlerWriter != null) {
                    DataHandlerWriterAttachmentMarshaller am = new DataHandlerWriterAttachmentMarshaller();
                    writer = new XOPDecodingStreamWriter(writer, am);
                    marshaller.setAttachmentMarshaller((AttachmentMarshaller)am);
                }
            }
            marshaller.marshal(this.object, writer);
        }
        catch (JAXBException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof XMLStreamException) {
                throw (XMLStreamException)cause;
            }
            throw new XMLStreamException("Error marshalling JAXB object", ex);
        }
    }

    private QName getQName() {
        if (this.cachedQName == null) {
            if (this.object instanceof JAXBElement) {
                this.cachedQName = ((JAXBElement)this.object).getName();
            } else {
                this.cachedQName = this.context.createJAXBIntrospector().getElementName(this.object);
                if (this.cachedQName == null) {
                    throw new OMException("Unable to determine the element name of the object");
                }
            }
        }
        return this.cachedQName;
    }

    public String getLocalName() {
        return this.getQName().getLocalPart();
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public String getPrefix() {
        return null;
    }

    public Object getObject() {
        return this.object;
    }

    public OMDataSourceExt copy() {
        return new JAXBOMDataSource(this.context, this.object);
    }
}

