/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.IWrappedHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.internal.HeaderResponse;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.renderStrategy.AbstractHeaderRenderStrategy;
import org.apache.wicket.markup.renderStrategy.IHeaderRenderStrategy;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartialPageUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(PartialPageUpdate.class);
    protected final List<CharSequence> prependJavaScripts = Generics.newArrayList();
    protected final List<CharSequence> appendJavaScripts = Generics.newArrayList();
    protected final List<CharSequence> domReadyJavaScripts = Generics.newArrayList();
    protected final Map<String, Component> markupIdToComponent = new LinkedHashMap<String, Component>();
    protected transient boolean componentsFrozen;
    protected final ResponseBuffer bodyBuffer;
    protected final ResponseBuffer headerBuffer;
    protected HtmlHeaderContainer header = null;
    private Component originalHeaderContainer = null;
    private boolean headerRendering = false;
    private IHeaderResponse headerResponse;
    private final Page page;

    public PartialPageUpdate(Page page) {
        this.page = page;
        this.originalHeaderContainer = page.get("_header_");
        WebResponse response = (WebResponse)page.getResponse();
        this.bodyBuffer = new ResponseBuffer(response);
        this.headerBuffer = new ResponseBuffer(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Response response, String encoding) {
        try {
            this.writeHeader(response, encoding);
            this.onBeforeRespond(response);
            this.writeComponents(response, encoding);
            this.onAfterRespond(response);
            this.writePriorityEvaluations(response, this.prependJavaScripts);
            ArrayList<CharSequence> evaluationScripts = new ArrayList<CharSequence>();
            evaluationScripts.addAll(this.domReadyJavaScripts);
            evaluationScripts.addAll(this.appendJavaScripts);
            this.writeNormalEvaluations(response, evaluationScripts);
            this.writeFooter(response, encoding);
        }
        finally {
            if (this.header != null && this.originalHeaderContainer != null) {
                this.page.replace(this.originalHeaderContainer);
                this.header = null;
            }
        }
    }

    protected void onBeforeRespond(Response response) {
    }

    protected void onAfterRespond(Response response) {
    }

    protected abstract void writeFooter(Response var1, String var2);

    protected abstract void writePriorityEvaluations(Response var1, Collection<CharSequence> var2);

    protected abstract void writeNormalEvaluations(Response var1, Collection<CharSequence> var2);

    private void writeComponents(Response response, String encoding) {
        this.componentsFrozen = true;
        for (Map.Entry<String, Component> stringComponentEntry : this.markupIdToComponent.entrySet()) {
            Component component = stringComponentEntry.getValue();
            if (this.containsAncestorFor(component)) continue;
            this.writeComponent(response, component.getAjaxRegionMarkupId(), component, encoding);
        }
        if (this.header != null) {
            this.headerRendering = true;
            Response oldResponse = RequestCycle.get().setResponse((Response)this.headerBuffer);
            this.headerBuffer.reset();
            this.header.getHeaderResponse().close();
            RequestCycle.get().setResponse(oldResponse);
            this.writeHeaderContribution(response);
            this.headerRendering = false;
        }
    }

    protected abstract void writeComponent(Response var1, String var2, Component var3, String var4);

    protected abstract void writeHeader(Response var1, String var2);

    protected abstract void writeHeaderContribution(Response var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialPageUpdate that = (PartialPageUpdate)o;
        if (!this.appendJavaScripts.equals(that.appendJavaScripts)) {
            return false;
        }
        if (!this.domReadyJavaScripts.equals(that.domReadyJavaScripts)) {
            return false;
        }
        return this.prependJavaScripts.equals(that.prependJavaScripts);
    }

    public int hashCode() {
        int result = this.prependJavaScripts.hashCode();
        result = 31 * result + this.appendJavaScripts.hashCode();
        result = 31 * result + this.domReadyJavaScripts.hashCode();
        return result;
    }

    public final void appendJavaScript(CharSequence javascript) {
        Args.notNull((Object)javascript, (String)"javascript");
        this.appendJavaScripts.add(javascript);
    }

    public final void prependJavaScript(CharSequence javascript) {
        Args.notNull((Object)javascript, (String)"javascript");
        this.prependJavaScripts.add(javascript);
    }

    public final void add(Component component, String markupId) throws IllegalArgumentException, IllegalStateException {
        Args.notEmpty((CharSequence)markupId, (String)"markupId");
        Args.notNull((Object)component, (String)"component");
        if (component instanceof Page) {
            if (component != this.page) {
                throw new IllegalArgumentException("component cannot be a page");
            }
        } else if (component instanceof AbstractRepeater) {
            throw new IllegalArgumentException("Component " + component.getClass().getName() + " has been added to a partial page update. This component is a repeater and cannot be repainted directly. " + "Instead add its parent or another markup container higher in the hierarchy.");
        }
        this.assertComponentsNotFrozen();
        component.setMarkupId(markupId);
        this.markupIdToComponent.put(markupId, component);
    }

    public final Collection<? extends Component> getComponents() {
        return Collections.unmodifiableCollection(this.markupIdToComponent.values());
    }

    public void detach(IRequestCycle requestCycle) {
        for (Component component : this.markupIdToComponent.values()) {
            Page parentPage = component.findParent(Page.class);
            if (parentPage == null) continue;
            parentPage.detach();
            break;
        }
    }

    protected boolean containsAncestorFor(Component component) {
        for (MarkupContainer cursor = component.getParent(); cursor != null; cursor = cursor.getParent()) {
            if (!this.markupIdToComponent.containsValue(cursor)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPage() {
        return this.markupIdToComponent.values().contains(this.page);
    }

    public IHeaderResponse getHeaderResponse() {
        if (this.headerResponse == null) {
            this.headerResponse = new PartialHeaderResponse();
        }
        return this.headerResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeaderContribution(Response response, Component component) {
        this.headerRendering = true;
        if (this.header == null) {
            this.header = new PartialHtmlHeaderContainer(this);
            this.page.addOrReplace(this.header);
        }
        RequestCycle requestCycle = component.getRequestCycle();
        Response oldResponse = requestCycle.setResponse((Response)this.headerBuffer);
        try {
            this.headerBuffer.reset();
            IHeaderRenderStrategy strategy = AbstractHeaderRenderStrategy.get();
            strategy.renderHeader(this.header, null, component);
        }
        finally {
            requestCycle.setResponse(oldResponse);
        }
        this.writeHeaderContribution(response);
        this.headerRendering = false;
    }

    public abstract void setContentType(WebResponse var1, String var2);

    private void assertComponentsNotFrozen() {
        this.assertNotFrozen(this.componentsFrozen, Component.class);
    }

    private void assertNotFrozen(boolean frozen, Class<?> clazz) {
        if (frozen) {
            throw new IllegalStateException(Classes.simpleName(clazz) + "s can no " + " longer be added");
        }
    }

    protected static final class ResponseBuffer
    extends WebResponse {
        private final AppendingStringBuffer buffer = new AppendingStringBuffer(256);
        private final WebResponse originalResponse;

        private ResponseBuffer(WebResponse originalResponse) {
            this.originalResponse = originalResponse;
        }

        public String encodeURL(CharSequence url) {
            return this.originalResponse.encodeURL(url);
        }

        public CharSequence getContents() {
            return this.buffer;
        }

        public void write(CharSequence cs) {
            this.buffer.append((Object)cs);
        }

        public void reset() {
            this.buffer.clear();
        }

        public void write(byte[] array) {
            throw new UnsupportedOperationException("Cannot write binary data.");
        }

        public void write(byte[] array, int offset, int length) {
            throw new UnsupportedOperationException("Cannot write binary data.");
        }

        public Object getContainerResponse() {
            return this.originalResponse.getContainerResponse();
        }

        public void addCookie(Cookie cookie) {
            this.originalResponse.addCookie(cookie);
        }

        public void clearCookie(Cookie cookie) {
            this.originalResponse.clearCookie(cookie);
        }

        public void setHeader(String name, String value) {
            this.originalResponse.setHeader(name, value);
        }

        public void addHeader(String name, String value) {
            this.originalResponse.addHeader(name, value);
        }

        public void setDateHeader(String name, Time date) {
            this.originalResponse.setDateHeader(name, date);
        }

        public void setContentLength(long length) {
            this.originalResponse.setContentLength(length);
        }

        public void setContentType(String mimeType) {
            this.originalResponse.setContentType(mimeType);
        }

        public void setStatus(int sc) {
            this.originalResponse.setStatus(sc);
        }

        public void sendError(int sc, String msg) {
            this.originalResponse.sendError(sc, msg);
        }

        public String encodeRedirectURL(CharSequence url) {
            return this.originalResponse.encodeRedirectURL(url);
        }

        public void sendRedirect(String url) {
            this.originalResponse.sendRedirect(url);
        }

        public boolean isRedirect() {
            return this.originalResponse.isRedirect();
        }

        public void flush() {
            this.originalResponse.flush();
        }
    }

    private class PartialHeaderResponse
    extends HeaderResponse {
        private PartialHeaderResponse() {
        }

        @Override
        public void render(HeaderItem item) {
            PriorityHeaderItem priorityHeaderItem = null;
            while (item instanceof IWrappedHeaderItem) {
                if (item instanceof PriorityHeaderItem) {
                    priorityHeaderItem = (PriorityHeaderItem)item;
                }
                item = ((IWrappedHeaderItem)((Object)item)).getWrapped();
            }
            if (item instanceof OnLoadHeaderItem) {
                if (!this.wasItemRendered(item)) {
                    PartialPageUpdate.this.appendJavaScript(((OnLoadHeaderItem)item).getJavaScript());
                    this.markItemRendered(item);
                }
            } else if (item instanceof OnEventHeaderItem) {
                if (!this.wasItemRendered(item)) {
                    PartialPageUpdate.this.appendJavaScript(((OnEventHeaderItem)item).getCompleteJavaScript());
                    this.markItemRendered(item);
                }
            } else if (item instanceof OnDomReadyHeaderItem) {
                if (!this.wasItemRendered(item)) {
                    if (priorityHeaderItem != null) {
                        PartialPageUpdate.this.domReadyJavaScripts.add(0, ((OnDomReadyHeaderItem)item).getJavaScript());
                    } else {
                        PartialPageUpdate.this.domReadyJavaScripts.add(((OnDomReadyHeaderItem)item).getJavaScript());
                    }
                    this.markItemRendered(item);
                }
            } else if (PartialPageUpdate.this.headerRendering) {
                super.render(item);
            } else {
                LOG.debug("Only methods that can be called on IHeaderResponse outside renderHead() are #render(OnLoadHeaderItem) and #render(OnDomReadyHeaderItem)");
            }
        }

        @Override
        protected Response getRealResponse() {
            return RequestCycle.get().getResponse();
        }
    }

    private static class PartialHtmlHeaderContainer
    extends HtmlHeaderContainer {
        private static final long serialVersionUID = 1L;
        private transient PartialPageUpdate pageUpdate;

        public PartialHtmlHeaderContainer(PartialPageUpdate pageUpdate) {
            super("_header_");
            this.pageUpdate = pageUpdate;
        }

        @Override
        protected IHeaderResponse newHeaderResponse() {
            if (this.pageUpdate == null) {
                throw new IllegalStateException("disconnected from pageUpdate after serialization");
            }
            return this.pageUpdate.getHeaderResponse();
        }
    }
}

