/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.memory;

import java.io.Serializable;
import org.apache.wicket.Session;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.memory.IDataStoreEvictionStrategy;
import org.apache.wicket.pageStore.memory.PageTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionDataStore
implements IDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSessionDataStore.class);
    private static final String PAGE_TABLE_KEY = "page:store:memory";
    private final IPageManagerContext pageManagerContext;
    private final IDataStoreEvictionStrategy evictionStrategy;

    public HttpSessionDataStore(IPageManagerContext pageManagerContext, IDataStoreEvictionStrategy evictionStrategy) {
        this.pageManagerContext = pageManagerContext;
        this.evictionStrategy = evictionStrategy;
    }

    @Override
    public byte[] getData(String sessionId, int pageId) {
        PageTable pageTable = this.getPageTable(false, false);
        byte[] pageAsBytes = null;
        if (pageTable != null) {
            pageAsBytes = pageTable.getPage(pageId);
        }
        if (LOG.isDebugEnabled()) {
            int bytesLength = pageAsBytes != null ? pageAsBytes.length : -1;
            LOG.debug("Loaded '{}' bytes for page with id '{}' in session '{}'", new Object[]{bytesLength, pageId, sessionId});
        }
        return pageAsBytes;
    }

    @Override
    public void removeData(String sessionId, int pageId) {
        PageTable pageTable = this.getPageTable(false, true);
        if (pageTable != null) {
            byte[] bytes = pageTable.removePage(pageId);
            if (LOG.isDebugEnabled() && bytes != null) {
                LOG.debug("Removed page '{}' in session '{}'", (Object)pageId, (Object)sessionId);
            }
        }
    }

    @Override
    public void removeData(String sessionId) {
        PageTable pageTable = this.getPageTable(false, true);
        if (pageTable != null) {
            pageTable.clear();
            LOG.debug("Removed all pages in session '{}'", (Object)sessionId);
        }
    }

    @Override
    public void storeData(String sessionId, int pageId, byte[] pageAsBytes) {
        PageTable pageTable = this.getPageTable(true, true);
        if (pageTable != null) {
            pageTable.storePage(pageId, pageAsBytes);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stored '{}' bytes for page '{}' in session '{}'", new Object[]{pageAsBytes.length, pageId, sessionId});
            }
            this.evictionStrategy.evict(pageTable);
        } else {
            LOG.error("Cannot store the data for page with id '{}' in session with id '{}'", (Object)pageId, (Object)sessionId);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isReplicated() {
        return true;
    }

    private PageTable getPageTable(boolean create, boolean rewriteToSession) {
        PageTable pageTable = null;
        if (Session.exists()) {
            pageTable = (PageTable)((Object)this.pageManagerContext.getSessionAttribute(PAGE_TABLE_KEY));
            if (pageTable == null && create) {
                pageTable = new PageTable();
                this.pageManagerContext.setSessionAttribute(PAGE_TABLE_KEY, (Serializable)((Object)pageTable));
            } else if (rewriteToSession) {
                this.pageManagerContext.setSessionAttribute(PAGE_TABLE_KEY, (Serializable)((Object)pageTable));
            }
        }
        return pageTable;
    }

    @Override
    public final boolean canBeAsynchronous() {
        return false;
    }
}

