/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.markup.head.AbstractJavaScriptReferenceHeaderItem;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class JavaScriptUrlReferenceHeaderItem
extends AbstractJavaScriptReferenceHeaderItem {
    private final String url;
    private final String id;

    public JavaScriptUrlReferenceHeaderItem(String url, String id, boolean defer, String charset, String condition) {
        super(condition, defer, charset);
        this.url = url;
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void render(Response response) {
        this.internalRenderJavaScriptReference(response, UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get()), this.getId(), this.isDefer(), this.getCharset(), this.getCondition(), this.isAsync());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        String url = UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get());
        if (Strings.isEmpty((CharSequence)this.getId())) {
            return Collections.singletonList("javascript-" + url);
        }
        return Arrays.asList("javascript-" + this.getId(), "javascript-" + url);
    }

    public String toString() {
        return "JavaScriptUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaScriptUrlReferenceHeaderItem that = (JavaScriptUrlReferenceHeaderItem)o;
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }
}

