/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;

public class CssUrlReferenceHeaderItem
extends CssHeaderItem {
    private final String url;
    private final String media;

    public CssUrlReferenceHeaderItem(String url, String media, String condition) {
        super(condition);
        this.url = url;
        this.media = media;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMedia() {
        return this.media;
    }

    @Override
    public void render(Response response) {
        this.internalRenderCSSReference(response, UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get()), this.getMedia(), this.getCondition());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Arrays.asList("css-" + UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get()) + "-" + this.media);
    }

    public String toString() {
        return "CSSUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssUrlReferenceHeaderItem that = (CssUrlReferenceHeaderItem)o;
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return this.media != null ? this.media.equals(that.media) : that.media == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.media != null ? this.media.hashCode() : 0);
        return result;
    }
}

