/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.string.ComponentStrings;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.MarkupType;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.internal.InlineEnclosure;
import org.apache.wicket.markup.resolver.ComponentResolvers;
import org.apache.wicket.model.IComponentInheritedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.iterator.ComponentHierarchyIterator;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.ClassVisitFilter;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitFilter;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupContainer
extends Component
implements Iterable<Component> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MarkupContainer.class);
    private Object children;

    public MarkupContainer(String id) {
        this(id, null);
    }

    public MarkupContainer(String id, IModel<?> model) {
        super(id, model);
    }

    public MarkupContainer add(Component ... childs) {
        for (Component child : childs) {
            Args.notNull((Object)child, (String)"child");
            if (this == child) {
                throw new IllegalArgumentException(this.exceptionMessage("Trying to add this component to itself."));
            }
            for (MarkupContainer parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (child != parent) continue;
                String msg = "You can not add a component's parent as child to the component (loop): Component: " + this.toString(false) + "; parent == child: " + parent.toString(false);
                if (child instanceof Border.BorderBodyContainer) {
                    msg = msg + ". Please consider using Border.addToBorder(new " + Classes.simpleName(this.getClass()) + "(\"" + this.getId() + "\", ...) instead of add(...)";
                }
                throw new WicketRuntimeException(msg);
            }
            this.checkHierarchyChange(child);
            if (log.isDebugEnabled()) {
                log.debug("Add " + child.getId() + " to " + this);
            }
            this.addedComponent(child);
            if (this.put(child) == null) continue;
            throw new IllegalArgumentException(this.exceptionMessage("A child with id '" + child.getId() + "' already exists"));
        }
        return this;
    }

    public MarkupContainer addOrReplace(Component ... childs) {
        for (Component child : childs) {
            if (child == null) {
                throw new IllegalArgumentException("argument child must be not null");
            }
            this.checkHierarchyChange(child);
            if (this.get(child.getId()) == null) {
                this.add(child);
                continue;
            }
            this.replace(child);
        }
        return this;
    }

    public final boolean autoAdd(Component component, MarkupStream markupStream) {
        int index;
        Args.notNull((Object)component, (String)"component");
        component.setAuto(true);
        if (markupStream != null) {
            component.setMarkup(markupStream.getMarkupFragment());
        }
        if ((index = this.children_indexOf(component)) >= 0) {
            this.children_remove(index);
        }
        this.add(component);
        return true;
    }

    public boolean contains(Component component, boolean recurse) {
        if (component == null) {
            throw new IllegalArgumentException("argument component may not be null");
        }
        if (recurse) {
            Component current = component;
            while (current != null) {
                MarkupContainer parent = current.getParent();
                if (parent == this) {
                    return true;
                }
                current = parent;
            }
            return false;
        }
        return component.getParent() == this;
    }

    @Override
    public final Component get(String path) {
        if (Strings.isEmpty((CharSequence)path)) {
            return this;
        }
        MarkupContainer container = this;
        String id = Strings.firstPathComponent((String)path, (char)':');
        while ("..".equals(id)) {
            if ((container = container.getParent()) == null) {
                return null;
            }
            path = path.length() == id.length() ? "" : path.substring(id.length() + 1);
            id = Strings.firstPathComponent((String)path, (char)':');
        }
        if (Strings.isEmpty((CharSequence)id)) {
            return container;
        }
        Component child = container.children_get(id);
        if (child != null) {
            String path2 = Strings.afterFirstPathComponent((String)path, (char)':');
            return child.get(path2);
        }
        return null;
    }

    public MarkupStream getAssociatedMarkupStream(boolean throwException) {
        Markup markup = this.getAssociatedMarkup();
        if (markup != null) {
            return new MarkupStream(markup);
        }
        if (throwException) {
            throw new MarkupNotFoundException("Markup of type '" + this.getMarkupType().getExtension() + "' for component '" + this.getClass().getName() + "' not found." + " Enable debug messages for org.apache.wicket.util.resource to get a list of all filenames tried.: " + this.toString());
        }
        return null;
    }

    public Markup getAssociatedMarkup() {
        try {
            Markup markup = MarkupFactory.get().getMarkup(this, false);
            if (markup != null && markup != Markup.NO_MARKUP) {
                return markup;
            }
            return null;
        }
        catch (MarkupException ex) {
            throw ex;
        }
        catch (MarkupNotFoundException ex) {
            throw ex;
        }
        catch (WicketRuntimeException ex) {
            throw new MarkupNotFoundException(this.exceptionMessage("Markup of type '" + this.getMarkupType().getExtension() + "' for component '" + this.getClass().getName() + "' not found." + " Enable debug messages for org.apache.wicket.util.resource to get a list of all filenames tried"), ex);
        }
    }

    public IMarkupFragment getMarkup(Component child) {
        return this.getMarkupSourcingStrategy().getMarkup(this, child);
    }

    public MarkupType getMarkupType() {
        MarkupContainer parent = this.getParent();
        if (parent != null) {
            return parent.getMarkupType();
        }
        return null;
    }

    public void internalAdd(Component child) {
        if (log.isDebugEnabled()) {
            log.debug("internalAdd " + child.getId() + " to " + this);
        }
        this.addedComponent(child);
        this.put(child);
    }

    @Override
    public Iterator<Component> iterator() {
        return new Iterator<Component>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < MarkupContainer.this.children_size();
            }

            @Override
            public Component next() {
                return MarkupContainer.this.children_get(this.index++);
            }

            @Override
            public void remove() {
                Component removed = MarkupContainer.this.children_remove(--this.index);
                MarkupContainer.this.checkHierarchyChange(removed);
                MarkupContainer.this.removedComponent(removed);
            }
        };
    }

    public final Iterator<Component> iterator(Comparator<Component> comparator) {
        List sorted;
        if (this.children == null) {
            sorted = Collections.emptyList();
        } else if (this.children instanceof Component) {
            sorted = new ArrayList(1);
            sorted.add((Component)this.children);
        } else {
            int size = this.children_size();
            sorted = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                sorted.add(this.children_get(i));
            }
        }
        Collections.sort(sorted, comparator);
        return sorted.iterator();
    }

    public MarkupContainer remove(Component component) {
        this.checkHierarchyChange(component);
        Args.notNull((Object)component, (String)"component");
        this.children_remove(component);
        this.removedComponent(component);
        return this;
    }

    public MarkupContainer remove(String id) {
        Args.notNull((Object)id, (String)"id");
        Component component = this.get(id);
        if (component == null) {
            throw new WicketRuntimeException("Unable to find a component with id '" + id + "' to remove");
        }
        this.remove(component);
        return this;
    }

    public MarkupContainer removeAll() {
        if (this.children != null) {
            this.addStateChange();
            int size = this.children_size();
            for (int i = 0; i < size; ++i) {
                Object childObject = this.children_get(i, false);
                if (!(childObject instanceof Component)) continue;
                Component child = (Component)childObject;
                child.internalOnRemove();
                child.detach();
                child.setParent(null);
            }
            this.children = null;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderAssociatedMarkup(String openTagName, String exceptionMessage) {
        ComponentTag associatedMarkupOpenTag;
        MarkupStream associatedMarkupStream = new MarkupStream(this.getMarkup(null));
        MarkupElement elem = associatedMarkupStream.get();
        if (!(elem instanceof ComponentTag)) {
            associatedMarkupStream.throwMarkupException("Expected the open tag. " + exceptionMessage);
        }
        if ((associatedMarkupOpenTag = (ComponentTag)elem) == null || !associatedMarkupOpenTag.isOpen() || !(associatedMarkupOpenTag instanceof WicketTag)) {
            associatedMarkupStream.throwMarkupException(exceptionMessage);
        }
        try {
            this.setIgnoreAttributeModifier(true);
            this.renderComponentTag(associatedMarkupOpenTag);
            associatedMarkupStream.next();
            String className = null;
            boolean outputClassName = this.getApplication().getDebugSettings().isOutputMarkupContainerClassName();
            if (outputClassName) {
                className = Classes.name(this.getClass());
                this.getResponse().write((CharSequence)"<!-- MARKUP FOR ");
                this.getResponse().write((CharSequence)className);
                this.getResponse().write((CharSequence)" BEGIN -->");
            }
            this.renderComponentTagBody(associatedMarkupStream, associatedMarkupOpenTag);
            if (outputClassName) {
                this.getResponse().write((CharSequence)"<!-- MARKUP FOR ");
                this.getResponse().write((CharSequence)className);
                this.getResponse().write((CharSequence)" END -->");
            }
            this.renderClosingComponentTag(associatedMarkupStream, associatedMarkupOpenTag, false);
        }
        finally {
            this.setIgnoreAttributeModifier(false);
        }
    }

    public MarkupContainer replace(Component child) {
        Args.notNull((Object)child, (String)"child");
        this.checkHierarchyChange(child);
        if (log.isDebugEnabled()) {
            log.debug("Replacing " + child.getId() + " in " + this);
        }
        if (child.getParent() != this) {
            Component replaced = this.put(child);
            if (replaced == null) {
                throw new WicketRuntimeException(this.exceptionMessage("Cannot replace a component which has not been added: id='" + child.getId() + "', component=" + child));
            }
            this.removedComponent(replaced);
            child.setMarkupId(replaced);
            this.addedComponent(child);
        }
        return this;
    }

    @Override
    public MarkupContainer setDefaultModel(final IModel<?> model) {
        final IModel<?> previous = this.getModelImpl();
        super.setDefaultModel(model);
        if (previous instanceof IComponentInheritedModel) {
            this.visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    IModel<?> compModel = component.getDefaultModel();
                    if (compModel instanceof IWrapModel) {
                        compModel = ((IWrapModel)compModel).getWrappedModel();
                    }
                    if (compModel == previous) {
                        component.setDefaultModel(null);
                    } else if (compModel == model) {
                        component.modelChanged();
                    }
                }
            });
        }
        return this;
    }

    public int size() {
        return this.children_size();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean detailed) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[').append(Classes.simpleName(this.getClass())).append(' ');
        buffer.append(super.toString(detailed));
        if (detailed && this.children_size() != 0) {
            buffer.append(", children = ");
            int size = this.children_size();
            for (int i = 0; i < size; ++i) {
                Component child = this.children_get(i);
                if (i != 0) {
                    buffer.append(' ');
                }
                buffer.append(child.toString());
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    public final <S extends Component, R> R visitChildren(Class<?> clazz, IVisitor<S, R> visitor) {
        return (R)Visits.visitChildren((Iterable)this, visitor, (IVisitFilter)new ClassVisitFilter(clazz));
    }

    public final <R> R visitChildren(IVisitor<Component, R> visitor) {
        return (R)Visits.visitChildren((Iterable)this, visitor);
    }

    @Deprecated
    public final ComponentHierarchyIterator visitChildren() {
        return new ComponentHierarchyIterator(this);
    }

    @Deprecated
    public final ComponentHierarchyIterator visitChildren(Class<?> clazz) {
        return new ComponentHierarchyIterator(this).filterByClass(clazz);
    }

    private void addedComponent(Component child) {
        Page page;
        Args.notNull((Object)child, (String)"child");
        MarkupContainer parent = child.getParent();
        if (parent != null) {
            parent.remove(child);
        }
        child.setParent(this);
        IDebugSettings debugSettings = Application.get().getDebugSettings();
        if (debugSettings.isLinePreciseReportingOnAddComponentEnabled() && debugSettings.getComponentUseCheck()) {
            child.setMetaData(ADDED_AT_KEY, ComponentStrings.toString(child, new MarkupException("added")));
        }
        if ((page = this.findPage()) != null) {
            page.componentAdded(child);
            if (page.isInitialized()) {
                child.internalInitialize();
            }
        }
        if (this.isPreparedForRender()) {
            child.beforeRender();
        }
    }

    @Override
    public final void internalInitialize() {
        super.fireInitialize();
        this.visitChildren(new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                component.fireInitialize();
            }
        });
    }

    private void children_add(Component child) {
        if (this.children == null) {
            this.children = child;
        } else {
            if (!(this.children instanceof ChildList)) {
                this.children = new ChildList(this.children);
            }
            ((ChildList)this.children).add(child);
        }
    }

    public final Component get(int index) {
        return this.children_get(index);
    }

    private Component children_get(int index) {
        return (Component)this.children_get(index, true);
    }

    private Object children_get(int index, boolean reconstruct) {
        Object component = null;
        if (this.children != null) {
            if (!(this.children instanceof Object[]) && !(this.children instanceof ChildList)) {
                if (index != 0) {
                    throw new ArrayIndexOutOfBoundsException("index " + index + " is greater then 0");
                }
                component = this.children;
            } else {
                Object[] children = this.children instanceof ChildList ? ((ChildList)this.children).childs : (Object[])this.children;
                component = children[index];
            }
        }
        return component;
    }

    private String getId(Object object) {
        if (object instanceof Component) {
            return ((Component)object).getId();
        }
        throw new IllegalArgumentException("Unknown type of object " + object);
    }

    private Component children_get(String id) {
        Component component;
        block5: {
            Object[] children;
            block4: {
                if (this.children == null) {
                    return null;
                }
                component = null;
                if (this.children instanceof Object[] || this.children instanceof List) break block4;
                if (!this.getId(this.children).equals(id)) break block5;
                component = (Component)this.children;
                break block5;
            }
            int size = 0;
            if (this.children instanceof ChildList) {
                children = ((ChildList)this.children).childs;
                size = ((ChildList)this.children).size;
            } else {
                children = (Object[])this.children;
                size = children.length;
            }
            for (int i = 0; i < size; ++i) {
                if (!this.getId(children[i]).equals(id)) continue;
                component = (Component)children[i];
                break;
            }
        }
        return component;
    }

    private int children_indexOf(Component child) {
        if (this.children == null) {
            return -1;
        }
        if (!(this.children instanceof Object[]) && !(this.children instanceof ChildList)) {
            if (this.getId(this.children).equals(child.getId())) {
                return 0;
            }
        } else {
            Object[] children;
            int size = 0;
            if (this.children instanceof Object[]) {
                children = (Object[])this.children;
                size = children.length;
            } else {
                children = ((ChildList)this.children).childs;
                size = ((ChildList)this.children).size;
            }
            for (int i = 0; i < size; ++i) {
                if (!this.getId(children[i]).equals(child.getId())) continue;
                return i;
            }
        }
        return -1;
    }

    private Component children_remove(Component component) {
        int index = this.children_indexOf(component);
        if (index != -1) {
            return this.children_remove(index);
        }
        return null;
    }

    private Component children_remove(int index) {
        Object removed;
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof Component) {
            if (index == 0) {
                Component removed2 = (Component)this.children;
                this.children = null;
                return removed2;
            }
            throw new IndexOutOfBoundsException();
        }
        if (this.children instanceof Object[]) {
            Object[] c = (Object[])this.children;
            removed = c[index];
            if (c.length == 2) {
                if (index == 0) {
                    this.children = c[1];
                } else if (index == 1) {
                    this.children = c[0];
                } else {
                    throw new IndexOutOfBoundsException();
                }
                return (Component)removed;
            }
            this.children = new ChildList(this.children);
        }
        ChildList lst = (ChildList)this.children;
        removed = lst.remove(index);
        if (lst.size == 1) {
            this.children = lst.get(0);
        }
        return (Component)removed;
    }

    private Object children_set(int index, Object child, boolean reconstruct) {
        Object replaced;
        if (index >= 0 && index < this.children_size()) {
            if (this.children instanceof Component) {
                replaced = this.children;
                this.children = child;
            } else if (this.children instanceof ChildList) {
                replaced = ((ChildList)this.children).set(index, child);
            } else {
                Object[] children = (Object[])this.children;
                replaced = children[index];
                children[index] = child;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return replaced;
    }

    private Component children_set(int index, Component child) {
        return (Component)this.children_set(index, child, true);
    }

    private int children_size() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof Component) {
            return 1;
        }
        if (this.children instanceof ChildList) {
            return ((ChildList)this.children).size;
        }
        return ((Object[])this.children).length;
    }

    private Component put(Component child) {
        int index = this.children_indexOf(child);
        if (index == -1) {
            this.children_add(child);
            return null;
        }
        return this.children_set(index, child);
    }

    private void removedComponent(Component component) {
        Page page = component.findPage();
        if (page != null) {
            page.componentRemoved(component);
        }
        component.detach();
        component.internalOnRemove();
        component.setParent(null);
    }

    protected boolean renderNext(MarkupStream markupStream) {
        MarkupElement element = markupStream.get();
        if (element instanceof ComponentTag && !markupStream.atCloseTag()) {
            ComponentTag tag = (ComponentTag)element;
            if (tag instanceof WicketTag && ((WicketTag)tag).isFragmentTag()) {
                return false;
            }
            String id = tag.getId();
            Component component = this.get(id);
            if (component == null) {
                component = ComponentResolvers.resolve(this, markupStream, tag, null);
                if (component != null && component.getParent() == null) {
                    this.autoAdd(component, markupStream);
                } else if (component != null) {
                    component.setMarkup(markupStream.getMarkupFragment());
                }
            }
            if (component != null) {
                component.render();
            } else {
                if (tag.getFlag(32)) {
                    this.getResponse().write(element.toCharSequence());
                    return true;
                }
                if (tag instanceof WicketTag) {
                    if (((WicketTag)tag).isChildTag()) {
                        markupStream.throwMarkupException("Found " + tag.toString() + " but no <wicket:extend>. Container: " + this.toString());
                    } else {
                        markupStream.throwMarkupException("Failed to handle: " + tag.toString() + ". It might be that no resolver has been registered to handle this special tag. " + " But it also could be that you declared wicket:id=" + id + " in your markup, but that you either did not add the " + "component to your page at all, or that the hierarchy does not match. " + "Container: " + this.toString());
                    }
                }
                List<String> names = this.findSimilarComponents(id);
                StringBuilder msg = new StringBuilder(500);
                msg.append("Unable to find component with id '");
                msg.append(id);
                msg.append("' in ");
                msg.append(this.toString());
                msg.append("\n\tExpected: '");
                msg.append(this.getPageRelativePath());
                msg.append(':');
                msg.append(id);
                msg.append("'.\n\tFound with similar names: '");
                msg.append(Strings.join((String)"', ", names));
                msg.append('\'');
                log.error(msg.toString());
                markupStream.throwMarkupException(msg.toString());
            }
        } else {
            this.getResponse().write(element.toCharSequence());
            return true;
        }
        return false;
    }

    private List<String> findSimilarComponents(final String id) {
        final ArrayList names = Generics.newArrayList();
        Page page = this.findPage();
        if (page != null) {
            page.visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    if (Strings.getLevenshteinDistance((CharSequence)id.toLowerCase(), (CharSequence)component.getId().toLowerCase()) < 3) {
                        names.add(component.getPageRelativePath());
                    }
                }
            });
        }
        return names;
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.renderComponentTagBody(markupStream, openTag);
    }

    @Override
    protected void onRender() {
        this.internalRenderComponent();
    }

    private void renderComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        ComponentTag origOpenTag;
        if (markupStream != null && markupStream.getCurrentIndex() > 0 && (origOpenTag = (ComponentTag)markupStream.get(markupStream.getCurrentIndex() - 1)).isOpenClose()) {
            return;
        }
        boolean render = openTag.requiresCloseTag();
        if (!render) {
            boolean bl = render = !openTag.hasNoCloseTag();
        }
        if (render) {
            this.renderAll(markupStream, openTag);
        }
    }

    protected final void renderAll(MarkupStream markupStream, ComponentTag openTag) {
        while (markupStream.isCurrentIndexInsideTheStream() && (openTag == null || !markupStream.get().closes(openTag))) {
            int index = markupStream.getCurrentIndex();
            boolean rawMarkup = this.renderNext(markupStream);
            markupStream.setCurrentIndex(index);
            if (rawMarkup) {
                markupStream.next();
                continue;
            }
            if (!markupStream.getTag().isClose()) {
                markupStream.skipComponent();
                continue;
            }
            throw new WicketRuntimeException("Ups. This should never happen. " + markupStream.toString());
        }
    }

    @Override
    void removeChildren() {
        super.removeChildren();
        int i = this.children_size();
        while (i-- > 0) {
            Object child = this.children_get(i, false);
            if (!(child instanceof Component)) continue;
            Component component = (Component)child;
            component.internalOnRemove();
        }
    }

    @Override
    void detachChildren() {
        super.detachChildren();
        int i = this.children_size();
        while (i-- > 0) {
            Object child = this.children_get(i, false);
            if (!(child instanceof Component)) continue;
            Component component = (Component)child;
            component.detach();
            if (component instanceof InlineEnclosure || !component.isAuto()) continue;
            this.children_remove(i);
        }
        if (this.children instanceof ChildList) {
            ChildList lst = (ChildList)this.children;
            Object[] tmp = new Object[lst.size];
            System.arraycopy(lst.childs, 0, tmp, 0, lst.size);
            this.children = tmp;
        }
    }

    @Override
    void internalMarkRendering(boolean setRenderingFlag) {
        super.internalMarkRendering(setRenderingFlag);
        int size = this.children_size();
        for (int i = 0; i < size; ++i) {
            Component child = this.children_get(i);
            child.internalMarkRendering(setRenderingFlag);
        }
    }

    private Component[] copyChildren() {
        int size = this.children_size();
        Component[] result = new Component[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.children_get(i);
        }
        return result;
    }

    @Override
    void onBeforeRenderChildren() {
        super.onBeforeRenderChildren();
        Component[] children = this.copyChildren();
        try {
            for (Component child : children) {
                if (child.getParent() != this) continue;
                child.beforeRender();
            }
        }
        catch (RuntimeException ex) {
            if (ex instanceof WicketRuntimeException) {
                throw ex;
            }
            throw new WicketRuntimeException("Error attaching this container for rendering: " + this, ex);
        }
    }

    @Override
    void onEnabledStateChanged() {
        super.onEnabledStateChanged();
        this.visitChildren(new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                component.clearEnabledInHierarchyCache();
            }
        });
    }

    @Override
    void onVisibleStateChanged() {
        super.onVisibleStateChanged();
        this.visitChildren(new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                component.clearVisibleInHierarchyCache();
            }
        });
    }

    @Override
    protected void onAfterRenderChildren() {
        for (Component child : this) {
            child.markRendering(false);
        }
        super.onAfterRenderChildren();
    }

    public final void swap(int idx1, int idx2) {
        int size = this.children_size();
        if (idx1 < 0 || idx1 >= size) {
            throw new IndexOutOfBoundsException("Argument idx is out of bounds: " + idx1 + "<>[0," + size + ")");
        }
        if (idx2 < 0 || idx2 >= size) {
            throw new IndexOutOfBoundsException("Argument idx is out of bounds: " + idx2 + "<>[0," + size + ")");
        }
        if (idx1 == idx2) {
            return;
        }
        if (this.children instanceof Object[]) {
            Object[] array = (Object[])this.children;
            Object tmp = array[idx1];
            array[idx1] = array[idx2];
            array[idx2] = tmp;
        } else {
            ChildList list = (ChildList)this.children;
            Object tmp = list.childs[idx1];
            ((ChildList)list).childs[idx1] = list.childs[idx2];
            ((ChildList)list).childs[idx2] = tmp;
        }
    }

    private void createAndAddComponentsForWicketTags() {
        IMarkupFragment markup = this.getMarkup();
        if (markup != null && markup.size() > 1) {
            MarkupStream stream = new MarkupStream(markup);
            if (stream.skipUntil(ComponentTag.class)) {
                stream.next();
            }
            while (stream.skipUntil(ComponentTag.class)) {
                ComponentTag tag = stream.getTag();
                if (tag.isOpen() || tag.isOpenClose()) {
                    Component component;
                    if (tag instanceof WicketTag && (component = ComponentResolvers.resolve(this, stream, tag, null)) != null && component.getParent() == null) {
                        if (!component.getId().equals(tag.getId())) {
                            tag.setId(component.getId());
                            tag.setModified(true);
                        }
                        this.add(component);
                    }
                    if (tag.isOpen()) {
                        stream.skipToMatchingCloseTag(tag);
                    }
                }
                stream.next();
            }
        }
    }

    private static class ChildList
    extends AbstractList<Object>
    implements IClusterable {
        private static final long serialVersionUID = -7861580911447631127L;
        private int size;
        private Object[] childs;

        public ChildList(Object children) {
            if (children instanceof Object[]) {
                this.childs = (Object[])children;
                this.size = this.childs.length;
            } else {
                this.childs = new Object[3];
                this.add(children);
            }
        }

        @Override
        public Object get(int index) {
            return this.childs[index];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(Object o) {
            this.ensureCapacity(this.size + 1);
            this.childs[this.size++] = o;
            return true;
        }

        @Override
        public void add(int index, Object element) {
            if (index > this.size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            this.ensureCapacity(this.size + 1);
            System.arraycopy(this.childs, index, this.childs, index + 1, this.size - index);
            this.childs[index] = element;
            ++this.size;
        }

        @Override
        public Object set(int index, Object element) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            Object oldValue = this.childs[index];
            this.childs[index] = element;
            return oldValue;
        }

        @Override
        public Object remove(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            Object oldValue = this.childs[index];
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.childs, index + 1, this.childs, index, numMoved);
            }
            this.childs[--this.size] = null;
            return oldValue;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.childs.length;
            if (minCapacity > oldCapacity) {
                Object[] oldData = this.childs;
                int newCapacity = oldCapacity * 2;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.childs = new Object[newCapacity];
                System.arraycopy(oldData, 0, this.childs, 0, this.size);
            }
        }
    }
}

