/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.value.IValueMap;

public class AttributeModifier
extends Behavior
implements IClusterable {
    public static final String VALUELESS_ATTRIBUTE_ADD = new String("VALUELESS_ATTRIBUTE_ADD");
    public static final String VALUELESS_ATTRIBUTE_REMOVE = new String("VALUELESS_ATTRIBUTE_REMOVE");
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final IModel<?> replaceModel;

    @Deprecated
    public AttributeModifier(String attribute, boolean addAttributeIfNotPresent, IModel<?> replaceModel) {
        this(attribute, replaceModel);
    }

    public AttributeModifier(String attribute, IModel<?> replaceModel) {
        Args.notNull((Object)attribute, (String)"attribute");
        this.attribute = attribute;
        this.replaceModel = replaceModel;
    }

    public AttributeModifier(String attribute, Serializable value) {
        this(attribute, AttributeModifier.createModel(value));
    }

    private static IModel<?> createModel(Serializable value) {
        IModel<Serializable> model = value == VALUELESS_ATTRIBUTE_ADD ? new ValuelessAttributeAddModel() : (value == VALUELESS_ATTRIBUTE_REMOVE ? new ValuelessAttributeRemoveModel() : Model.of(value));
        return model;
    }

    @Override
    public final void detach(Component component) {
        if (this.replaceModel != null) {
            this.replaceModel.detach();
        }
    }

    public final String getAttribute() {
        return this.attribute;
    }

    @Override
    public final void onComponentTag(Component component, ComponentTag tag) {
        if (tag.getType() != XmlTag.TagType.CLOSE) {
            this.replaceAttributeValue(component, tag);
        }
    }

    public final void replaceAttributeValue(Component component, ComponentTag tag) {
        if (this.isEnabled(component)) {
            IValueMap attributes = tag.getAttributes();
            Object replacementValue = this.getReplacementOrNull(component);
            if (VALUELESS_ATTRIBUTE_ADD == replacementValue) {
                attributes.put((Object)this.attribute, null);
            } else if (VALUELESS_ATTRIBUTE_REMOVE == replacementValue) {
                attributes.remove((Object)this.attribute);
            } else {
                String value = this.toStringOrNull(attributes.get((Object)this.attribute));
                String newValue = this.newValue(value, this.toStringOrNull(replacementValue));
                if (newValue == VALUELESS_ATTRIBUTE_REMOVE) {
                    attributes.remove((Object)this.attribute);
                } else if (newValue != null) {
                    attributes.put((Object)this.attribute, (Object)newValue);
                }
            }
        }
    }

    public String toString() {
        return "[AttributeModifier attribute=" + this.attribute + ", replaceModel=" + this.replaceModel + "]";
    }

    private Object getReplacementOrNull(Component component) {
        IModel<?> model = this.replaceModel;
        if (model instanceof IComponentAssignedModel) {
            model = ((IComponentAssignedModel)model).wrapOnAssignment(component);
        }
        return model != null ? model.getObject() : null;
    }

    private String toStringOrNull(Object replacementValue) {
        return replacementValue != null ? replacementValue.toString() : null;
    }

    protected final IModel<?> getReplaceModel() {
        return this.replaceModel;
    }

    protected String newValue(String currentValue, String replacementValue) {
        return replacementValue;
    }

    public static AttributeModifier replace(String attributeName, IModel<?> value) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        return new AttributeModifier(attributeName, value);
    }

    public static AttributeModifier replace(String attributeName, Serializable value) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        return new AttributeModifier(attributeName, value);
    }

    public static AttributeAppender append(String attributeName, IModel<?> value) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        return new AttributeAppender(attributeName, value).setSeparator(" ");
    }

    public static AttributeAppender append(String attributeName, Serializable value) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        return AttributeModifier.append(attributeName, AttributeModifier.createModel(value));
    }

    public static AttributeAppender prepend(String attributeName, IModel<?> value) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        return new AttributeAppender(attributeName, (IModel)value){
            private static final long serialVersionUID = 1L;

            @Override
            protected String newValue(String currentValue, String replacementValue) {
                return super.newValue(replacementValue, currentValue);
            }
        }.setSeparator(" ");
    }

    public static AttributeAppender prepend(String attributeName, Serializable value) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        return AttributeModifier.prepend(attributeName, AttributeModifier.createModel(value));
    }

    public static AttributeModifier remove(String attributeName) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        return AttributeModifier.replace(attributeName, AttributeModifier.createModel((Serializable)((Object)VALUELESS_ATTRIBUTE_REMOVE)));
    }

    public static class ValuelessAttributeRemoveModel
    extends AbstractReadOnlyModel<Serializable> {
        @Override
        public Serializable getObject() {
            return VALUELESS_ATTRIBUTE_REMOVE;
        }
    }

    public static class ValuelessAttributeAddModel
    extends AbstractReadOnlyModel<Serializable> {
        @Override
        public Serializable getObject() {
            return VALUELESS_ATTRIBUTE_ADD;
        }
    }
}

