/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authroles.authorization.strategies.role.metadata;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.AbstractRoleAuthorizationStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.ActionPermissions;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.InstantiationPermissions;
import org.apache.wicket.request.component.IRequestableComponent;

public class MetaDataRoleAuthorizationStrategy
extends AbstractRoleAuthorizationStrategy {
    public static final MetaDataKey<ActionPermissions> ACTION_PERMISSIONS = new MetaDataKey<ActionPermissions>(){
        private static final long serialVersionUID = 1L;
    };
    public static final MetaDataKey<InstantiationPermissions> INSTANTIATION_PERMISSIONS = new MetaDataKey<InstantiationPermissions>(){
        private static final long serialVersionUID = 1L;
    };
    public static final String NO_ROLE = "wicket:NO_ROLE";

    public static final <T extends Component> void authorize(Class<T> componentClass, String roles) {
        Application application = Application.get();
        InstantiationPermissions permissions = (InstantiationPermissions)application.getMetaData(INSTANTIATION_PERMISSIONS);
        if (permissions == null) {
            permissions = new InstantiationPermissions();
            application.setMetaData(INSTANTIATION_PERMISSIONS, (Object)permissions);
        }
        permissions.authorize(componentClass, new Roles(roles));
    }

    public static final void authorize(Component component, Action action, String roles) {
        ActionPermissions permissions = (ActionPermissions)((Object)component.getMetaData(ACTION_PERMISSIONS));
        if (permissions == null) {
            permissions = new ActionPermissions();
            component.setMetaData(ACTION_PERMISSIONS, (Object)permissions);
        }
        permissions.authorize(action, new Roles(roles));
    }

    public static final <T extends Component> void authorizeAll(Class<T> componentClass) {
        Application application = Application.get();
        InstantiationPermissions authorizedRoles = (InstantiationPermissions)application.getMetaData(INSTANTIATION_PERMISSIONS);
        if (authorizedRoles != null) {
            authorizedRoles.authorizeAll(componentClass);
        }
    }

    public static final void authorizeAll(Component component, Action action) {
        ActionPermissions permissions = (ActionPermissions)((Object)component.getMetaData(ACTION_PERMISSIONS));
        if (permissions != null) {
            permissions.authorizeAll(action);
        }
    }

    public static final <T extends Component> void unauthorize(Class<T> componentClass, String roles) {
        InstantiationPermissions permissions = (InstantiationPermissions)Application.get().getMetaData(INSTANTIATION_PERMISSIONS);
        if (permissions != null) {
            permissions.unauthorize(componentClass, new Roles(roles));
        }
    }

    public static final void unauthorize(Component component, Action action, String roles) {
        ActionPermissions permissions = (ActionPermissions)((Object)component.getMetaData(ACTION_PERMISSIONS));
        if (permissions != null) {
            permissions.unauthorize(action, new Roles(roles));
        }
    }

    public static final <T extends Component> void unauthorizeAll(Class<T> componentClass) {
        MetaDataRoleAuthorizationStrategy.authorizeAll(componentClass);
        MetaDataRoleAuthorizationStrategy.authorize(componentClass, NO_ROLE);
    }

    public static final void unauthorizeAll(Component component, Action action) {
        MetaDataRoleAuthorizationStrategy.authorizeAll(component, action);
        MetaDataRoleAuthorizationStrategy.authorize(component, action, NO_ROLE);
    }

    public MetaDataRoleAuthorizationStrategy(IRoleCheckingStrategy roleCheckingStrategy) {
        super(roleCheckingStrategy);
    }

    public boolean isActionAuthorized(Component component, Action action) {
        if (component == null) {
            throw new IllegalArgumentException("argument component has to be not null");
        }
        if (action == null) {
            throw new IllegalArgumentException("argument action has to be not null");
        }
        Roles roles = MetaDataRoleAuthorizationStrategy.rolesAuthorizedToPerformAction(component, action);
        if (roles != null) {
            return this.hasAny(roles);
        }
        return true;
    }

    public <T extends IRequestableComponent> boolean isInstantiationAuthorized(Class<T> componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException("argument componentClass cannot be null");
        }
        if (!Component.class.isAssignableFrom(componentClass)) {
            throw new IllegalArgumentException("argument componentClass must be of type " + Component.class.getName());
        }
        Roles roles = MetaDataRoleAuthorizationStrategy.rolesAuthorizedToInstantiate(componentClass);
        if (roles != null) {
            return this.hasAny(roles);
        }
        return true;
    }

    private static <T extends IRequestableComponent> Roles rolesAuthorizedToInstantiate(Class<T> componentClass) {
        InstantiationPermissions permissions = (InstantiationPermissions)Application.get().getMetaData(INSTANTIATION_PERMISSIONS);
        if (permissions != null) {
            return permissions.authorizedRoles(componentClass);
        }
        return null;
    }

    private static Roles rolesAuthorizedToPerformAction(Component component, Action action) {
        ActionPermissions permissions = (ActionPermissions)((Object)component.getMetaData(ACTION_PERMISSIONS));
        if (permissions != null) {
            return permissions.rolesFor(action);
        }
        return null;
    }
}

