/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.jbosslogging;

import java.text.MessageFormat;
import org.jboss.logging.Logger;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;

public class JBossLoggingLogger
extends Logger
implements PaxLoggingManagerAwareLogger {
    static final String JBOSS_LOGGING_FQCN = JBossLoggingLogger.class.getName();
    private String m_name;
    private volatile PaxLogger m_delegate;

    public JBossLoggingLogger(String name, PaxLogger delegate) {
        super(name);
        this.m_name = name;
        this.m_delegate = delegate;
    }

    @Override
    public void setPaxLoggingManager(PaxLoggingManager manager) {
        this.m_delegate = manager == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(JBossLoggingLogger.class), this.m_name) : manager.getLogger(this.m_name, JBOSS_LOGGING_FQCN);
    }

    @Override
    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        String text = parameters == null || parameters.length == 0 ? String.valueOf(message) : MessageFormat.format(String.valueOf(message), parameters);
        switch (level) {
            case FATAL: {
                this.m_delegate.fatal(text, thrown, loggerClassName);
                break;
            }
            case ERROR: {
                this.m_delegate.error(text, thrown, loggerClassName);
                break;
            }
            case WARN: {
                this.m_delegate.warn(text, thrown, loggerClassName);
                break;
            }
            case INFO: {
                this.m_delegate.inform(text, thrown, loggerClassName);
                break;
            }
            case DEBUG: {
                this.m_delegate.debug(text, thrown, loggerClassName);
                break;
            }
            case TRACE: {
                this.m_delegate.trace(text, thrown, loggerClassName);
            }
        }
    }

    @Override
    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        if (parameters == null || parameters.length == 0) {
            this.doLog(level, loggerClassName, format, parameters, thrown);
        } else {
            String message = String.format(String.valueOf(format), parameters);
            this.doLog(level, loggerClassName, message, null, thrown);
        }
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        switch (level) {
            case FATAL: {
                return this.m_delegate.isFatalEnabled();
            }
            case ERROR: {
                return this.m_delegate.isErrorEnabled();
            }
            case WARN: {
                return this.m_delegate.isWarnEnabled();
            }
            case INFO: {
                return this.m_delegate.isInfoEnabled();
            }
            case DEBUG: {
                return this.m_delegate.isDebugEnabled();
            }
            case TRACE: {
                return this.m_delegate.isTraceEnabled();
            }
        }
        return false;
    }
}

