/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.impl.LocalRepositoryProvider;
import shaded.org.eclipse.aether.internal.impl.PrioritizedComponent;
import shaded.org.eclipse.aether.internal.impl.PrioritizedComponents;
import shaded.org.eclipse.aether.internal.impl.Utils;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import shaded.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import shaded.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.spi.locator.Service;
import shaded.org.eclipse.aether.spi.locator.ServiceLocator;

@Named
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalRepositoryProvider.class);
    private Collection<LocalRepositoryManagerFactory> managerFactories = new ArrayList<LocalRepositoryManagerFactory>();

    public DefaultLocalRepositoryProvider() {
    }

    @Inject
    DefaultLocalRepositoryProvider(Set<LocalRepositoryManagerFactory> factories) {
        this.setLocalRepositoryManagerFactories(factories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLocalRepositoryManagerFactories(locator.getServices(LocalRepositoryManagerFactory.class));
    }

    public DefaultLocalRepositoryProvider addLocalRepositoryManagerFactory(LocalRepositoryManagerFactory factory) {
        this.managerFactories.add(Objects.requireNonNull(factory, "local repository manager factory cannot be null"));
        return this;
    }

    public DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(Collection<LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        PrioritizedComponents<LocalRepositoryManagerFactory> factories = new PrioritizedComponents<LocalRepositoryManagerFactory>(session);
        for (LocalRepositoryManagerFactory factory : this.managerFactories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoLocalRepositoryManagerException> errors = new ArrayList<NoLocalRepositoryManagerException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                LocalRepositoryManager localRepositoryManager = ((LocalRepositoryManagerFactory)factory.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using manager ").append(localRepositoryManager.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, localRepositoryManager);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getBasedir());
                    LOGGER.debug(buffer.toString());
                }
                return localRepositoryManager;
            }
            catch (NoLocalRepositoryManagerException noLocalRepositoryManagerException) {
                errors.add(noLocalRepositoryManagerException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain local repository manager for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(msg, (Throwable)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No local repository managers registered");
        } else {
            buffer.append("Cannot access ").append(repository.getBasedir());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available factories ");
            factories.list(buffer);
        }
        throw new NoLocalRepositoryManagerException(repository, buffer.toString(), errors.size() == 1 ? (NoLocalRepositoryManagerException)errors.get(0) : null);
    }
}

