/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.ops4j.lang.NullArgumentException;

public class MavenRepositoryURL {
    private static final Logger LOG = LoggerFactory.getLogger(MavenRepositoryURL.class);
    private final String m_id;
    private final URL m_repositoryURL;
    private final File m_file;
    private final boolean m_snapshotsEnabled;
    private final boolean m_releasesEnabled;
    private final String m_releasesUpdatePolicy;
    private final String m_snapshotsUpdatePolicy;
    private final String m_releasesChecksumPolicy;
    private final String m_snapshotsChecksumPolicy;
    private final boolean m_multi;

    public MavenRepositoryURL(String repositorySpec) throws MalformedURLException {
        NullArgumentException.validateNotEmpty(repositorySpec, true, "Repository spec");
        String[] segments = repositorySpec.split("@");
        StringBuilder urlBuilder = new StringBuilder();
        boolean snapshotEnabled = false;
        boolean releasesEnabled = true;
        boolean multi = false;
        String name = null;
        String update = null;
        String updateReleases = null;
        String updateSnapshots = null;
        String checksum = null;
        String checksumReleases = null;
        String checksumSnapshots = null;
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i].trim();
            if (segment.equalsIgnoreCase("snapshots")) {
                snapshotEnabled = true;
                continue;
            }
            if (segment.equalsIgnoreCase("noreleases")) {
                releasesEnabled = false;
                continue;
            }
            if (segment.equalsIgnoreCase("multi")) {
                multi = true;
                continue;
            }
            if (segment.startsWith("id=")) {
                try {
                    name = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("releasesUpdate=")) {
                try {
                    updateReleases = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("snapshotsUpdate=")) {
                try {
                    updateSnapshots = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("update=")) {
                try {
                    update = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("releasesChecksum=")) {
                try {
                    checksumReleases = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("snapshotsChecksum=")) {
                try {
                    checksumSnapshots = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("checksum=")) {
                try {
                    checksum = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (i > 0) {
                urlBuilder.append("@");
            }
            urlBuilder.append(segments[i]);
        }
        String spec = this.buildSpec(urlBuilder);
        this.m_repositoryURL = new URL(spec);
        this.m_snapshotsEnabled = snapshotEnabled;
        this.m_releasesEnabled = releasesEnabled;
        this.m_multi = multi;
        if (name == null) {
            String warn = "Repository spec " + spec + " does not contain an identifier. Give your repository a name, for example: " + repositorySpec + "@id=MyName";
            LOG.warn(warn);
            name = "repo_" + spec.hashCode();
        }
        this.m_id = name;
        this.m_releasesUpdatePolicy = updateReleases != null ? updateReleases : update;
        this.m_snapshotsUpdatePolicy = updateSnapshots != null ? updateSnapshots : update;
        this.m_releasesChecksumPolicy = checksumReleases != null ? checksumReleases : checksum;
        String string = this.m_snapshotsChecksumPolicy = checksumSnapshots != null ? checksumSnapshots : checksum;
        if (this.m_repositoryURL.getProtocol().equals("file")) {
            try {
                spec = spec.replaceAll("\\\\", "/");
                spec = spec.replaceAll(" ", "%20");
                URI uri = new URI(spec);
                String path = uri.getPath();
                if (path == null) {
                    path = uri.getSchemeSpecificPart();
                }
                this.m_file = new File(path);
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
        } else {
            this.m_file = null;
        }
    }

    private String buildSpec(StringBuilder urlBuilder) {
        String spec = urlBuilder.toString().trim();
        if (!spec.endsWith("\\") && !spec.endsWith("/")) {
            spec = spec + "/";
        }
        return spec;
    }

    public String getId() {
        return this.m_id;
    }

    public URL getURL() {
        return this.m_repositoryURL;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isReleasesEnabled() {
        return this.m_releasesEnabled;
    }

    public boolean isSnapshotsEnabled() {
        return this.m_snapshotsEnabled;
    }

    public String getReleasesUpdatePolicy() {
        return this.m_releasesUpdatePolicy;
    }

    public String getSnapshotsUpdatePolicy() {
        return this.m_snapshotsUpdatePolicy;
    }

    public String getReleasesChecksumPolicy() {
        return this.m_releasesChecksumPolicy;
    }

    public String getSnapshotsChecksumPolicy() {
        return this.m_snapshotsChecksumPolicy;
    }

    public boolean isMulti() {
        return this.m_multi;
    }

    public boolean isFileRepository() {
        return this.m_file != null;
    }

    public String toString() {
        return this.m_repositoryURL.toString() + ",releases=" + this.m_releasesEnabled + ",snapshots=" + this.m_snapshotsEnabled;
    }
}

