/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="File based state repository")
public class FileStateRepository
extends ServiceSupport
implements StateRepository<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(FileStateRepository.class);
    private static final String STORE_DELIMITER = "\n";
    private static final String KEY_VALUE_DELIMITER = "=";
    private final AtomicBoolean init = new AtomicBoolean();
    private Map<String, String> cache;
    private File fileStore;
    private long maxFileStoreSize = 1024000L;

    public FileStateRepository() {
        this.cache = new HashMap<String, String>();
    }

    public FileStateRepository(File fileStore, Map<String, String> cache) {
        this.fileStore = fileStore;
        this.cache = cache;
    }

    public static FileStateRepository fileStateRepository(File fileStore) {
        return FileStateRepository.fileStateRepository(fileStore, new HashMap<String, String>());
    }

    public static FileStateRepository fileStateRepository(File fileStore, long maxFileStoreSize) {
        FileStateRepository repository = new FileStateRepository(fileStore, new HashMap<String, String>());
        repository.setMaxFileStoreSize(maxFileStoreSize);
        return repository;
    }

    public static FileStateRepository fileStateRepository(File store, Map<String, String> cache) {
        return new FileStateRepository(store, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Adds the value of the given key to the store")
    public void setState(String key, String value) {
        if (key.contains(KEY_VALUE_DELIMITER)) {
            throw new IllegalArgumentException("Key " + key + " contains illegal character: " + KEY_VALUE_DELIMITER);
        }
        if (key.contains(STORE_DELIMITER)) {
            throw new IllegalArgumentException("Key " + key + " contains illegal character: <newline>");
        }
        if (value.contains(STORE_DELIMITER)) {
            throw new IllegalArgumentException("Value " + value + " contains illegal character: <newline>");
        }
        Map<String, String> map = this.cache;
        synchronized (map) {
            this.cache.put(key, value);
            if (this.fileStore.length() < this.maxFileStoreSize) {
                this.appendToStore(key, value);
            } else {
                this.trunkStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Gets the value of the given key from store")
    public String getState(String key) {
        Map<String, String> map = this.cache;
        synchronized (map) {
            return this.cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Reset and reloads the file store")
    public synchronized void reset() throws IOException {
        Map<String, String> map = this.cache;
        synchronized (map) {
            this.trunkStore();
            this.cache.clear();
            this.loadStore();
        }
    }

    private void appendToStore(String key, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Appending {}={} to state filestore: {}", new Object[]{key, value, this.fileStore});
        }
        FileOutputStream fos = null;
        try {
            File storeParentDirectory = this.fileStore.getParentFile();
            if (storeParentDirectory != null && !storeParentDirectory.exists()) {
                LOG.info("Parent directory of file store {} doesn't exist. Creating.", (Object)this.fileStore);
                if (this.fileStore.getParentFile().mkdirs()) {
                    LOG.info("Parent directory of file store {} successfully created.", (Object)this.fileStore);
                } else {
                    LOG.warn("Parent directory of file store {} cannot be created.", (Object)this.fileStore);
                }
            }
            if (!this.fileStore.exists()) {
                FileUtil.createNewFile(this.fileStore);
            }
            fos = new FileOutputStream(this.fileStore, true);
            fos.write(key.getBytes());
            fos.write(KEY_VALUE_DELIMITER.getBytes());
            fos.write(value.getBytes());
            fos.write(STORE_DELIMITER.getBytes());
        }
        catch (IOException e) {
            try {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            catch (Throwable throwable) {
                IOHelper.close(fos, "Appending to file state repository", LOG);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)fos, "Appending to file state repository", LOG);
    }

    protected void trunkStore() {
        LOG.info("Trunking state filestore: {}", (Object)this.fileStore);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.fileStore);
            for (Map.Entry<String, String> entry : this.cache.entrySet()) {
                fos.write(entry.getKey().getBytes());
                fos.write(KEY_VALUE_DELIMITER.getBytes());
                fos.write(entry.getValue().getBytes());
                fos.write(STORE_DELIMITER.getBytes());
            }
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        finally {
            IOHelper.close((Closeable)fos, "Trunking file state repository", LOG);
        }
    }

    protected void loadStore() throws IOException {
        if (!this.fileStore.exists()) {
            boolean created;
            LOG.debug("Creating filestore: {}", (Object)this.fileStore);
            File parent = this.fileStore.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            if (!(created = FileUtil.createNewFile(this.fileStore))) {
                throw new IOException("Cannot create filestore: " + this.fileStore);
            }
        }
        LOG.trace("Loading to 1st level cache from state filestore: {}", (Object)this.fileStore);
        this.cache.clear();
        try (Scanner scanner = null;){
            scanner = new Scanner(this.fileStore);
            scanner.useDelimiter(STORE_DELIMITER);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                int separatorIndex = line.indexOf(KEY_VALUE_DELIMITER);
                String key = line.substring(0, separatorIndex);
                String value = line.substring(separatorIndex + KEY_VALUE_DELIMITER.length());
                this.cache.put(key, value);
            }
        }
        LOG.debug("Loaded {} to the 1st level cache from state filestore: {}", (Object)this.cache.size(), (Object)this.fileStore);
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.fileStore, "fileStore", this);
        if (this.init.compareAndSet(false, true)) {
            this.loadStore();
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.trunkStore();
        this.cache.clear();
        this.init.set(false);
    }

    public File getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(File fileStore) {
        this.fileStore = fileStore;
    }

    @ManagedAttribute(description="The file path for the store")
    public String getFilePath() {
        return this.fileStore.getPath();
    }

    public Map<String, String> getCache() {
        return this.cache;
    }

    public void setCache(Map<String, String> cache) {
        this.cache = cache;
    }

    @ManagedAttribute(description="The maximum file size for the file store in bytes")
    public long getMaxFileStoreSize() {
        return this.maxFileStoreSize;
    }

    @ManagedAttribute(description="The maximum file size for the file store in bytes")
    public void setMaxFileStoreSize(long maxFileStoreSize) {
        this.maxFileStoreSize = maxFileStoreSize;
    }
}

