/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.HelpOption;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.commands.ansi.SimpleAnsi;
import org.apache.karaf.shell.console.Completer;

public class ActionMetaData {
    private final Class<? extends Action> actionClass;
    private final Command command;
    private final Map<Option, Field> options;
    private final Map<Argument, Field> arguments;
    List<Argument> orderedArguments;
    private final Completer[] completers;

    public ActionMetaData(Class<? extends Action> actionClass, Command command, Map<Option, Field> options, Map<Argument, Field> args, List<Argument> orderedArguments, Completer[] completers) {
        this.actionClass = actionClass;
        this.command = command;
        this.options = options;
        this.arguments = args;
        this.orderedArguments = orderedArguments;
        this.completers = completers;
    }

    public Class<? extends Action> getActionClass() {
        return this.actionClass;
    }

    public Command getCommand() {
        return this.command;
    }

    public Map<Option, Field> getOptions() {
        return this.options;
    }

    public Map<Argument, Field> getArguments() {
        return this.arguments;
    }

    public Completer[] getCompleters() {
        return this.completers;
    }

    public List<Argument> getOrderedArguments() {
        return this.orderedArguments;
    }

    public void printUsage(Action action, PrintStream out, boolean globalScope, int termWidth) {
        if (this.command != null) {
            ArrayList<Argument> argumentsSet = new ArrayList<Argument>(this.arguments.keySet());
            argumentsSet.sort(Comparator.comparing(Argument::index));
            HashSet<Option> optionsSet = new HashSet<Option>(this.options.keySet());
            optionsSet.add(HelpOption.HELP);
            if (this.command != null && (this.command.description() != null || this.command.name() != null)) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "DESCRIPTION" + SimpleAnsi.INTENSITY_NORMAL);
                out.print("        ");
                if (this.command.name() != null) {
                    if (globalScope) {
                        out.println(SimpleAnsi.INTENSITY_BOLD + this.command.name() + SimpleAnsi.INTENSITY_NORMAL);
                    } else {
                        out.println(this.command.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + this.command.name() + SimpleAnsi.INTENSITY_NORMAL);
                    }
                    out.println();
                }
                out.print("\t");
                out.println(this.command.description());
                out.println();
            }
            StringBuilder syntax = new StringBuilder();
            if (this.command != null) {
                if (globalScope) {
                    syntax.append(this.command.name());
                } else {
                    syntax.append(String.format("%s:%s", this.command.scope(), this.command.name()));
                }
            }
            if (this.options.size() > 0) {
                syntax.append(" [options]");
            }
            if (this.arguments.size() > 0) {
                syntax.append(' ');
                for (Argument argument : argumentsSet) {
                    if (!argument.required()) {
                        syntax.append(String.format("[%s] ", argument.name()));
                        continue;
                    }
                    syntax.append(String.format("%s ", argument.name()));
                }
            }
            out.println(SimpleAnsi.INTENSITY_BOLD + "SYNTAX" + SimpleAnsi.INTENSITY_NORMAL);
            out.print("        ");
            out.println(syntax.toString());
            out.println();
            if (this.arguments.size() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "ARGUMENTS" + SimpleAnsi.INTENSITY_NORMAL);
                for (Argument argument : argumentsSet) {
                    out.print("        ");
                    out.println(SimpleAnsi.INTENSITY_BOLD + argument.name() + SimpleAnsi.INTENSITY_NORMAL);
                    ActionMetaData.printFormatted("                ", argument.description(), termWidth, out, true);
                    if (argument.required() || argument.valueToShowInHelp() == null || argument.valueToShowInHelp().length() == 0) continue;
                    if ("DEFAULT".equals(argument.valueToShowInHelp())) {
                        Object o = this.getDefaultValue(action, argument);
                        String string = this.getDefaultValueString(o);
                        if (string == null) continue;
                        this.printDefaultsTo(out, string);
                        continue;
                    }
                    this.printDefaultsTo(out, argument.valueToShowInHelp());
                }
                out.println();
            }
            if (this.options.size() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "OPTIONS" + SimpleAnsi.INTENSITY_NORMAL);
                for (Option option : optionsSet) {
                    String opt = option.name();
                    for (String alias : option.aliases()) {
                        opt = opt + ", " + alias;
                    }
                    out.print("        ");
                    out.println(SimpleAnsi.INTENSITY_BOLD + opt + SimpleAnsi.INTENSITY_NORMAL);
                    ActionMetaData.printFormatted("                ", option.description(), termWidth, out, true);
                    if (option.valueToShowInHelp() == null || option.valueToShowInHelp().length() == 0) continue;
                    if ("DEFAULT".equals(option.valueToShowInHelp())) {
                        Object object = this.getDefaultValue(action, option);
                        String defaultValue = this.getDefaultValueString(object);
                        if (defaultValue == null) continue;
                        this.printDefaultsTo(out, defaultValue);
                        continue;
                    }
                    this.printDefaultsTo(out, option.valueToShowInHelp());
                }
                out.println();
            }
            if (this.command.detailedDescription().length() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "DETAILS" + SimpleAnsi.INTENSITY_NORMAL);
                String desc = this.getDetailedDescription();
                ActionMetaData.printFormatted("        ", desc, termWidth, out, true);
            }
        }
    }

    public Object getDefaultValue(Action action, Argument argument) {
        try {
            this.arguments.get(argument).setAccessible(true);
            return this.arguments.get(argument).get(action);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getDefaultValue(Action action, Option option) {
        try {
            this.options.get(option).setAccessible(true);
            return this.options.get(option).get(action);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDetailedDescription() {
        String desc = this.command.detailedDescription();
        return this.loadDescription(this.actionClass, desc);
    }

    private String loadDescription(Class<?> clazz, String desc) {
        if (desc != null && desc.startsWith("classpath:")) {
            desc = this.loadClassPathResource(clazz, desc.substring("classpath:".length()));
        }
        return desc;
    }

    public String getDefaultValueString(Object o) {
        if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
            return o.toString();
        }
        return null;
    }

    private void printDefaultsTo(PrintStream out, String value) {
        out.println("                (defaults to " + value + ")");
    }

    static void printFormatted(String prefix, String str, int termWidth, PrintStream out, boolean prefixFirstLine) {
        int pfxLen = prefix.length();
        int maxwidth = termWidth - pfxLen;
        Pattern wrap = Pattern.compile("(\\S\\S{" + maxwidth + ",}|.{1," + maxwidth + "})(\\s+|$)");
        int cur = 0;
        while (cur >= 0) {
            String s;
            int lst = str.indexOf(10, cur);
            String string = s = lst >= 0 ? str.substring(cur, lst) : str.substring(cur);
            if (s.length() == 0) {
                out.println();
            } else {
                Matcher m = wrap.matcher(s);
                while (m.find()) {
                    if (cur > 0 || prefixFirstLine) {
                        out.print(prefix);
                    }
                    out.println(m.group());
                }
            }
            if (lst < 0) break;
            cur = lst + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadClassPathResource(Class<?> clazz, String path) {
        InputStream is = clazz.getResourceAsStream(path);
        if (is == null) {
            is = clazz.getClassLoader().getResourceAsStream(path);
        }
        if (is == null) {
            return "Unable to load description from " + path;
        }
        try {
            int c;
            InputStreamReader r = new InputStreamReader(is);
            StringWriter sw = new StringWriter();
            while ((c = ((Reader)r).read()) != -1) {
                sw.append((char)c);
            }
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            String string = "Unable to load description from " + path;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

