/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.EditSofaBindingsDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;

public class SofaMapSection
extends AbstractSection {
    private Composite sectionClient;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Tree tree;
    private static final String INPUTS = "Inputs";
    private static final String OUTPUTS = "Outputs";
    private static final boolean INPUT = true;
    private static final boolean OUTPUT = false;
    private static final String titleMsg = "This section shows all defined Sofas for an Aggregate and their mappings to the component Sofas.\nAdd Aggregate Sofa Names using the Capabilities section; Select an Aggregate Sofa Name and Add/Edit mappings for that Sofa in this section.\n";
    private static final boolean AVAIL_ONLY = true;

    public SofaMapSection(MultiPageEditor aEditor, Composite parent) {
        super(aEditor, parent, "Sofa Mappings (Only used in aggregate Descriptors)", titleMsg);
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.tree = this.newTree(this.sectionClient);
        Composite buttonContainer = this.newButtonContainer(this.sectionClient);
        this.addButton = this.newPushButton(buttonContainer, "Add...", "Click here to add a component Sofa binding.");
        this.editButton = this.newPushButton(buttonContainer, "Edit...", "Click here to edit the selected item. You can also double-click the item to edit it.");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click here to remove the selected item.  You can also use the delete key.");
        this.tree.addListener(8, (Listener)this);
        this.enableBorders(this.sectionClient);
        this.toolkit.paintBordersFor(this.sectionClient);
        if (!this.isAggregate()) {
            this.getSection().setExpanded(false);
        }
    }

    public void refresh() {
        super.refresh();
        this.tree.removeAll();
        if (!this.isAggregate()) {
            this.getSection().setText("Sofa Mappings (Only used in aggregate Descriptors)");
            this.getSection().setDescription("This part is only used for Aggregate Descriptors");
            this.getSection().setExpanded(false);
        } else {
            this.getSection().setDescription(titleMsg);
            String[][] sns = this.getCapabilitySofaNames();
            String[] inputSofaNames = sns[0];
            String[] outputSofaNames = sns[1];
            String[] inputAggrSofas = this.getAggrSofas(inputSofaNames, outputSofaNames);
            this.fillMap(inputAggrSofas, true);
            this.fillMap(outputSofaNames, false);
            SofaMapSection.maybeSetSelection(this.tree, 0);
            if (0 == inputAggrSofas.length + outputSofaNames.length) {
                this.getSection().setText("Sofa Mappings (No Sofas are defined)");
                this.getSection().setExpanded(false);
            } else {
                this.getSection().setText("Sofa Mappings");
                this.getSection().setExpanded(true);
            }
        }
        this.enable();
    }

    private String[] getAggrSofas(String[] inputCapabilityNames, String[] outputCapabilityNames) {
        int i;
        SofaMapping[] allMappings = this.getSofaMappings();
        TreeSet<String> names = new TreeSet<String>();
        TreeSet<String> undeclaredNames = new TreeSet<String>();
        if (null != inputCapabilityNames) {
            for (i = 0; i < inputCapabilityNames.length; ++i) {
                names.add(inputCapabilityNames[i]);
            }
        }
        if (null != allMappings) {
            for (i = 0; i < allMappings.length; ++i) {
                String sofaName = allMappings[i].getAggregateSofaName();
                if (0 <= Arrays.binarySearch(inputCapabilityNames, sofaName) || 0 <= Arrays.binarySearch(outputCapabilityNames, sofaName)) continue;
                undeclaredNames.add(sofaName);
            }
        }
        if (undeclaredNames.size() > 0) {
            names.addAll(undeclaredNames);
        }
        return names.toArray(stringArray0);
    }

    private void fillMap(String[] aggrKeys, boolean isInput) {
        TreeItem d = new TreeItem(this.tree, 0);
        d.setText(isInput ? INPUTS : OUTPUTS);
        for (int i = 0; i < aggrKeys.length; ++i) {
            TreeItem a = new TreeItem(d, 0);
            a.setText(aggrKeys[i]);
            this.fillBindings(a, aggrKeys[i]);
            a.setExpanded(true);
        }
        d.setExpanded(true);
    }

    private void fillBindings(TreeItem parent, String aggrSofa) {
        String[] bindings = this.getSofaBindingsForAggrSofa(aggrSofa);
        for (int j = 0; j < bindings.length; ++j) {
            TreeItem b = new TreeItem(parent, 0);
            b.setText(bindings[j]);
        }
    }

    private String[] getSofaBindingsForAggrSofa(String aggrSofa) {
        SofaMapping[] sofaMappings = this.getSofaMappings();
        if (null == sofaMappings) {
            return stringArray0;
        }
        TreeSet<Object> bindings = new TreeSet<Object>();
        for (int i = 0; i < sofaMappings.length; ++i) {
            SofaMapping sofaMapping = sofaMappings[i];
            if (!sofaMapping.getAggregateSofaName().equals(aggrSofa)) continue;
            if (null != sofaMapping.getComponentSofaName() && !"".equals(sofaMapping.getComponentSofaName())) {
                bindings.add(sofaMapping.getComponentKey() + "/" + sofaMapping.getComponentSofaName());
                continue;
            }
            bindings.add(sofaMapping.getComponentKey());
        }
        Object[] results = bindings.toArray(stringArray0);
        Arrays.sort(results);
        return results;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.editButton || event.type == 8) {
            if (!this.editButton.getEnabled()) {
                return;
            }
            TreeItem selected = this.tree.getSelection()[0];
            TreeItem parent = selected.getParentItem();
            if (null != parent.getParentItem()) {
                selected = parent;
            }
            this.editAggrMap(selected);
        } else if (event.widget == this.addButton) {
            TreeItem selected = this.tree.getSelection()[0];
            TreeItem parent = selected.getParentItem();
            if (null != parent.getParentItem()) {
                selected = parent;
            }
            this.addAggrMap(selected);
        } else if (event.widget == this.removeButton) {
            TreeItem selected = this.tree.getSelection()[0];
            TreeItem parent = selected.getParentItem();
            if (null == parent.getParentItem()) {
                this.removeAggr(selected);
            } else {
                this.removeComponentFromAggr(selected);
            }
        }
        this.enable();
    }

    private void editAggrMap(TreeItem selected) {
        String aggrSofa = selected.getText();
        Map availAndBoundSofas = this.getAvailAndBoundSofas(aggrSofa, false);
        if (availAndBoundSofas.size() == 0) {
            Utility.popMessage("No available sofas", "Because there are no sofas in the delegates that are not already bound, no sofa mapping can be created.", 4);
            return;
        }
        EditSofaBindingsDialog dialog = new EditSofaBindingsDialog((AbstractSection)this, aggrSofa, availAndBoundSofas);
        if (dialog.open() == 1) {
            return;
        }
        this.removeAggr(aggrSofa);
        this.addAggr(aggrSofa, dialog.selectedSofaNames);
        this.removeChildren(selected);
        this.fillBindings(selected, aggrSofa);
        selected.setExpanded(true);
        this.setFileDirty();
    }

    private void addAggrMap(TreeItem selected) {
        String aggrSofa = selected.getText();
        Map availAndBoundSofas = this.getAvailAndBoundSofas(aggrSofa, true);
        if (availAndBoundSofas.size() == 0) {
            Utility.popMessage("No available sofas", "Because there are no sofas in the delegates that are not already bound, no sofa mapping can be created.", 4);
            return;
        }
        EditSofaBindingsDialog dialog = new EditSofaBindingsDialog((AbstractSection)this, aggrSofa, availAndBoundSofas);
        if (dialog.open() == 1) {
            return;
        }
        this.addAggr(aggrSofa, dialog.selectedSofaNames);
        this.removeChildren(selected);
        this.fillBindings(selected, aggrSofa);
        selected.setExpanded(true);
        this.setFileDirty();
    }

    private void addSofasToAllComponentSofaMap(Map allComponentSofas, String key, ResourceSpecifier delegate, boolean isInput) {
        if (delegate instanceof AnalysisEngineDescription || delegate instanceof CasConsumerDescription || delegate instanceof FlowControllerDescription) {
            Set[] inAndOut = SofaMapSection.getCapabilitySofaNames((ResourceCreationSpecifier)delegate, key);
            Set inOut = inAndOut[isInput ? 0 : 1];
            if (!isInput) {
                inOut.addAll(inAndOut[0]);
            }
            if (inOut.size() == 0) {
                allComponentSofas.put(key, null);
            }
            Iterator i2 = inOut.iterator();
            while (i2.hasNext()) {
                allComponentSofas.put(i2.next(), null);
            }
        }
    }

    private Map getAvailAndBoundSofas(String aggrSofa, boolean availOnly) {
        boolean isInput = this.isInput(aggrSofa);
        TreeMap<String, String> allComponentSofas = new TreeMap<String, String>();
        for (Map.Entry entry : this.editor.getResolvedDelegates().entrySet()) {
            this.addSofasToAllComponentSofaMap(allComponentSofas, (String)entry.getKey(), (ResourceSpecifier)entry.getValue(), isInput);
        }
        FlowControllerDeclaration fcd = this.editor.getResolvedFlowControllerDeclaration();
        if (null != fcd) {
            this.addSofasToAllComponentSofaMap(allComponentSofas, fcd.getKey(), fcd.getSpecifier(), isInput);
        }
        SofaMapping[] sofaMappings = this.getSofaMappings();
        for (int i = 0; i < sofaMappings.length; ++i) {
            SofaMapping sm = sofaMappings[i];
            Object key = sm.getComponentKey();
            if (null != sm.getComponentSofaName()) {
                key = (String)key + "/" + sm.getComponentSofaName();
            }
            if (availOnly) {
                allComponentSofas.remove(key);
                continue;
            }
            allComponentSofas.put((String)key, sm.getAggregateSofaName());
        }
        Iterator i3 = allComponentSofas.entrySet().iterator();
        while (i3.hasNext()) {
            Map.Entry entry = i3.next();
            String boundAggrSofa = (String)entry.getValue();
            if (null == boundAggrSofa || boundAggrSofa.equals(aggrSofa)) continue;
            i3.remove();
        }
        return allComponentSofas;
    }

    private boolean isInput(String sofaName) {
        String[][] sns = this.getCapabilitySofaNames();
        for (int i = 0; i < sns[0].length; ++i) {
            if (!sofaName.equals(sns[0][i])) continue;
            return true;
        }
        return false;
    }

    private void addAggr(String aggrSofa, String[] sofaNames) {
        SofaMapping[] newSofas = new SofaMapping[sofaNames.length];
        for (int i = 0; i < sofaNames.length; ++i) {
            newSofas[i] = UIMAFramework.getResourceSpecifierFactory().createSofaMapping();
            newSofas[i].setAggregateSofaName(aggrSofa);
            newSofas[i].setComponentKey(this.getComponentOnly(sofaNames[i]));
            newSofas[i].setComponentSofaName(this.getSofaOnly(sofaNames[i]));
        }
        SofaMapping[] oldSofas = this.getSofaMappings();
        SofaMapping[] result = new SofaMapping[oldSofas.length + newSofas.length];
        System.arraycopy(oldSofas, 0, result, 0, oldSofas.length);
        System.arraycopy(newSofas, 0, result, oldSofas.length, newSofas.length);
        this.editor.getAeDescription().setSofaMappings(result);
    }

    private void removeAggr(String aggrSofa) {
        Comparator comparator = new Comparator(){

            public int compare(Object aggrSofaName, Object o2) {
                SofaMapping sofaMapping = (SofaMapping)o2;
                if (sofaMapping.getAggregateSofaName().equals(aggrSofaName)) {
                    return 0;
                }
                return -1;
            }
        };
        this.editor.getAeDescription().setSofaMappings((SofaMapping[])Utility.removeElementsFromArray(this.getSofaMappings(), aggrSofa, SofaMapping.class, comparator));
    }

    private void removeAggr(TreeItem selected) {
        if (1 == Utility.popOkCancel("Confirm delete of sofa mappings", "Please confirm deletion of all sofa mappings for this Aggregate Sofa name.  Note this will not delete the Sofa name.  To do that, remove the name from the Component Capabilities panel (the other panel on this page).", 4)) {
            return;
        }
        this.removeAggr(selected.getText());
        this.removeChildren(selected);
        this.setFileDirty();
    }

    private void removeComponentFromAggr(TreeItem selected) {
        final String aggrName = selected.getParentItem().getText();
        Comparator comparator = new Comparator(){

            public int compare(Object componentAndSofa, Object o2) {
                SofaMapping sofaMapping = (SofaMapping)o2;
                if (!sofaMapping.getAggregateSofaName().equals(aggrName)) {
                    return -1;
                }
                String component = SofaMapSection.this.getComponentOnly((String)componentAndSofa);
                if (!sofaMapping.getComponentKey().equals(component)) {
                    return -1;
                }
                String sofa = SofaMapSection.this.getSofaOnly((String)componentAndSofa);
                if (null == sofa || sofa.equals("")) {
                    if (null == sofaMapping.getComponentSofaName() || "".equals(sofaMapping.getComponentSofaName())) {
                        return 0;
                    }
                    return -1;
                }
                if (sofa.equals(sofaMapping.getComponentSofaName())) {
                    return 0;
                }
                return -1;
            }
        };
        this.editor.getAeDescription().setSofaMappings((SofaMapping[])Utility.removeElementsFromArray(this.getSofaMappings(), selected.getText(), SofaMapping.class, comparator));
        selected.dispose();
        this.setFileDirty();
    }

    public static void removeSofaMappings(String componentKey, ResourceSpecifier delegate, MultiPageEditor pEditor) {
        if (delegate instanceof AnalysisEngineDescription || delegate instanceof CasConsumerDescription) {
            Set[] inOut = SofaMapSection.getCapabilitySofaNames((ResourceCreationSpecifier)delegate, componentKey);
            inOut[0].addAll(inOut[1]);
            final Set allDelegateComponentSofas = inOut[0];
            Comparator comparator = new Comparator(){

                public int compare(Object ignore, Object elementOfArray) {
                    SofaMapping sofaMapping = (SofaMapping)elementOfArray;
                    Object key = sofaMapping.getComponentKey();
                    if (null != sofaMapping.getComponentSofaName()) {
                        key = (String)key + "/" + sofaMapping.getComponentSofaName();
                    }
                    if (allDelegateComponentSofas.contains(key)) {
                        return 0;
                    }
                    return -1;
                }
            };
            pEditor.getAeDescription().setSofaMappings((SofaMapping[])Utility.removeElementsFromArray(SofaMapSection.getSofaMappings(pEditor), null, SofaMapping.class, comparator));
        }
    }

    private String getSofaOnly(String componentAndSofa) {
        int locOfSlash = componentAndSofa.indexOf(47);
        if (locOfSlash < 0) {
            return null;
        }
        return componentAndSofa.substring(locOfSlash + 1);
    }

    private String getComponentOnly(String componentAndSofa) {
        int locOfSlash = componentAndSofa.indexOf(47);
        if (locOfSlash < 0) {
            return componentAndSofa;
        }
        return componentAndSofa.substring(0, locOfSlash);
    }

    @Override
    public void enable() {
        boolean oneSelected = this.tree.getSelectionCount() == 1;
        boolean topLevelSelected = false;
        if (oneSelected) {
            TreeItem selected = this.tree.getSelection()[0];
            topLevelSelected = null == selected.getParentItem();
        }
        this.addButton.setEnabled(oneSelected && !topLevelSelected);
        this.editButton.setEnabled(oneSelected && !topLevelSelected);
        this.removeButton.setEnabled(oneSelected && !topLevelSelected);
    }
}

