/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImplMBean;
import org.apache.uima.util.ConcurrentHashMapWithProducer;

public class AnalysisEngineManagementImpl
implements AnalysisEngineManagementImplMBean,
AnalysisEngineManagement {
    private static final long serialVersionUID = 1988620286191379887L;
    private static final Pattern RESERVED_CHAR_PATTERN = Pattern.compile("[\",=:*?]");
    static final DecimalFormat format = new DecimalFormat("0.##");
    private static final ConcurrentHashMapWithProducer<String, AtomicInteger> usedRootNames = new ConcurrentHashMapWithProducer();
    private String name;
    private final AtomicLong numProcessed = new AtomicLong(0L);
    private final AtomicLong markedAnalysisTime = new AtomicLong(0L);
    private final AtomicLong markedBatchProcessCompleteTime = new AtomicLong(0L);
    private final AtomicLong markedCollectionProcessCompleteTime = new AtomicLong(0L);
    private final AtomicLong markedServiceCallTime = new AtomicLong(0L);
    private final AtomicLong analysisTime = new AtomicLong(0L);
    private final AtomicLong batchProcessCompleteTime = new AtomicLong(0L);
    private final AtomicLong collectionProcessCompleteTime = new AtomicLong(0L);
    private final AtomicLong serviceCallTime = new AtomicLong(0L);
    private final Map<String, AnalysisEngineManagement> components = Collections.synchronizedMap(new LinkedHashMap());
    private String uniqueMBeanName;
    private AnalysisEngineManagement.State status = AnalysisEngineManagement.State.Initializing;
    private long threadId = Thread.currentThread().getId();
    private long initializationTime;
    private static final Callable<AtomicInteger> produceAtomicInteger = new Callable<AtomicInteger>(){

        @Override
        public AtomicInteger call() throws Exception {
            return new AtomicInteger(1);
        }
    };

    @Override
    public long getInitializationTime() {
        return this.initializationTime;
    }

    public void setInitializationTime(long initializationTime) {
        this.initializationTime = initializationTime;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public String getState() {
        return this.status.toString();
    }

    public void setState(AnalysisEngineManagement.State state) {
        this.status = state;
    }

    public void reportAnalysisTime(long time) {
        this.analysisTime.addAndGet(time);
    }

    public void reportBatchProcessCompleteTime(long time) {
        this.batchProcessCompleteTime.addAndGet(time);
    }

    public void reportCollectionProcessCompleteTime(long time) {
        this.collectionProcessCompleteTime.addAndGet(time);
    }

    public void reportServiceCallTime(long time) {
        this.serviceCallTime.addAndGet(time);
    }

    public void incrementCASesProcessed() {
        this.numProcessed.incrementAndGet();
    }

    @Override
    public long getBatchProcessCompleteTime() {
        return this.batchProcessCompleteTime.get();
    }

    @Override
    public long getCollectionProcessCompleteTime() {
        return this.collectionProcessCompleteTime.get();
    }

    @Override
    public long getAnalysisTime() {
        return this.analysisTime.get() + this.serviceCallTime.get();
    }

    @Override
    public long getServiceCallTime() {
        return this.serviceCallTime.get();
    }

    public void mark() {
        this.markedAnalysisTime.set(this.analysisTime.get());
        this.markedBatchProcessCompleteTime.set(this.batchProcessCompleteTime.get());
        this.markedCollectionProcessCompleteTime.set(this.collectionProcessCompleteTime.get());
        this.markedServiceCallTime.set(this.serviceCallTime.get());
        for (AnalysisEngineManagement component : this.components.values()) {
            ((AnalysisEngineManagementImpl)component).mark();
        }
    }

    public long getBatchProcessCompleteTimeSinceMark() {
        return this.batchProcessCompleteTime.get() - this.markedBatchProcessCompleteTime.get();
    }

    public long getCollectionProcessCompleteTimeSinceMark() {
        return this.collectionProcessCompleteTime.get() - this.markedCollectionProcessCompleteTime.get();
    }

    public long getAnalysisTimeSinceMark() {
        return this.analysisTime.get() - this.markedAnalysisTime.get();
    }

    public long getServiceCallTimeSinceMark() {
        return this.serviceCallTime.get() - this.markedServiceCallTime.get();
    }

    @Override
    public long getNumberOfCASesProcessed() {
        return this.numProcessed.get();
    }

    @Override
    public String getCASesPerSecond() {
        long analysisTime = this.getAnalysisTime();
        if (analysisTime == 0L) {
            return "0";
        }
        float docsPerSecond = (float)this.numProcessed.get() / (float)analysisTime * 1000.0f;
        return format.format(docsPerSecond);
    }

    @Override
    public Map<String, AnalysisEngineManagement> getComponents() {
        return Collections.unmodifiableMap(this.components);
    }

    public void addComponent(String key, AnalysisEngineManagementImpl component) {
        this.components.put(key, component);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueMBeanName() {
        return this.uniqueMBeanName;
    }

    @Override
    public void resetStats() {
        this.numProcessed.set(0L);
        this.analysisTime.set(0L);
        this.batchProcessCompleteTime.set(0L);
        this.collectionProcessCompleteTime.set(0L);
        this.serviceCallTime.set(0L);
        this.markedAnalysisTime.set(0L);
        this.markedBatchProcessCompleteTime.set(0L);
        this.markedCollectionProcessCompleteTime.set(0L);
        this.markedServiceCallTime.set(0L);
        for (AnalysisEngineManagement component : this.components.values()) {
            component.resetStats();
        }
    }

    public void setName(String aName, UimaContextAdmin aContext, String aCustomPrefix) {
        Object prefix;
        this.name = aName;
        if (aCustomPrefix == null) {
            prefix = "org.apache.uima:";
        } else {
            prefix = aCustomPrefix;
            if (!((String)prefix).endsWith(":") && !((String)prefix).endsWith(",")) {
                prefix = (String)prefix + ",";
            }
        }
        AnalysisEngineManagementImpl rootMBean = (AnalysisEngineManagementImpl)aContext.getRootContext().getManagementInterface();
        if (rootMBean.getUniqueMBeanName() == null) {
            rootMBean.uniqueMBeanName = (String)prefix + "name=" + AnalysisEngineManagementImpl.escapeValue(AnalysisEngineManagementImpl.getRootName(rootMBean.getName()));
        }
        if (rootMBean != this) {
            String rootName = rootMBean.getUniqueMBeanName();
            rootName = rootName.substring(((String)prefix).length() + "name=".length());
            prefix = (String)prefix + "p0=";
            prefix = rootName.endsWith("\"") ? (String)prefix + rootName.substring(0, rootName.length() - 1) + " Components\"," : (String)prefix + rootName + " Components,";
            this.uniqueMBeanName = AnalysisEngineManagementImpl.makeMBeanName((String)prefix, aContext.getQualifiedContextName().substring(1), 1);
        }
    }

    static String getRootName(String baseRootName) {
        AtomicInteger suffix;
        if (baseRootName == null) {
            baseRootName = "CPE";
        }
        try {
            suffix = usedRootNames.get(baseRootName, produceAtomicInteger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int suffixI = suffix.getAndIncrement();
        return suffixI == 1 ? baseRootName : baseRootName + suffixI;
    }

    private static String makeMBeanName(String prefix, String contextName, int depth) {
        int firstSlash = contextName.indexOf(47);
        if (firstSlash == contextName.length() - 1) {
            return prefix + "name=" + AnalysisEngineManagementImpl.escapeValue(contextName.substring(0, contextName.length() - 1));
        }
        String newPrefix = prefix + "p" + depth + "=" + AnalysisEngineManagementImpl.escapeValue(contextName.substring(0, firstSlash) + " Components") + ",";
        return AnalysisEngineManagementImpl.makeMBeanName(newPrefix, contextName.substring(firstSlash + 1), depth + 1);
    }

    private static String escapeValue(String value) {
        if (RESERVED_CHAR_PATTERN.matcher(value).find()) {
            StringBuffer buf = new StringBuffer();
            buf.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\"' || c == '\\' || c == '?' || c == '*') {
                    buf.append('\\');
                }
                buf.append(c);
            }
            buf.append('\"');
            return buf.toString();
        }
        return value;
    }
}

