/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.ComponentInfo;
import org.apache.uima.cas.SofaID;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.impl.ChildUimaContext_impl;
import org.apache.uima.impl.SofaID_impl;
import org.apache.uima.impl.Util;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.Settings;
import org.apache.uima.util.UriUtils;
import org.apache.uima.util.impl.Constants;

public abstract class UimaContext_ImplBase
implements UimaContextAdmin {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static AtomicInteger MDC_NEXT_ID = new AtomicInteger(0);
    private final ComponentInfo mComponentInfo = new ComponentInfoImpl();
    protected final String mQualifiedContextName;
    protected final Map<String, String> mSofaMappings;
    protected volatile int mCasPoolSize = 0;
    private volatile Properties mPerformanceTuningSettings;
    private volatile boolean mSofaAware;
    private volatile boolean mCasPoolCreated = false;
    protected final Set<CAS> mOutstandingCASes = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final AnalysisEngineManagementImpl mMBean = new AnalysisEngineManagementImpl();
    private final String uniqueIdentifier;
    private final String mdcUniqueId;
    protected int loggingThrottleLimit = Integer.MAX_VALUE;

    public UimaContext_ImplBase() {
        this.mQualifiedContextName = "/";
        this.uniqueIdentifier = this.constructUniqueName();
        this.mdcUniqueId = String.valueOf(MDC_NEXT_ID.getAndIncrement());
        this.mSofaMappings = new TreeMap<String, String>();
    }

    public UimaContext_ImplBase(String contextName, Map<String, String> sofaMappings) {
        this.mQualifiedContextName = contextName;
        this.uniqueIdentifier = this.constructUniqueName();
        this.mdcUniqueId = "invalid";
        this.mSofaMappings = sofaMappings;
    }

    private String constructUniqueName() {
        String u = new UID().toString();
        StringBuilder sb = new StringBuilder(u.length());
        sb.append(u);
        for (int i = u.length() - 1; i >= 0; --i) {
            char c = sb.charAt(i);
            if (c != ':' && c != '-') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    @Override
    public String getUniqueName() {
        return this.getQualifiedContextName() + "_" + this.uniqueIdentifier;
    }

    @Override
    public UimaContextAdmin createChild(String aContextName, Map<String, String> aSofaMappings) {
        ChildUimaContext_impl child = new ChildUimaContext_impl(this, aContextName, this.combineSofaMappings(aSofaMappings));
        this.mMBean.addComponent(aContextName, child.mMBean);
        return child;
    }

    public Map<String, String> combineSofaMappings(Map<String, String> aSofaMappings) {
        TreeMap<String, String> childSofaMap = new TreeMap<String, String>();
        childSofaMap.putAll(this.mSofaMappings);
        if (aSofaMappings != null) {
            for (Map.Entry<String, String> entry : aSofaMappings.entrySet()) {
                String childSofaName = entry.getKey();
                String thisContextSofaName = entry.getValue();
                String absoluteSofaName = this.mSofaMappings.get(thisContextSofaName);
                if (absoluteSofaName == null) {
                    absoluteSofaName = thisContextSofaName;
                }
                childSofaMap.put(childSofaName, absoluteSofaName);
            }
        }
        return childSofaMap;
    }

    @Override
    public Object getConfigParameterValue(String aName) {
        return this.getConfigurationManager().getConfigParameterValue(this.makeQualifiedName(aName));
    }

    @Override
    public Object getConfigParameterValue(String aGroupName, String aParamName) {
        return this.getConfigurationManager().getConfigParameterValue(this.makeQualifiedName(aParamName), aGroupName);
    }

    @Override
    public String getSharedSettingValue(String name) throws ResourceConfigurationException {
        Settings settings = this.getRootContext().getExternalOverrides();
        return settings == null ? null : settings.getSetting(name);
    }

    @Override
    public String[] getSharedSettingArray(String name) throws ResourceConfigurationException {
        Settings settings = this.getRootContext().getExternalOverrides();
        return settings == null ? null : settings.getSettingArray(name);
    }

    @Override
    public String[] getSharedSettingNames() {
        Settings settings = this.getRootContext().getExternalOverrides();
        if (settings == null) {
            return null;
        }
        Set<String> names = settings.getKeys();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public URL getResourceURL(String aKey) throws ResourceAccessException {
        URL result = this.getResourceManager().getResourceURL(this.makeQualifiedName(aKey));
        if (result != null) {
            return result;
        }
        URL unmanagedResourceUrl = null;
        try {
            unmanagedResourceUrl = this.getResourceManager().resolveRelativePath(aKey);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (unmanagedResourceUrl != null) {
            UIMAFramework.getLogger().logrb(Level.WARNING, this.getClass().getName(), "getResourceURL", LOG_RESOURCE_BUNDLE, "UIMA_unmanaged_resource__WARNING", new Object[]{aKey});
            return unmanagedResourceUrl;
        }
        return null;
    }

    @Override
    public URI getResourceURI(String aKey) throws ResourceAccessException {
        return this.getResourceURIfromURL(this.getResourceURL(aKey));
    }

    private URI getResourceURIfromURL(URL resourceUrl) throws ResourceAccessException {
        if (resourceUrl != null) {
            try {
                return UriUtils.quote(resourceUrl);
            }
            catch (URISyntaxException e) {
                throw new ResourceAccessException(e);
            }
        }
        return null;
    }

    @Override
    public String getResourceFilePath(String aKey) throws ResourceAccessException {
        URI resourceUri = this.getResourceURI(aKey);
        if (resourceUri != null) {
            if ("file".equals(resourceUri.getScheme())) {
                return resourceUri.getPath();
            }
            throw new ResourceAccessException();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String aKey) throws ResourceAccessException {
        InputStream result = this.getResourceManager().getResourceAsStream(this.makeQualifiedName(aKey));
        if (result != null) {
            return result;
        }
        URL unmanagedResourceUrl = null;
        try {
            unmanagedResourceUrl = this.getResourceManager().resolveRelativePath(aKey);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (unmanagedResourceUrl != null) {
            UIMAFramework.getLogger().logrb(Level.WARNING, this.getClass().getName(), "getResourceAsStream", LOG_RESOURCE_BUNDLE, "UIMA_unmanaged_resource__WARNING", new Object[]{aKey});
            try {
                return unmanagedResourceUrl.openStream();
            }
            catch (IOException e) {
                throw new ResourceAccessException(e);
            }
        }
        return null;
    }

    @Override
    public Object getResourceObject(String aKey) throws ResourceAccessException {
        return this.getResourceManager().getResource(this.makeQualifiedName(aKey));
    }

    @Override
    public InputStream getResourceAsStream(String aKey, String[] aParams) throws ResourceAccessException {
        InputStream result = this.getResourceManager().getResourceAsStream(this.makeQualifiedName(aKey), aParams);
        if (result != null) {
            return result;
        }
        URL unmanagedResourceUrl = null;
        try {
            unmanagedResourceUrl = this.getResourceManager().resolveRelativePath(aKey);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (unmanagedResourceUrl != null) {
            UIMAFramework.getLogger().logrb(Level.WARNING, this.getClass().getName(), "getResourceAsStream", LOG_RESOURCE_BUNDLE, "UIMA_unmanaged_resource__WARNING", new Object[]{aKey});
            try {
                return unmanagedResourceUrl.openStream();
            }
            catch (IOException e) {
                throw new ResourceAccessException(e);
            }
        }
        return null;
    }

    @Override
    public Object getResourceObject(String aKey, String[] aParams) throws ResourceAccessException {
        return this.getResourceManager().getResource(this.makeQualifiedName(aKey), aParams);
    }

    @Override
    public URL getResourceURL(String aKey, String[] aParams) throws ResourceAccessException {
        URL result = this.getResourceManager().getResourceURL(this.makeQualifiedName(aKey), aParams);
        if (result != null) {
            return result;
        }
        URL unmanagedResourceUrl = null;
        try {
            unmanagedResourceUrl = this.getResourceManager().resolveRelativePath(aKey);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (unmanagedResourceUrl != null) {
            UIMAFramework.getLogger().logrb(Level.WARNING, this.getClass().getName(), "getResourceURL", LOG_RESOURCE_BUNDLE, "UIMA_unmanaged_resource__WARNING", new Object[]{aKey});
            return unmanagedResourceUrl;
        }
        return null;
    }

    @Override
    public URI getResourceURI(String aKey, String[] aParams) throws ResourceAccessException {
        return this.getResourceURIfromURL(this.getResourceURL(aKey, aParams));
    }

    @Override
    public String getResourceFilePath(String aKey, String[] aParams) throws ResourceAccessException {
        URI resourceUri = this.getResourceURI(aKey, aParams);
        if (resourceUri != null) {
            if ("file".equals(resourceUri.getScheme())) {
                return resourceUri.getPath();
            }
            throw new ResourceAccessException();
        }
        return null;
    }

    @Override
    @Deprecated
    public String getDataPath() {
        return this.getResourceManager().getDataPath();
    }

    @Override
    public List<String> getDataPathElements() {
        return this.getResourceManager().getDataPathElements();
    }

    protected String makeQualifiedName(String name) {
        return this.mQualifiedContextName + name;
    }

    @Override
    public String getQualifiedContextName() {
        return this.mQualifiedContextName;
    }

    @Override
    public String[] getConfigurationGroupNames() {
        ConfigurationParameterDeclarations paramDecls = this.getConfigurationManager().getConfigParameterDeclarations(this.getQualifiedContextName());
        if (paramDecls == null) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        ConfigurationGroup[] groups = paramDecls.getConfigurationGroups();
        if (groups == null) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; i < groups.length; ++i) {
            names.addAll(Arrays.asList(groups[i].getNames()));
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public String[] getConfigParameterNames() {
        ConfigurationParameterDeclarations paramDecls = this.getConfigurationManager().getConfigParameterDeclarations(this.getQualifiedContextName());
        if (paramDecls == null) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        ConfigurationParameter[] params = paramDecls.getConfigurationParameters();
        if (params == null || params.length == 0) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        return (String[])Arrays.stream(params).map(ConfigurationParameter::getName).toArray(String[]::new);
    }

    @Override
    public String[] getConfigParameterNames(String aGroup) {
        int i;
        ConfigurationParameterDeclarations paramDecls = this.getConfigurationManager().getConfigParameterDeclarations(this.getQualifiedContextName());
        if (paramDecls == null) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        ConfigurationGroup[] groups = paramDecls.getConfigurationGroupDeclarations(aGroup);
        if (groups.length == 0) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> names = new ArrayList<String>();
        ConfigurationParameter[] commonParams = paramDecls.getCommonParameters();
        if (commonParams != null) {
            for (i = 0; i < commonParams.length; ++i) {
                names.add(commonParams[i].getName());
            }
        }
        for (i = 0; i < groups.length; ++i) {
            ConfigurationParameter[] groupParams = groups[i].getConfigurationParameters();
            for (int j = 0; j < groupParams.length; ++j) {
                names.add(groupParams[j].getName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public Settings getExternalOverrides() {
        return this.getRootContext().getExternalOverrides();
    }

    @Override
    public void setExternalOverrides(Settings externalOverrides) {
        this.getRootContext().setExternalOverrides(externalOverrides);
    }

    @Override
    public SofaID mapToSofaID(String aSofaName) {
        int index = aSofaName.indexOf(".");
        String nameToMap = aSofaName;
        String absoluteSofaName = null;
        if (index < 0) {
            absoluteSofaName = this.mSofaMappings.get(nameToMap);
            if (absoluteSofaName == null) {
                absoluteSofaName = nameToMap;
            }
        } else {
            nameToMap = aSofaName.substring(0, index);
            String rest = aSofaName.substring(index);
            String absoluteRoot = this.mSofaMappings.get(nameToMap);
            if (absoluteRoot == null) {
                absoluteRoot = nameToMap;
            }
            absoluteSofaName = absoluteRoot + rest;
        }
        SofaID_impl sofaid = new SofaID_impl();
        sofaid.setSofaID(absoluteSofaName);
        return sofaid;
    }

    @Override
    public String mapSofaIDToComponentSofaName(String aSofaID) {
        String componentSofaName = aSofaID;
        SofaID[] sofaArr = this.getSofaMappings();
        for (int i = 0; i < sofaArr.length; ++i) {
            if (!aSofaID.equals(sofaArr[i].getSofaID())) continue;
            return sofaArr[i].getComponentSofaName();
        }
        return componentSofaName;
    }

    @Override
    public SofaID[] getSofaMappings() {
        Set<Map.Entry<String, String>> sofamap = this.mSofaMappings.entrySet();
        Iterator<Map.Entry<String, String>> iter = sofamap.iterator();
        SofaID[] sofaArr = new SofaID_impl[sofamap.size()];
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry<String, String> elem = iter.next();
            SofaID_impl sofaid = new SofaID_impl();
            sofaid.setComponentSofaName(elem.getKey());
            sofaid.setSofaID(elem.getValue());
            sofaArr[i] = sofaid;
            ++i;
        }
        return sofaArr;
    }

    @Override
    public Map<String, String> getSofaMap() {
        return Collections.unmodifiableMap(this.mSofaMappings);
    }

    @Override
    public void defineCasPool(int aSize, Properties aPerformanceTuningSettings, boolean aSofaAware) throws ResourceInitializationException {
        this.mCasPoolSize = aSize;
        this.mPerformanceTuningSettings = aPerformanceTuningSettings;
        this.mSofaAware = aSofaAware;
    }

    @Override
    public void returnedCAS(AbstractCas aCAS) {
        CASImpl baseCas = null;
        if (aCAS instanceof JCas) {
            baseCas = ((JCas)aCAS).getCasImpl().getBaseCAS();
        } else if (aCAS instanceof CASImpl) {
            baseCas = ((CASImpl)aCAS).getBaseCAS();
        }
        this.mOutstandingCASes.remove(baseCas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AbstractCas> T getEmptyCas(Class<T> aCasInterface) {
        if (!this.mCasPoolCreated) {
            UimaContext_ImplBase uimaContext_ImplBase = this;
            synchronized (uimaContext_ImplBase) {
                if (!this.mCasPoolCreated) {
                    try {
                        this.getResourceManager().getCasManager().defineCasPool(this, this.mCasPoolSize, this.mPerformanceTuningSettings);
                    }
                    catch (ResourceInitializationException e) {
                        throw new UIMARuntimeException(e);
                    }
                    this.mCasPoolCreated = true;
                }
            }
        }
        CAS cas = null;
        Set<CAS> set = this.mOutstandingCASes;
        synchronized (set) {
            if (this.mOutstandingCASes.size() >= this.mCasPoolSize) {
                throw new UIMARuntimeException("requested_too_many_cas_instances", this.getQualifiedContextName(), Integer.toString(this.mCasPoolSize + 1), Integer.toString(this.mCasPoolSize));
            }
            CasManager casManager = this.getResourceManager().getCasManager();
            cas = casManager.getCas(this.getUniqueName());
            this.mOutstandingCASes.add(((CASImpl)cas).getBaseCAS());
        }
        return Util.setupViewSwitchClassLoaders(cas, this.mSofaAware, this.getComponentInfo(), this.getResourceManager(), aCasInterface);
    }

    @Override
    public ComponentInfo getComponentInfo() {
        return this.mComponentInfo;
    }

    @Override
    public AnalysisEngineManagement getManagementInterface() {
        return this.mMBean;
    }

    protected Logger maybeThrottleLogger(Logger logger) {
        int limit = ((UimaContext_ImplBase)this.getRootContext()).loggingThrottleLimit;
        if (limit == Integer.MAX_VALUE || !logger.isAnnotatorLogger()) {
            return logger;
        }
        return logger.getLimitedLogger(limit);
    }

    public void setLoggingThrottleLimit(Integer v) {
        this.loggingThrottleLimit = v;
    }

    public String getMdcId() {
        return this.mdcUniqueId;
    }

    class ComponentInfoImpl
    implements ComponentInfo {
        ComponentInfoImpl() {
        }

        @Override
        public String mapToSofaID(String aSofaName) {
            int index = aSofaName.indexOf(".");
            String nameToMap = aSofaName;
            String absoluteSofaName = null;
            if (index < 0) {
                absoluteSofaName = UimaContext_ImplBase.this.mSofaMappings.get(nameToMap);
                if (absoluteSofaName == null) {
                    absoluteSofaName = nameToMap;
                }
            } else {
                nameToMap = aSofaName.substring(0, index);
                String rest = aSofaName.substring(index);
                String absoluteRoot = UimaContext_ImplBase.this.mSofaMappings.get(nameToMap);
                if (absoluteRoot == null) {
                    absoluteRoot = nameToMap;
                }
                absoluteSofaName = absoluteRoot + rest;
            }
            return absoluteSofaName;
        }
    }
}

