/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;

public final class ArrayType
extends TypeReference {
    private final TypeReference _elementType;
    private String _internalName;
    private String _fullName;
    private String _simpleName;

    ArrayType(TypeReference elementType) {
        this._elementType = (TypeReference)VerifyArgument.notNull((Object)elementType, (String)"elementType");
        this.setName(elementType.getName() + "[]");
    }

    @Override
    public boolean containsGenericParameters() {
        return this._elementType.containsGenericParameters();
    }

    @Override
    public String getPackageName() {
        return this._elementType.getPackageName();
    }

    @Override
    public String getSimpleName() {
        if (this._simpleName == null) {
            this._simpleName = this._elementType.getSimpleName() + "[]";
        }
        return this._simpleName;
    }

    @Override
    public String getFullName() {
        if (this._fullName == null) {
            this._fullName = this._elementType.getFullName() + "[]";
        }
        return this._fullName;
    }

    @Override
    public String getInternalName() {
        if (this._internalName == null) {
            this._internalName = "[" + this._elementType.getInternalName();
        }
        return this._internalName;
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public final TypeReference getElementType() {
        return this._elementType;
    }

    @Override
    public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitArrayType(this, parameter);
    }

    @Override
    public final TypeReference getUnderlyingType() {
        return this._elementType.getUnderlyingType();
    }

    @Override
    public final StringBuilder appendSignature(StringBuilder sb) {
        sb.append('[');
        return this._elementType.appendSignature(sb);
    }

    @Override
    public final StringBuilder appendErasedSignature(StringBuilder sb) {
        return this._elementType.appendErasedSignature(sb.append('['));
    }

    @Override
    public final StringBuilder appendBriefDescription(StringBuilder sb) {
        return this._elementType.appendBriefDescription(sb).append("[]");
    }

    @Override
    public final StringBuilder appendSimpleDescription(StringBuilder sb) {
        return this._elementType.appendSimpleDescription(sb).append("[]");
    }

    @Override
    public final StringBuilder appendDescription(StringBuilder sb) {
        return this.appendBriefDescription(sb);
    }

    public static ArrayType create(TypeReference elementType) {
        return new ArrayType(elementType);
    }

    @Override
    public final TypeDefinition resolve() {
        TypeDefinition resolvedElementType = this._elementType.resolve();
        if (resolvedElementType != null) {
            return resolvedElementType;
        }
        return super.resolve();
    }
}

