/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.json.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.uima.json.impl.JsonContentHandlerJacksonWrapper;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.XMLizable;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MetaDataObjectSerializer_json
implements MetaDataObject_impl.Serializer {
    private final JsonContentHandlerJacksonWrapper jch;
    private final JsonGenerator jg;
    private final boolean isFormattedOutput;

    public MetaDataObjectSerializer_json(JsonContentHandlerJacksonWrapper jch) {
        this.jch = jch;
        this.jg = jch.getJsonGenerator();
        this.isFormattedOutput = jch.isFormattedOutput();
    }

    public void outputStartElement(Node node, String nameSpace, String localName, String qName, Attributes attributes) throws SAXException {
        this.jch.startElement(null, null, qName, attributes);
    }

    public void outputEndElement(Node node, String aNamespace, String localname, String qname) throws SAXException {
        this.jch.endElement(null, localname, qname);
    }

    public void outputStartElementForArrayElement(Node node, String nameSpace, String localName, String qName, Attributes attributes) throws SAXException {
    }

    public void outputEndElementForArrayElement(Node node, String aNamespace, String localname, String qname) throws SAXException {
    }

    public void saveAndAddNodeStore(Node infoset) {
    }

    public void deleteNodeStore() {
    }

    public boolean indentChildElements(XmlizationInfo info, MetaDataObject_impl mdo) {
        return this.isFormattedOutput && this.hasXMLizableChild(info.propertyInfo, mdo);
    }

    public void insertNl() {
        this.jch.writeNlJustBeforeNext();
    }

    public boolean shouldBeSkipped(PropertyXmlInfo propInfo, Object val, MetaDataObject_impl mdo) {
        return mdo.valueIsNullOrEmptyArray(val);
    }

    public boolean startElementProperty() {
        return false;
    }

    public void addNodeStore() {
    }

    public void writeDelayedStart(String name) throws SAXException {
        this.jgWriteFieldName(name);
    }

    public void writeSimpleValue(Object val) throws SAXException {
        MetaDataObjectSerializer_json.writePrimitiveJsonValue(val, this.jg);
    }

    public boolean shouldEncloseInArrayElement(Class propClass) {
        return false;
    }

    public boolean isArrayHasIndentableElements(Object array) {
        Object firstElement = Array.get(array, 0);
        return !(firstElement instanceof AllowedValue) && firstElement instanceof XMLizable;
    }

    public void maybeStartArraySymbol() throws SAXException {
        this.jgWriteStartArray();
    }

    public void maybeEndArraySymbol() throws SAXException {
        this.jgWriteEndArray();
    }

    public void writeSimpleValueWithTag(String className, Object o, Node node) throws SAXException {
        this.jgWriteStartObject();
        this.jgWriteFieldName(className);
        String valStr = (String)o;
        this.jgWriteString(valStr);
        this.jgWriteEndObject();
    }

    private boolean hasXMLizableChild(PropertyXmlInfo[] ia, MetaDataObject_impl mdo) {
        for (PropertyXmlInfo pi : ia) {
            Object val = mdo.getAttributeValue(pi.propertyName);
            if (val == null || !(val instanceof XMLizable)) continue;
            return true;
        }
        return false;
    }

    private void jgWriteFieldName(String name) throws SAXException {
        try {
            this.jg.writeFieldName(name);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void jgWriteStartArray() throws SAXException {
        try {
            this.jg.writeStartArray();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void jgWriteEndArray() throws SAXException {
        try {
            this.jg.writeEndArray();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void jgWriteString(String s) throws SAXException {
        try {
            this.jg.writeString(s);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void jgWriteStartObject() throws SAXException {
        try {
            this.jg.writeStartObject();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void jgWriteEndObject() throws SAXException {
        try {
            this.jg.writeEndObject();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private static void writePrimitiveJsonValue(Object val, JsonGenerator jg) throws SAXException {
        block10: {
            try {
                if (val instanceof Boolean) {
                    jg.writeBoolean(((Boolean)val).booleanValue());
                    break block10;
                }
                if (val instanceof Integer) {
                    jg.writeNumber(((Integer)val).intValue());
                    break block10;
                }
                if (val instanceof Long) {
                    jg.writeNumber(((Long)val).longValue());
                    break block10;
                }
                if (val instanceof Short) {
                    jg.writeNumber(((Short)val).shortValue());
                    break block10;
                }
                if (val instanceof Byte) {
                    jg.writeNumber((short)((Byte)val).byteValue());
                    break block10;
                }
                if (val instanceof Float) {
                    jg.writeNumber(((Float)val).floatValue());
                    break block10;
                }
                if (val instanceof Double) {
                    jg.writeNumber(((Double)val).doubleValue());
                    break block10;
                }
                if (val instanceof String) {
                    jg.writeString((String)val);
                    break block10;
                }
                throw new RuntimeException("unhandled value type");
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    public Node findMatchingSubElement(String elementName) {
        return null;
    }
}

