/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Pattern;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    public static final StringValue SINGLE_SPACE = new StringValue(" ");
    public static final StringValue TRUE = new StringValue("true");
    public static final StringValue FALSE = new StringValue("false");
    protected CharSequence value;
    protected int length = -1;

    protected StringValue() {
        this.value = "";
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public AtomicValue copy(AtomicType atomicType) {
        StringValue stringValue = new StringValue(this.value);
        stringValue.length = this.length;
        stringValue.typeLabel = atomicType;
        return stringValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.STRING;
    }

    public static StringValue makeStringValue(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(charSequence);
    }

    public final String getStringValue() {
        this.value = ((Object)this.value).toString();
        return this.value;
    }

    public final CharSequence getStringValueCS() {
        return this.value;
    }

    public final void setStringValueCS(CharSequence charSequence) {
        this.value = charSequence;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        int n = builtInAtomicType.getFingerprint();
        if (n == 513 || n == 632 || n == 88) {
            return this;
        }
        return StringValue.convertStringToBuiltInType(this.value, builtInAtomicType, bl ? xPathContext.getConfiguration().getNameChecker() : null);
    }

    public static AtomicValue convertStringToBuiltInType(CharSequence charSequence, BuiltInAtomicType builtInAtomicType, NameChecker nameChecker) {
        try {
            switch (builtInAtomicType.getFingerprint()) {
                case 514: {
                    return BooleanValue.fromString(charSequence);
                }
                case 517: 
                case 635: {
                    return new DoubleValue(charSequence);
                }
                case 532: {
                    return Int64Value.stringToInteger(charSequence);
                }
                case 541: 
                case 542: 
                case 543: 
                case 544: {
                    if (nameChecker != null) {
                        for (int i = 0; i < charSequence.length(); ++i) {
                            if (charSequence.charAt(i) != '+') continue;
                            ValidationException validationException = new ValidationException("An unsigned number must not contain a plus sign");
                            return new ValidationErrorValue(validationException);
                        }
                    }
                }
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: {
                    AtomicValue atomicValue = IntegerValue.stringToInteger(charSequence);
                    if (atomicValue instanceof ValidationErrorValue) {
                        return atomicValue;
                    }
                    IntegerValue integerValue = (IntegerValue)atomicValue.copy(builtInAtomicType);
                    ValidationException validationException = integerValue.convertToSubType(builtInAtomicType, nameChecker != null);
                    return validationException == null ? integerValue : new ValidationErrorValue(validationException);
                }
                case 515: {
                    return DecimalValue.makeDecimalValue(charSequence, nameChecker != null);
                }
                case 516: {
                    return new FloatValue(charSequence);
                }
                case 521: {
                    return new DateValue(charSequence);
                }
                case 519: {
                    return new DateTimeValue(charSequence);
                }
                case 520: {
                    return new TimeValue(charSequence);
                }
                case 523: {
                    return new GYearValue(charSequence);
                }
                case 522: {
                    return new GYearMonthValue(charSequence);
                }
                case 526: {
                    return new GMonthValue(charSequence);
                }
                case 524: {
                    return new GMonthDayValue(charSequence);
                }
                case 525: {
                    return new GDayValue(charSequence);
                }
                case 518: {
                    return new DurationValue(charSequence);
                }
                case 633: {
                    return new YearMonthDurationValue(charSequence);
                }
                case 634: {
                    return new DayTimeDurationValue(charSequence);
                }
                case 573: 
                case 631: {
                    return new UntypedAtomicValue(charSequence);
                }
                case 88: 
                case 513: 
                case 632: {
                    return StringValue.makeStringValue(charSequence);
                }
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 563: {
                    return StringValue.makeRestrictedString(charSequence, builtInAtomicType, nameChecker);
                }
                case 529: {
                    if (AnyURIValue.isValidURI(charSequence)) {
                        return new AnyURIValue(charSequence);
                    }
                    throw new ValidationException("Invalid URI: " + ((Object)charSequence).toString());
                }
                case 527: {
                    return new HexBinaryValue(charSequence);
                }
                case 528: {
                    return new Base64BinaryValue(charSequence);
                }
            }
            ValidationException validationException = new ValidationException("Cannot convert string to type " + Err.wrap(builtInAtomicType.getDisplayName()));
            validationException.setErrorCode("XPTY0004");
            validationException.setIsTypeError(true);
            throw validationException;
        }
        catch (ValidationException validationException) {
            if (validationException.getErrorCodeLocalPart() == null) {
                validationException.setErrorCode("FORG0001");
            }
            return new ValidationErrorValue(validationException);
        }
        catch (XPathException xPathException) {
            if (xPathException.getErrorCodeLocalPart() == null) {
                xPathException.setErrorCode("FORG0001");
            }
            ValidationException validationException = new ValidationException(xPathException.getMessage());
            if (xPathException.getErrorCodeLocalPart() == null) {
                validationException.setErrorCode("FORG0001");
            } else {
                validationException.setErrorCode(xPathException.getErrorCodeLocalPart());
            }
            return new ValidationErrorValue(validationException);
        }
    }

    public static AtomicValue convertStringToAtomicType(CharSequence charSequence, AtomicType atomicType, NameChecker nameChecker) {
        if (atomicType instanceof BuiltInAtomicType) {
            return StringValue.convertStringToBuiltInType(charSequence, (BuiltInAtomicType)atomicType, nameChecker);
        }
        AtomicValue atomicValue = StringValue.convertStringToBuiltInType(charSequence, (BuiltInAtomicType)atomicType.getPrimitiveItemType(), nameChecker);
        if (atomicValue instanceof ValidationErrorValue) {
            return atomicValue;
        }
        return atomicType.setDerivedTypeLabel(atomicValue.copy(null), charSequence, nameChecker != null);
    }

    public int getStringLength() {
        if (this.length == -1) {
            this.length = StringValue.getStringLength(this.value);
        }
        return this.length;
    }

    public static int getStringLength(CharSequence charSequence) {
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    public boolean isZeroLength() {
        return this.value.length() == 0;
    }

    public boolean containsSurrogatePairs() {
        if (this.length == -1) {
            this.getStringLength();
        }
        return this.length != this.value.length();
    }

    public SequenceIterator iterateCharacters() {
        return new CharacterIterator();
    }

    public int[] expand() {
        int[] nArray = new int[this.getStringLength()];
        int n = 0;
        int n2 = this.value.length();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = this.value.charAt(i);
            if (n4 >= 55296 && n4 <= 56319) {
                n3 = (n4 - 55296) * 1024 + (this.value.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                n3 = n4;
            }
            nArray[n++] = n3;
        }
        return nArray;
    }

    public static int[] expand(CharSequence charSequence) {
        int[] nArray = new int[StringValue.getStringLength(charSequence)];
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            int n2;
            int n3 = charSequence.charAt(i);
            if (n3 >= 55296 && n3 <= 56319) {
                n2 = (n3 - 55296) * 1024 + (charSequence.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                n2 = n3;
            }
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static CharSequence contract(int[] nArray, int n) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(nArray.length);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < 65536) {
                fastStringBuffer.append((char)nArray[i]);
                continue;
            }
            fastStringBuffer.append(XMLChar.highSurrogate(nArray[i]));
            fastStringBuffer.append(XMLChar.lowSurrogate(nArray[i]));
        }
        return fastStringBuffer;
    }

    public Comparable getXPathComparable() {
        throw new ClassCastException("Comparing a string with a non-string value");
    }

    public boolean equals(Object object) {
        if (object instanceof AnyURIValue) {
            throw new ClassCastException("Cannot compare string to anyURI");
        }
        StringValue stringValue = (StringValue)object;
        return this.getStringValue().equals(stringValue.getStringValue());
    }

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    public boolean codepointEquals(StringValue stringValue) {
        if (this.value.length() != stringValue.value.length()) {
            return false;
        }
        return ((Object)this.value).toString().equals(((Object)stringValue.value).toString());
    }

    public boolean effectiveBooleanValue() {
        return this.value.length() > 0;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == Object.class) {
            return this.getStringValue();
        }
        if (clazz.isAssignableFrom(StringValue.class)) {
            return this;
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(BuiltInAtomicType.BOOLEAN, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == Boolean.class) {
            BooleanValue booleanValue = (BooleanValue)this.convert(BuiltInAtomicType.BOOLEAN, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == Double.TYPE) {
            DoubleValue doubleValue = (DoubleValue)this.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            return new Double(doubleValue.getDoubleValue());
        }
        if (clazz == Double.class) {
            DoubleValue doubleValue = (DoubleValue)this.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            return new Double(doubleValue.getDoubleValue());
        }
        if (clazz == Float.TYPE) {
            DoubleValue doubleValue = (DoubleValue)this.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            return new Float(doubleValue.getDoubleValue());
        }
        if (clazz == Float.class) {
            DoubleValue doubleValue = (DoubleValue)this.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            return new Float(doubleValue.getDoubleValue());
        }
        if (clazz == Long.TYPE) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Long(int64Value.longValue());
        }
        if (clazz == Long.class) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Long(int64Value.longValue());
        }
        if (clazz == Integer.TYPE) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Integer((int)int64Value.longValue());
        }
        if (clazz == Integer.class) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Integer((int)int64Value.longValue());
        }
        if (clazz == Short.TYPE) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Short((short)int64Value.longValue());
        }
        if (clazz == Short.class) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Short((short)int64Value.longValue());
        }
        if (clazz == Byte.TYPE) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Byte((byte)int64Value.longValue());
        }
        if (clazz == Byte.class) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Byte((byte)int64Value.longValue());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            if (this.value.length() == 1) {
                return new Character(this.value.charAt(0));
            }
            DynamicError dynamicError = new DynamicError("Cannot convert xs:string to Java char unless length is 1");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SXJE0005");
            throw dynamicError;
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of xs:string to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SXJE0006");
            throw dynamicError;
        }
        return object;
    }

    public String toString() {
        return "\"" + this.value + '\"';
    }

    public static AtomicValue makeRestrictedString(CharSequence charSequence, AtomicType atomicType, NameChecker nameChecker) {
        StringValue stringValue = new StringValue();
        int n = atomicType.getFingerprint();
        stringValue.setTypeLabel(atomicType);
        if (charSequence == null) {
            stringValue.value = "";
        } else if (n == 553) {
            stringValue.value = Whitespace.normalizeWhitespace(charSequence);
        } else if (n == 554) {
            stringValue.value = Whitespace.collapseWhitespace(charSequence);
        } else {
            stringValue.value = Whitespace.trimWhitespace(charSequence);
            if (nameChecker != null) {
                ValidationException validationException = StringValue.validate(atomicType, stringValue.value, nameChecker);
                if (validationException == null) {
                    return stringValue;
                }
                return new ValidationErrorValue(validationException);
            }
            return stringValue;
        }
        return stringValue;
    }

    private static ValidationException validate(AtomicType atomicType, CharSequence charSequence, NameChecker nameChecker) {
        switch (atomicType.getFingerprint()) {
            case 554: {
                return null;
            }
            case 553: {
                return null;
            }
            case 555: {
                String string = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
                if (!Pattern.matches(string, ((Object)charSequence).toString())) {
                    ValidationException validationException = new ValidationException("The value '" + charSequence + "' is not a valid xs:language");
                    validationException.setErrorCode("FORG0001");
                    return validationException;
                }
                return null;
            }
            case 558: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
                fastStringBuffer.append(charSequence);
                for (int i = 0; i < fastStringBuffer.length(); ++i) {
                    if (fastStringBuffer.charAt(i) != ':') continue;
                    fastStringBuffer.setCharAt(i, '_');
                }
                if (!nameChecker.isValidNCName(fastStringBuffer)) {
                    ValidationException validationException = new ValidationException("The value '" + charSequence + "' is not a valid Name");
                    validationException.setErrorCode("FORG0001");
                    return validationException;
                }
                return null;
            }
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                if (!nameChecker.isValidNCName(charSequence)) {
                    ValidationException validationException = new ValidationException("The value '" + charSequence + "' is not a valid NCName");
                    validationException.setErrorCode("FORG0001");
                    return validationException;
                }
                return null;
            }
            case 556: {
                if (!XMLChar.isValidNmtoken(charSequence)) {
                    ValidationException validationException = new ValidationException("The value '" + charSequence + "' is not a valid NMTOKEN");
                    validationException.setErrorCode("FORG0001");
                    return validationException;
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown string value type " + atomicType.getFingerprint());
    }

    public Comparable getSchemaComparable() {
        return ((Object)this.value).toString();
    }

    public final class CharacterIterator
    implements SequenceIterator {
        int inpos = 0;
        int outpos = 0;
        int current = -1;

        public Item next() {
            if (this.inpos < StringValue.this.value.length()) {
                char c;
                this.current = (c = StringValue.this.value.charAt(this.inpos++)) >= '\ud800' && c <= '\udbff' ? (c - 55296) * 1024 + (StringValue.this.value.charAt(this.inpos++) - 56320) + 65536 : (int)c;
                ++this.outpos;
                return new Int64Value(this.current);
            }
            this.outpos = -1;
            return null;
        }

        public Item current() {
            if (this.outpos < 1) {
                return null;
            }
            return new Int64Value(this.current);
        }

        public int position() {
            return this.outpos;
        }

        public SequenceIterator getAnother() {
            return new CharacterIterator();
        }

        public int getProperties() {
            return 0;
        }
    }
}

