/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.AnnotationTypeExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.AnnotationComparator;
import org.apache.uima.ruta.rule.AnnotationListFSIterator;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaAnnotationTypeMatcher;
import org.apache.uima.ruta.rule.RutaLiteralMatcher;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class WildCardRuleElement
extends AbstractRuleElement {
    public WildCardRuleElement(List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions, RuleElementContainer container, RutaBlock parent) {
        super(null, conditions, actions, container, parent);
    }

    @Override
    public List<RuleMatch> startMatch(RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result = this.continueMatch(true, null, ruleMatch, ruleApply, containerMatch, null, entryPoint, stream, crowd);
        return result;
    }

    @Override
    public List<RuleMatch> continueMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        Pair<RuleElement, Integer> next = this.getNextRuleElement(after, this);
        RuleElement nextElement = (RuleElement)next.getLeft();
        int nextDepth = (Integer)next.getRight();
        List<RuleMatch> result = this.tryWithNextRuleElement(nextElement, after, annotation, ruleMatch, ruleApply, containerMatch, nextDepth, sideStepOrigin, entryPoint, stream, crowd);
        return result;
    }

    private Pair<RuleElement, Integer> getNextRuleElement(boolean after, RuleElement element) {
        RuleElement nextElement = null;
        RuleElement current = element;
        int nextDepth = -1;
        while (nextElement == null && current != null && current.getContainer() != null) {
            RuleElementContainer container = current.getContainer();
            nextElement = container.getNextElement(after, current);
            if (!(container instanceof RuleElement)) break;
            current = (RuleElement)((Object)container);
            ++nextDepth;
        }
        if (nextElement == null) {
            nextDepth = 0;
        }
        return new ImmutablePair(nextElement, (Object)nextDepth);
    }

    private List<RuleMatch> tryWithNextRuleElement(RuleElement nextElement, boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, int nextDepth, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result = new ArrayList<RuleMatch>();
        if (nextElement == null) {
            AnnotationFS afs = this.getCoveredByWildCard(after, annotation, null, stream);
            this.doMatch(after, afs, ruleMatch, containerMatch, annotation == null, stream, crowd);
            ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
            result = composed.fallbackContinue(after, !ruleMatch.matched(), afs, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else if (nextElement instanceof RutaRuleElement) {
            RutaRuleElement re = (RutaRuleElement)nextElement;
            RutaMatcher matcher = re.getMatcher();
            if (matcher instanceof RutaAnnotationTypeMatcher) {
                result = this.tryWithNextAnnotationType(after, annotation, nextElement, null, ruleMatch, ruleApply, containerMatch, nextDepth, sideStepOrigin, entryPoint, stream, crowd);
            } else if (matcher instanceof RutaLiteralMatcher) {
                result = this.tryWithNextLiteral(after, annotation, re, ruleMatch, ruleApply, containerMatch, nextDepth, sideStepOrigin, stream, crowd);
            }
        } else if (nextElement instanceof ComposedRuleElement) {
            ComposedRuleElement cre = (ComposedRuleElement)nextElement;
            result = this.tryWithNextComposed(after, annotation, cre, ruleMatch, ruleApply, containerMatch, nextDepth, sideStepOrigin, stream, crowd);
        } else if (nextElement instanceof WildCardRuleElement) {
            CAS cas = stream.getCas();
            result = this.tryWithNextAnnotationType(after, annotation, nextElement, cas.getAnnotationType(), ruleMatch, ruleApply, containerMatch, nextDepth, sideStepOrigin, entryPoint, stream, crowd);
        }
        return result;
    }

    private List<RuleMatch> tryWithNextComposed(boolean after, AnnotationFS annotation, ComposedRuleElement cre, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, int nextDepth, RuleElement sideStepOrigin, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result = new ArrayList<RuleMatch>();
        Object nextOne = annotation;
        boolean doneHere = false;
        while (!doneHere && (nextOne = this.getNextPositionForComposed(cre, after, (AnnotationFS)nextOne, stream)) != null) {
            int pointer = after ? nextOne.getBegin() : nextOne.getEnd();
            RutaBasic anchor = stream.getAnchor(!after, pointer);
            ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
            RuleMatch extendedMatch = ruleMatch.copy(extendedContainerMatch, after);
            AnnotationFS coveredByWildCard = this.getCoveredByWildCard(after, annotation, (AnnotationFS)nextOne, stream);
            this.doMatch(after, coveredByWildCard, extendedMatch, extendedContainerMatch, annotation == null, stream, crowd);
            this.doMatchPotentialParentElements(after, annotation, nextDepth, extendedMatch, extendedContainerMatch, coveredByWildCard, stream, crowd);
            if (extendedMatch.matched()) {
                ComposedRuleElementMatch nextContainerMatch = this.getContainerMatchOfNextElement(extendedContainerMatch, nextDepth);
                int applied = ruleApply.getApplied();
                result = anchor == null ? cre.startMatch(extendedMatch, ruleApply, nextContainerMatch, cre, stream, crowd) : cre.continueMatch(after, (AnnotationFS)anchor, extendedMatch, ruleApply, nextContainerMatch, sideStepOrigin, cre, stream, crowd);
                List<RuleElementMatch> nextList = nextContainerMatch.getInnerMatches().get(cre);
                boolean matched = this.hasMatched(nextList);
                if (!matched) {
                    if (ruleApply.getApplied() > applied) {
                        doneHere = true;
                    }
                    nextOne = stream.getAnchor(after, this.getNextPointer(!after, (AnnotationFS)nextOne));
                    continue;
                }
                doneHere = true;
                continue;
            }
            nextOne = annotation;
        }
        if (!doneHere) {
            ComposedRuleElementMatch nextContainerMatch = this.getContainerMatchOfNextElement(containerMatch, nextDepth);
            result = cre.continueMatch(after, annotation, ruleMatch, ruleApply, nextContainerMatch, sideStepOrigin, null, stream, crowd);
        }
        return result;
    }

    private boolean hasMatched(List<RuleElementMatch> nextList) {
        if (nextList == null || nextList.isEmpty()) {
            return false;
        }
        boolean result = true;
        for (RuleElementMatch each : nextList) {
            result &= each.matched();
        }
        return result;
    }

    private AnnotationFS getNextPositionForComposed(ComposedRuleElement cre, boolean after, AnnotationFS annotation, RutaStream stream) {
        RuleElement element = this.getNextAtomicRuleElement(cre, after);
        AnnotationFS result = null;
        Boolean conjunct = cre.getConjunct();
        if (element instanceof WildCardRuleElement) {
            if (after) {
                return stream.getAnchor(after, annotation.getEnd());
            }
            return stream.getAnchor(after, annotation.getBegin());
        }
        if (conjunct != null && !conjunct.booleanValue()) {
            List<RuleElement> ruleElements = cre.getRuleElements();
            ArrayList<AnnotationFS> nextPostions = new ArrayList<AnnotationFS>();
            for (RuleElement ruleElement : ruleElements) {
                AnnotationFS nextPositionForAtomic;
                if (ruleElement instanceof ComposedRuleElement) {
                    AnnotationFS nextPositionForComposed = this.getNextPositionForComposed((ComposedRuleElement)ruleElement, after, annotation, stream);
                    if (nextPositionForComposed == null) continue;
                    nextPostions.add(nextPositionForComposed);
                    continue;
                }
                if (!(ruleElement instanceof RutaRuleElement) || (nextPositionForAtomic = this.getNextPositionForAtomic(after, annotation, stream, ruleElement, result)) == null) continue;
                nextPostions.add(nextPositionForAtomic);
            }
            if (!nextPostions.isEmpty()) {
                Collections.sort(nextPostions, new AnnotationComparator());
                result = after ? (AnnotationFS)nextPostions.get(0) : (AnnotationFS)nextPostions.get(nextPostions.size() - 1);
            }
        } else {
            result = this.getNextPositionForAtomic(after, annotation, stream, element, result);
        }
        return result;
    }

    private AnnotationFS getNextPositionForAtomic(boolean after, AnnotationFS annotation, RutaStream stream, RuleElement element, AnnotationFS result) {
        RutaRuleElement re = (RutaRuleElement)element;
        RutaMatcher matcher = re.getMatcher();
        if (matcher instanceof RutaLiteralMatcher) {
            int pointer;
            RutaLiteralMatcher lm = (RutaLiteralMatcher)matcher;
            IStringExpression expression = lm.getExpression();
            MatchContext context = new MatchContext(this, null, after);
            String stringValue = expression.getStringValue(context, stream);
            AnnotationFS documentAnnotation = stream.getDocumentAnnotation();
            int delta = documentAnnotation.getBegin();
            String document = documentAnnotation.getCoveredText();
            int indexOf = document.indexOf(stringValue, pointer = annotation.getEnd() - delta);
            if (indexOf < 0) {
                return null;
            }
            return stream.getAnchor(after, indexOf);
        }
        FSIterator<AnnotationFS> iterator = this.getIterator(after, annotation, re, null, stream);
        if (iterator == null) {
            return null;
        }
        if (iterator.isValid()) {
            result = (AnnotationFS)iterator.get();
            if (annotation != null && after && result.getEnd() == annotation.getEnd() || !after && result.getBegin() == annotation.getBegin()) {
                this.moveOn(after, iterator, stream);
                result = iterator.isValid() ? (AnnotationFS)iterator.get() : null;
            }
        }
        return result;
    }

    private RuleElement getNextAtomicRuleElement(ComposedRuleElement cre, boolean after) {
        if (after) {
            RuleElement firstElement = cre.getFirstElement();
            if (firstElement instanceof ComposedRuleElement) {
                return this.getNextAtomicRuleElement((ComposedRuleElement)firstElement, after);
            }
            return firstElement;
        }
        RuleElement lastElement = cre.getLastElement();
        if (lastElement instanceof ComposedRuleElement) {
            return this.getNextAtomicRuleElement((ComposedRuleElement)lastElement, after);
        }
        return lastElement;
    }

    private List<RuleMatch> tryWithNextAnnotationType(boolean after, AnnotationFS annotation, RuleElement nextElement, Type defaultType, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, int nextDepth, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result = new ArrayList<RuleMatch>();
        FSIterator<AnnotationFS> iterator = this.getIterator(after, annotation, nextElement, defaultType, stream);
        if (iterator == null || !iterator.isValid()) {
            RuleElementContainer c = this.getContainer();
            if (c instanceof ComposedRuleElement) {
                ComposedRuleElement cre = (ComposedRuleElement)c;
                MatchContext context = new MatchContext(this, null, after);
                if (nextElement.getQuantifier().isOptional(context, stream)) {
                    AnnotationFS nextAnchor = this.getNextAnchor(after, annotation, nextElement, ruleMatch, containerMatch, sideStepOrigin, stream, crowd);
                    AnnotationFS coveredByWildCard = this.getCoveredByWildCard(after, annotation, nextAnchor, stream);
                    this.doMatch(after, coveredByWildCard, ruleMatch, containerMatch, annotation == null, stream, crowd);
                    if (ruleMatch.matched()) {
                        ComposedRuleElementMatch nextContainerMatch = this.getContainerMatchOfNextElement(containerMatch, nextDepth);
                        result = coveredByWildCard == null ? nextElement.startMatch(ruleMatch, ruleApply, nextContainerMatch, nextElement, stream, crowd) : nextElement.continueMatch(after, coveredByWildCard, ruleMatch, ruleApply, nextContainerMatch, sideStepOrigin, nextElement, stream, crowd);
                    } else {
                        result = cre.fallbackContinue(after, true, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    }
                } else {
                    if (ruleApply == null && entryPoint != null && entryPoint.equals(nextElement)) {
                        return result;
                    }
                    result = cre.fallbackContinue(after, true, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
                }
            }
            return result;
        }
        if (iterator.isValid() && !stream.isVisible((AnnotationFS)iterator.get())) {
            this.moveOn(after, iterator, stream);
        }
        boolean doneHere = false;
        while (!doneHere && iterator.isValid() && stream.isVisible((AnnotationFS)iterator.get())) {
            AnnotationFS nextOne = (AnnotationFS)iterator.get();
            int pointer = after ? nextOne.getBegin() : nextOne.getEnd();
            RutaBasic anchor = stream.getAnchor(!after, pointer);
            ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
            RuleMatch extendedMatch = ruleMatch.copy(extendedContainerMatch, after);
            AnnotationFS coveredByWildCard = this.getCoveredByWildCard(after, annotation, nextOne, stream);
            this.doMatch(after, coveredByWildCard, extendedMatch, extendedContainerMatch, annotation == null, stream, crowd);
            this.doMatchPotentialParentElements(after, annotation, nextDepth, extendedMatch, extendedContainerMatch, coveredByWildCard, stream, crowd);
            if (extendedMatch.matched()) {
                boolean nextElementDidMatch;
                ComposedRuleElementMatch nextContainerMatch = this.getContainerMatchOfNextElement(extendedContainerMatch, nextDepth);
                if (anchor == null) {
                    anchor = stream.getVeryFirstBeforeWindow(after);
                }
                if (!(nextElementDidMatch = this.nextElementDidMatch(result = nextElement.continueMatch(after, (AnnotationFS)anchor, extendedMatch, ruleApply, nextContainerMatch, sideStepOrigin, nextElement, stream, crowd), nextElement))) {
                    this.moveOn(after, iterator, stream);
                    continue;
                }
                doneHere = true;
                continue;
            }
            this.moveOn(after, iterator, stream);
        }
        return result;
    }

    private void doMatchPotentialParentElements(boolean after, AnnotationFS annotation, int nextDepth, RuleMatch extendedMatch, ComposedRuleElementMatch extendedContainerMatch, AnnotationFS coveredByWildCard, RutaStream stream, InferenceCrowd crowd) {
        AbstractRuleElement element = this;
        ComposedRuleElementMatch containerMatch = extendedContainerMatch.getContainerMatch();
        for (int i = nextDepth; i > 0; --i) {
            RuleElementContainer c = element.getContainer();
            if (!(c instanceof ComposedRuleElement)) continue;
            ComposedRuleElement cre = (ComposedRuleElement)c;
            cre.doMatch(after, coveredByWildCard, extendedMatch, extendedContainerMatch.getContainerMatch(), annotation == null, stream, crowd);
            element = cre;
            containerMatch = containerMatch.getContainerMatch();
        }
    }

    private AnnotationFS getNextAnchor(boolean after, AnnotationFS annotation, RuleElement nextElement, RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS nextAnchor = null;
        Pair<RuleElement, Integer> nextNext = this.getNextRuleElement(after, nextElement);
        if (nextNext != null && nextNext.getLeft() != null) {
            List<RuleMatch> tryWithNextNextRuleElement = this.tryWithNextRuleElement((RuleElement)nextNext.getLeft(), after, annotation, ruleMatch, null, containerMatch, (Integer)nextNext.getRight(), sideStepOrigin, (RuleElement)nextNext.getLeft(), stream, crowd);
            for (RuleMatch eachNextRuleMatch : tryWithNextNextRuleElement) {
                List<AnnotationFS> matchedAnnotationsOfElement;
                if (!eachNextRuleMatch.matched() || (matchedAnnotationsOfElement = eachNextRuleMatch.getMatchedAnnotationsOfElement((RuleElement)nextNext.getLeft())) == null || matchedAnnotationsOfElement.isEmpty()) continue;
                nextAnchor = after ? matchedAnnotationsOfElement.get(0) : matchedAnnotationsOfElement.get(matchedAnnotationsOfElement.size() - 1);
                break;
            }
        }
        return nextAnchor;
    }

    private boolean nextElementDidMatch(List<RuleMatch> result, RuleElement nextElement) {
        if (result == null || result.isEmpty()) {
            return false;
        }
        for (RuleMatch ruleMatch : result) {
            if (!ruleMatch.matched()) continue;
            return true;
        }
        for (RuleMatch ruleMatch : result) {
            List<List<RuleElementMatch>> matchInfo = ruleMatch.getMatchInfo(nextElement);
            List<RuleElementMatch> matches = matchInfo.get(matchInfo.size() - 1);
            if (matches == null) continue;
            for (RuleElementMatch ruleElementMatch : matches) {
                if (ruleElementMatch == null || !ruleElementMatch.matched()) continue;
                return true;
            }
        }
        return false;
    }

    private ComposedRuleElementMatch getContainerMatchOfNextElement(ComposedRuleElementMatch extendedContainerMatch, int nextDepth) {
        ComposedRuleElementMatch result = extendedContainerMatch;
        for (int i = 0; i < nextDepth; ++i) {
            result = result.getContainerMatch();
        }
        return result;
    }

    private FSIterator<AnnotationFS> getIterator(boolean after, AnnotationFS annotation, RuleElement nextElement, Type defaultType, RutaStream stream) {
        Object iterator = null;
        if (defaultType == null) {
            MatchContext context = new MatchContext(nextElement.getParent());
            RutaRuleElement re = (RutaRuleElement)nextElement;
            RutaMatcher matcher = re.getMatcher();
            if (matcher instanceof RutaAnnotationTypeMatcher) {
                RutaAnnotationTypeMatcher atm = (RutaAnnotationTypeMatcher)matcher;
                AnnotationTypeExpression expression = (AnnotationTypeExpression)atm.getExpression();
                if (expression.getAnnotationExpression() != null || expression.getAnnotationListExpression() != null) {
                    iterator = new AnnotationListFSIterator(expression.getAnnotationList(context, stream));
                    iterator.moveTo((FeatureStructure)annotation);
                } else {
                    Type type = matcher.getType(this.parent, stream);
                    iterator = this.getIteratorOfType(after, type, annotation, stream);
                }
            } else if (matcher != null) {
                Type type = matcher.getType(this.parent, stream);
                iterator = this.getIteratorOfType(after, type, annotation, stream);
            }
        } else {
            iterator = this.getIteratorOfType(after, defaultType, annotation, stream);
        }
        if (annotation != null && iterator != null && iterator.isValid()) {
            AnnotationFS pointer = (AnnotationFS)iterator.get();
            if (after && pointer.getBegin() < annotation.getEnd() || !after && pointer.getEnd() > annotation.getBegin()) {
                this.moveOn(after, (FSIterator<AnnotationFS>)iterator, stream);
            }
        }
        return iterator;
    }

    private FSIterator<AnnotationFS> getIteratorOfType(boolean after, Type type, AnnotationFS annotation, RutaStream stream) {
        CAS cas = stream.getCas();
        FSIterator result = null;
        if (stream.getDocumentAnnotation().equals(cas.getDocumentAnnotation())) {
            if (annotation == null) {
                result = cas.getAnnotationIndex(type).withSnapshotIterators().iterator();
            } else {
                RutaBasic pointer = stream.getAnchor(after, annotation);
                result = cas.getAnnotationIndex(type).withSnapshotIterators().iterator((FeatureStructure)pointer);
                if (!result.isValid()) {
                    if (!after) {
                        AnnotationFS current;
                        result.moveToLast();
                        if (result.isValid() && (current = (AnnotationFS)result.get()).getEnd() >= annotation.getBegin()) {
                            result.moveToPrevious();
                        }
                    }
                } else if (!after) {
                    result.moveToPrevious();
                }
                if (annotation != null && result.isValid()) {
                    AnnotationFS a = (AnnotationFS)result.get();
                    if (after ? a.getBegin() < annotation.getBegin() : a.getEnd() > annotation.getEnd()) {
                        return null;
                    }
                }
            }
        } else {
            result = cas.getAnnotationIndex(type).select().coveredBy(stream.getDocumentAnnotation()).fsIterator();
            if (annotation != null) {
                RutaBasic pointer = stream.getAnchor(after, annotation);
                result.moveTo((FeatureStructure)pointer);
                if (!result.isValid()) {
                    if (!after) {
                        AnnotationFS current;
                        result.moveToLast();
                        if (result.isValid() && (current = (AnnotationFS)result.get()).getEnd() >= annotation.getBegin()) {
                            result.moveToPrevious();
                        }
                    }
                } else if (!after) {
                    result.moveToPrevious();
                }
            }
        }
        return result;
    }

    private List<RuleMatch> tryWithNextLiteral(boolean after, AnnotationFS annotation, RutaRuleElement nextElement, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, int nextDepth, RuleElement sideStepOrigin, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result = new ArrayList<RuleMatch>();
        RutaLiteralMatcher matcher = (RutaLiteralMatcher)nextElement.getMatcher();
        if (matcher == null) {
            return result;
        }
        IStringExpression expression = matcher.getExpression();
        MatchContext context = new MatchContext(this, ruleMatch, true);
        String stringValue = expression.getStringValue(context, stream);
        AnnotationFS documentAnnotation = stream.getDocumentAnnotation();
        int delta = documentAnnotation.getBegin();
        String document = documentAnnotation.getCoveredText();
        int pointer = 0;
        if (annotation != null) {
            pointer = annotation.getEnd() - delta;
        }
        int indexOf = 0;
        boolean doneHere = false;
        while (!doneHere && (indexOf = document.indexOf(stringValue, pointer)) < document.length()) {
            if (indexOf < 0) {
                ComposedRuleElementMatch nextContainerMatch = this.getContainerMatchOfNextElement(containerMatch, nextDepth);
                nextElement.continueMatch(after, annotation, ruleMatch, ruleApply, nextContainerMatch, sideStepOrigin, null, stream, crowd);
                doneHere = true;
                break;
            }
            RutaBasic anchor = stream.getAnchor(after, indexOf + delta);
            RutaBasic endAnchor = stream.getAnchor(!after, indexOf + delta);
            ComposedRuleElementMatch extendedContainerMatch = containerMatch.copy();
            RuleMatch extendedMatch = ruleMatch.copy(extendedContainerMatch, after);
            AnnotationFS coveredByWildCard = this.getCoveredByWildCard(after, annotation, (AnnotationFS)anchor, stream);
            this.doMatch(after, coveredByWildCard, extendedMatch, extendedContainerMatch, annotation == null, stream, crowd);
            this.doMatchPotentialParentElements(after, annotation, nextDepth, extendedMatch, extendedContainerMatch, coveredByWildCard, stream, crowd);
            if (extendedMatch.matched()) {
                ComposedRuleElementMatch nextContainerMatch = this.getContainerMatchOfNextElement(extendedContainerMatch, nextDepth);
                result = endAnchor == null ? nextElement.startMatch(extendedMatch, ruleApply, nextContainerMatch, nextElement, stream, crowd) : nextElement.continueMatch(after, (AnnotationFS)endAnchor, extendedMatch, ruleApply, nextContainerMatch, sideStepOrigin, nextElement, stream, crowd);
                List<RuleElementMatch> nextList = nextContainerMatch.getInnerMatches().get(nextElement);
                if (nextList == null || nextList.isEmpty()) {
                    pointer = this.getNextPointer(after, (AnnotationFS)anchor);
                    continue;
                }
                doneHere = true;
                continue;
            }
            pointer = this.getNextPointer(after, (AnnotationFS)anchor);
        }
        return result;
    }

    private int getNextPointer(boolean after, AnnotationFS anchor) {
        if (after) {
            return anchor.getEnd();
        }
        return anchor.getBegin();
    }

    private void moveOn(boolean after, FSIterator<AnnotationFS> iterator, RutaStream stream) {
        if (after) {
            iterator.moveToNext();
        } else {
            iterator.moveToPrevious();
        }
        while (iterator.isValid() && !stream.isVisible((AnnotationFS)iterator.get())) {
            if (after) {
                iterator.moveToNext();
                continue;
            }
            iterator.moveToPrevious();
        }
    }

    private AnnotationFS getCoveredByWildCard(boolean after, AnnotationFS last, AnnotationFS next, RutaStream stream) {
        CAS cas = stream.getCas();
        Type type = cas.getAnnotationType();
        AnnotationFS documentAnnotation = stream.getDocumentAnnotation();
        AnnotationFS before = last;
        AnnotationFS later = next;
        if (!after) {
            before = next;
            later = last;
        }
        int begin = documentAnnotation.getBegin();
        int end = documentAnnotation.getEnd();
        if (before != null) {
            begin = before.getEnd();
        }
        if (later != null) {
            end = later.getBegin();
        }
        int filteredBegin = begin;
        int filteredEnd = end;
        RutaBasic beginAnchor = stream.getBeginAnchor(begin);
        RutaBasic endAnchor = stream.getEndAnchor(end);
        if (beginAnchor != null && !stream.isVisible((AnnotationFS)beginAnchor) && (beginAnchor = stream.getBasicNextTo(false, (AnnotationFS)beginAnchor)) != null) {
            filteredBegin = beginAnchor.getBegin();
        }
        if (endAnchor != null && !stream.isVisible((AnnotationFS)endAnchor) && (endAnchor = stream.getBasicNextTo(true, (AnnotationFS)endAnchor)) != null) {
            filteredEnd = endAnchor.getEnd();
        }
        if (filteredBegin < filteredEnd) {
            begin = filteredBegin;
            end = filteredEnd;
        } else {
            type = cas.getTypeSystem().getType("org.apache.uima.ruta.type.RutaOptional");
        }
        AnnotationFS afs = cas.createAnnotation(type, begin, end);
        return afs;
    }

    @Override
    public void doMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, boolean ruleAnchor, RutaStream stream, InferenceCrowd crowd) {
        RuleElementMatch result = new RuleElementMatch(this, containerMatch);
        result.setRuleAnchor(ruleAnchor);
        ArrayList<EvaluatedCondition> evaluatedConditions = new ArrayList<EvaluatedCondition>(this.conditions.size());
        boolean base = true;
        MatchContext context = new MatchContext(annotation, this, ruleMatch, true);
        List<AnnotationFS> textsMatched = annotation != null ? Arrays.asList(annotation) : Collections.emptyList();
        result.setMatchInfo(base, textsMatched, stream);
        RutaEnvironment environment = context.getParent().getEnvironment();
        environment.addMatchToVariable(ruleMatch, this, context, stream);
        if (base) {
            for (AbstractRutaCondition condition : this.conditions) {
                crowd.beginVisit(condition, null);
                EvaluatedCondition eval = condition.eval(context, stream, crowd);
                crowd.endVisit(condition, null);
                evaluatedConditions.add(eval);
                if (eval.isValue()) continue;
                break;
            }
        }
        result.setConditionInfo(base, evaluatedConditions);
        if (result.matched()) {
            boolean inlinedRulesMatched = this.matchInlinedRules(ruleMatch, result, stream, crowd);
            result.setInlinedRulesMatched(inlinedRulesMatched);
        } else {
            environment.removeVariableValue(this.getLabel(), context);
        }
        ruleMatch.setMatched(ruleMatch.matched() && result.matched());
    }

    @Override
    public List<RuleMatch> continueOwnMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        return Collections.emptyList();
    }

    public Collection<AnnotationFS> getAnchors(RutaStream symbolStream) {
        return Collections.emptyList();
    }

    @Override
    public long estimateAnchors(RutaStream stream) {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "#" + (String)(this.conditions.isEmpty() ? "" : "(" + this.conditions.toString() + ")\\n") + (String)(this.actions.isEmpty() ? "" : "{" + this.actions.toString() + "}");
    }
}

