/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.seed;

import java.io.BufferedReader;
import java.io.StringReader;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.ruta.seed.RutaAnnotationSeeder;
import org.apache.uima.ruta.seed.SeedLexer;
import org.apache.uima.ruta.type.TokenSeed;

public class TextSeeder
implements RutaAnnotationSeeder {
    public static final String seedType = "org.apache.uima.ruta.type.TokenSeed";

    @Override
    public Type seed(String text, CAS cas) {
        Type result = null;
        JCas jCas = null;
        int size = 0;
        try {
            jCas = cas.getJCas();
            size = jCas.getAnnotationIndex(TokenSeed.type).size();
            result = jCas.getTypeSystem().getType(seedType);
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
        if (jCas == null || size != 0 || text == null) {
            return result;
        }
        BufferedReader reader = new BufferedReader(new StringReader(text));
        SeedLexer sourceLexer = new SeedLexer(reader);
        sourceLexer.setJCas(jCas);
        AnnotationFS a = null;
        try {
            a = sourceLexer.yylex();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        while (a != null) {
            cas.addFsToIndexes((FeatureStructure)a);
            try {
                a = sourceLexer.yylex();
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

