/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.quantifier.NormalQuantifier;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public abstract class AbstractRuleElement
extends RutaElement
implements RuleElement {
    protected static final InferenceCrowd EMPTY_CROWD = new InferenceCrowd(Collections.emptyList());
    protected RuleElementQuantifier quantifier;
    protected List<AbstractRutaCondition> conditions;
    protected List<AbstractRutaAction> actions;
    private boolean startAnchor;
    private String label;
    private RuleElementContainer container;
    protected RutaBlock parent;
    protected List<List<RutaStatement>> inlinedConditionRuleBlocks = new ArrayList<List<RutaStatement>>();
    protected List<List<RutaStatement>> inlinedActionRuleBlocks = new ArrayList<List<RutaStatement>>();

    public AbstractRuleElement(RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions, RuleElementContainer container, RutaBlock parent) {
        this.quantifier = quantifier;
        this.conditions = conditions;
        this.actions = actions;
        this.container = container;
        this.parent = parent;
        if (this.conditions == null) {
            this.conditions = new ArrayList<AbstractRutaCondition>();
        }
        if (this.actions == null) {
            this.actions = new ArrayList<AbstractRutaAction>();
        }
        if (this.quantifier == null) {
            this.quantifier = new NormalQuantifier();
        }
    }

    @Override
    public List<RuleMatch> continueSideStep(boolean after, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result = new ArrayList<RuleMatch>();
        boolean newDirection = !after;
        List<AnnotationFS> matchedAnnotationsOf = ruleMatch.getMatchedAnnotationsOfElement(this);
        AnnotationFS annotation = null;
        if (!matchedAnnotationsOf.isEmpty()) {
            MatchContext context;
            annotation = newDirection ? matchedAnnotationsOf.get(matchedAnnotationsOf.size() - 1) : matchedAnnotationsOf.get(0);
            ComposedRuleElementMatch sideStepContainerMatch = containerMatch;
            if (!containerMatch.getRuleElement().equals(this.getContainer())) {
                List<RuleElementMatch> list;
                List<List<RuleElementMatch>> matchInfo = ruleMatch.getMatchInfo((ComposedRuleElement)this.getContainer());
                if (newDirection) {
                    list = matchInfo.get(matchInfo.size() - 1);
                    sideStepContainerMatch = (ComposedRuleElementMatch)list.get(list.size() - 1);
                } else {
                    list = matchInfo.get(0);
                    sideStepContainerMatch = (ComposedRuleElementMatch)list.get(0);
                }
            }
            if (this.quantifier.continueMatch(newDirection, context = new MatchContext(this, ruleMatch, newDirection), annotation, sideStepContainerMatch, stream, crowd)) {
                this.continueMatch(newDirection, annotation, ruleMatch, ruleApply, sideStepContainerMatch, null, entryPoint, stream, crowd);
            } else {
                RuleElement nextRuleElement = this.getContainer().getNextElement(newDirection, this);
                if (nextRuleElement != null) {
                    RuleElement sideStepOrigin = null;
                    if (this.getContainer() instanceof RuleElement) {
                        sideStepOrigin = (RuleElement)((Object)this.getContainer());
                    }
                    result = nextRuleElement.continueMatch(newDirection, annotation, ruleMatch, ruleApply, sideStepContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                } else if (this.getContainer() instanceof ComposedRuleElement) {
                    ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
                    result = composed.fallbackContinue(newDirection, false, annotation, ruleMatch, ruleApply, sideStepContainerMatch, composed, entryPoint, stream, crowd);
                }
            }
        }
        return result;
    }

    protected void doneMatching(RuleMatch ruleMatch, RuleApply ruleApply, RutaStream stream, InferenceCrowd crowd) {
        if (!ruleMatch.isApplied() && ruleApply != null) {
            ruleApply.add(ruleMatch, stream);
            if (ruleMatch.matchedCompletely()) {
                RutaRule rule = (RutaRule)ruleMatch.getRule();
                rule.getEnvironment().acceptTempVariableValues(rule.getOwnLabels());
                rule.getRoot().applyRuleElements(ruleMatch, stream, crowd);
            }
            ruleMatch.setApplied(true);
        }
    }

    protected void processInlinedActionRules(RuleMatch ruleMatch, RutaStream stream, InferenceCrowd crowd) {
        List<List<RuleElementMatch>> matchInfo = ruleMatch.getMatchInfo(this);
        if (matchInfo == null || matchInfo.isEmpty() || matchInfo.get(0) == null || matchInfo.get(0).isEmpty()) {
            return;
        }
        RuleElementMatch ruleElementMatch = matchInfo.get(0).get(0);
        this.processInlinedActionRules(ruleMatch, ruleElementMatch, stream, crowd);
    }

    protected List<List<ScriptApply>> processInlinedActionRules(RuleMatch ruleMatch, RuleElementMatch ruleElementMatch, RutaStream stream, InferenceCrowd crowd) {
        if (this.inlinedActionRuleBlocks != null && !this.inlinedActionRuleBlocks.isEmpty()) {
            List<List<ScriptApply>> inlinedBlocksApplies = this.processInlinedRules(this.inlinedActionRuleBlocks, ruleMatch, stream, crowd);
            ruleElementMatch.setInlinedActionRules(inlinedBlocksApplies);
            return inlinedBlocksApplies;
        }
        return null;
    }

    protected List<List<ScriptApply>> processInlinedConditionRules(RuleMatch ruleMatch, RuleElementMatch ruleElementMatch, RutaStream stream, InferenceCrowd crowd) {
        if (this.inlinedConditionRuleBlocks != null && !this.inlinedConditionRuleBlocks.isEmpty()) {
            List<List<ScriptApply>> inlinedBlocksApplies = this.processInlinedRules(this.inlinedConditionRuleBlocks, ruleMatch, stream, crowd);
            ruleElementMatch.setInlinedConditionRules(inlinedBlocksApplies);
            return inlinedBlocksApplies;
        }
        return null;
    }

    protected List<List<ScriptApply>> processInlinedRules(List<List<RutaStatement>> inlinedRuleBlocks, RuleMatch ruleMatch, RutaStream stream, InferenceCrowd crowd) {
        ArrayList<List<ScriptApply>> result = new ArrayList<List<ScriptApply>>();
        List<AnnotationFS> matchedAnnotationsOf = ruleMatch.getMatchedAnnotationsOfElement(this);
        for (AnnotationFS annotationFS : matchedAnnotationsOf) {
            RutaStream windowStream = stream.getWindowStream(annotationFS, annotationFS.getType());
            for (List<RutaStatement> inlinedRules : inlinedRuleBlocks) {
                ArrayList<ScriptApply> blockResult = new ArrayList<ScriptApply>();
                for (RutaStatement each : inlinedRules) {
                    ScriptApply apply = each.apply(windowStream, crowd);
                    blockResult.add(apply);
                    if (!(each instanceof RutaRule)) continue;
                    ((RutaRule)each).clearOwnLabels();
                }
                result.add(blockResult);
            }
        }
        return result;
    }

    @Override
    public void apply(RuleMatch ruleMatch, RutaStream stream, InferenceCrowd crowd) {
        for (AbstractRutaAction action : this.actions) {
            crowd.beginVisit(action, null);
            action.execute(new MatchContext(this, ruleMatch), stream, crowd);
            crowd.endVisit(action, null);
        }
        this.processInlinedActionRules(ruleMatch, stream, crowd);
    }

    protected boolean matchInlinedRules(RuleMatch ruleMatch, RuleElementMatch ruleElementMatch, RutaStream stream, InferenceCrowd crowd) {
        List<List<ScriptApply>> blockResults = this.processInlinedConditionRules(ruleMatch, ruleElementMatch, stream, crowd);
        if (blockResults == null) {
            return true;
        }
        boolean matched = true;
        for (List<ScriptApply> list : blockResults) {
            matched &= this.atLeastOneRuleMatched(list);
        }
        return matched;
    }

    private boolean atLeastOneRuleMatched(List<ScriptApply> list) {
        for (ScriptApply scriptApply : list) {
            if (!(scriptApply instanceof RuleApply)) continue;
            RuleApply ra = (RuleApply)scriptApply;
            if (ra.applied <= 0) continue;
            return true;
        }
        return false;
    }

    protected List<RuleElementMatch> getMatch(RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch) {
        List<RuleElementMatch> matchInfo = containerMatch != null ? containerMatch.getInnerMatches().get(this) : ruleMatch.getMatchInfo(this).get(0);
        return matchInfo;
    }

    @Override
    public List<RuleElementMatch> evaluateMatches(List<RuleElementMatch> matches, MatchContext context, RutaStream stream) {
        return this.quantifier.evaluateMatches(matches, context, stream, EMPTY_CROWD);
    }

    @Override
    public List<Integer> getSelfIndexList() {
        if (this.getContainer() == null) {
            return null;
        }
        return Arrays.asList(this.getContainer().getRuleElements().indexOf(this) + 1);
    }

    @Override
    public boolean hasAncestor(boolean after) {
        RuleElementContainer c = this.getContainer();
        if (c == null) {
            return false;
        }
        RuleElement nextElement = c.getNextElement(after, this);
        if (nextElement != null) {
            return true;
        }
        if (c instanceof ComposedRuleElement) {
            return ((ComposedRuleElement)c).hasAncestor(after);
        }
        return false;
    }

    protected boolean earlyExit(AnnotationFS eachAnchor, RuleApply ruleApply, RutaStream stream) {
        if (stream.isGreedyAnchoring() && ruleApply != null && this.isAlreadyCovered(eachAnchor, ruleApply, stream)) {
            return true;
        }
        return stream.isOnlyOnce() && ruleApply != null && ruleApply.getApplied() > 0;
    }

    private boolean isAlreadyCovered(AnnotationFS eachAnchor, RuleApply ruleApply, RutaStream stream) {
        if (eachAnchor == null) {
            return false;
        }
        List<AbstractRuleMatch<? extends AbstractRule>> list = ruleApply.getList();
        Collections.reverse(list);
        for (AbstractRuleMatch<? extends AbstractRule> each : list) {
            if (!(each instanceof RuleMatch)) continue;
            RuleMatch rm = (RuleMatch)each;
            List<Object> matchedAnnotationsOf = Collections.emptyList();
            if (stream.isGreedyRule()) {
                matchedAnnotationsOf = rm.getMatchedAnnotationsOfRoot();
            } else if (stream.isGreedyRuleElement()) {
                matchedAnnotationsOf = rm.getMatchedAnnotationsOfElement(this);
            }
            for (AnnotationFS annotationFS : matchedAnnotationsOf) {
                if (eachAnchor.getBegin() >= annotationFS.getBegin() && eachAnchor.getEnd() <= annotationFS.getEnd()) {
                    return true;
                }
                if (eachAnchor.getBegin() >= annotationFS.getEnd()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public RuleElementQuantifier getQuantifier() {
        return this.quantifier;
    }

    @Override
    public RutaBlock getParent() {
        return this.parent;
    }

    @Override
    public List<AbstractRutaCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<AbstractRutaCondition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public List<AbstractRutaAction> getActions() {
        return this.actions;
    }

    public void setActions(List<AbstractRutaAction> actions) {
        this.actions = actions;
    }

    public void setQuantifier(RuleElementQuantifier quantifier) {
        this.quantifier = quantifier;
    }

    @Override
    public RuleElementContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(RuleElementContainer container) {
        this.container = container;
    }

    @Override
    public void setStartAnchor(boolean start) {
        this.startAnchor = start;
    }

    @Override
    public boolean isStartAnchor() {
        return this.startAnchor;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void addInlinedConditionRules(List<RutaStatement> innerRules) {
        this.inlinedConditionRuleBlocks.add(innerRules);
    }

    @Override
    public List<List<RutaStatement>> getInlinedConditionRuleBlocks() {
        return this.inlinedConditionRuleBlocks;
    }

    @Override
    public void addInlinedActionRules(List<RutaStatement> innerRules) {
        this.inlinedActionRuleBlocks.add(innerRules);
    }

    @Override
    public List<List<RutaStatement>> getInlinedActionRuleBlocks() {
        return this.inlinedActionRuleBlocks;
    }
}

