/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.engine.HtmlConverterPSpan;
import org.apache.uima.ruta.engine.HtmlConverterPSpanReplacement;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.Level;

public class RutaCutter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT_VIEW = "outputView";
    @ConfigurationParameter(name="outputView", mandatory=false, defaultValue={"cutted"})
    private String outputViewName;
    public static final String PARAM_INPUT_VIEW = "inputView";
    @ConfigurationParameter(name="inputView", mandatory=false, defaultValue={"_InitialView"})
    private String inputViewName;
    public static final String PARAM_KEEP = "keep";
    @ConfigurationParameter(name="keep", mandatory=false, defaultValue={"_InitialView"})
    private String keep;
    private static final String DEFAULT_OUTPUT_VIEW = "cutted";
    private static final String DEFAULT_INPUT_VIEW = "_InitialView";
    private int[] map;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.inputViewName = (String)aContext.getConfigParameterValue(PARAM_INPUT_VIEW);
        this.inputViewName = StringUtils.isBlank((CharSequence)this.inputViewName) ? DEFAULT_INPUT_VIEW : this.inputViewName;
        this.outputViewName = (String)aContext.getConfigParameterValue(PARAM_OUTPUT_VIEW);
        this.outputViewName = StringUtils.isBlank((CharSequence)this.outputViewName) ? DEFAULT_OUTPUT_VIEW : this.outputViewName;
        this.keep = (String)aContext.getConfigParameterValue(PARAM_KEEP);
    }

    public void process(JCas jcaz) throws AnalysisEngineProcessException {
        JCas jcas;
        try {
            jcas = this.inputViewName != null ? jcaz.getView(this.inputViewName) : jcaz;
        }
        catch (CASException e1) {
            throw new AnalysisEngineProcessException(e1.getCause());
        }
        String documentText = jcas.getDocumentText();
        this.map = new int[documentText.length() + 1];
        JCas modview = null;
        try {
            Iterator viewIterator = jcas.getViewIterator();
            while (viewIterator.hasNext()) {
                JCas jCas2 = (JCas)viewIterator.next();
                if (!jCas2.getViewName().equals(this.outputViewName)) continue;
                modview = jCas2;
                this.getContext().getLogger().log(Level.WARNING, "view with name \"" + this.outputViewName + "\" already exists.");
            }
            if (modview == null) {
                modview = jcas.createView(this.outputViewName);
            }
        }
        catch (CASException e) {
            e.printStackTrace();
            return;
        }
        TreeSet<HtmlConverterPSpan> visibleSpansSoFar = new TreeSet<HtmlConverterPSpan>();
        TypeSystem typeSystem = jcas.getTypeSystem();
        Type keepType = typeSystem.getType(this.keep);
        if (keepType == null) {
            Iterator typeIterator = typeSystem.getTypeIterator();
            while (typeIterator.hasNext()) {
                FSIterator type = (Type)typeIterator.next();
                String shortName = type.getShortName();
                if (!shortName.equals(this.keep)) continue;
                keepType = type;
                break;
            }
            if (keepType == null) {
                this.getContext().getLogger().log(Level.WARNING, "Type \"" + this.keep + "\" not defined.");
                return;
            }
        }
        AnnotationIndex annotationIndex = jcas.getCas().getAnnotationIndex(keepType);
        for (AnnotationFS each : annotationIndex) {
            visibleSpansSoFar.add(new HtmlConverterPSpan(each.getBegin(), each.getEnd(), each.getCoveredText()));
        }
        StringBuffer sbu = new StringBuffer(documentText.length());
        int originalOffsetI = 0;
        int outOffset = 0;
        for (HtmlConverterPSpan vis : visibleSpansSoFar) {
            int begin = vis.getBegin();
            int end = vis.getEnd();
            while (originalOffsetI < begin) {
                this.map[originalOffsetI++] = outOffset;
            }
            String s = "";
            if (vis instanceof HtmlConverterPSpanReplacement) {
                s = vis.getTxt();
                while (originalOffsetI < begin + s.length()) {
                    this.map[originalOffsetI++] = outOffset++;
                }
                while (originalOffsetI < end) {
                    this.map[originalOffsetI++] = outOffset;
                }
            } else {
                s = documentText.substring(begin, end);
                while (originalOffsetI < end) {
                    this.map[originalOffsetI++] = outOffset++;
                }
            }
            sbu.append(s);
        }
        while (originalOffsetI < documentText.length()) {
            this.map[originalOffsetI++] = outOffset;
        }
        this.map[documentText.length()] = outOffset + 1;
        String modTxt = sbu.toString();
        modview.setDocumentText(modTxt);
        try {
            this.mapAnnotations(jcas, this.map, this.outputViewName);
        }
        catch (CASException e) {
            e.printStackTrace();
        }
    }

    private void mapAnnotations(JCas fromJcas, int[] map, String toView) throws CASException {
        JCas modview = fromJcas.getView(toView);
        HashSet<Annotation> indexedFs = new HashSet<Annotation>();
        AnnotationIndex annotationIndex = fromJcas.getAnnotationIndex();
        TypeSystem typeSystem = fromJcas.getTypeSystem();
        Type docType = typeSystem.getType("uima.tcas.DocumentAnnotation");
        CasCopier casCopier = new CasCopier(fromJcas.getCas(), modview.getCas());
        for (Annotation annotation : annotationIndex) {
            int mappedEnd;
            if (typeSystem.subsumes(docType, annotation.getType())) continue;
            Annotation clone = (Annotation)casCopier.copyFs((FeatureStructure)annotation);
            clone.setFeatureValue(modview.getTypeSystem().getFeatureByFullName("uima.cas.AnnotationBase:sofa"), (FeatureStructure)modview.getSofa());
            int mappedBegin = map[clone.getBegin()];
            if (mappedBegin >= (mappedEnd = map[clone.getEnd()])) continue;
            if (mappedEnd > fromJcas.getCas().getDocumentAnnotation().getEnd()) {
                this.getContext().getLogger().log(Level.WARNING, "illegal annotation offset mapping");
                continue;
            }
            int max = modview.getCas().getDocumentAnnotation().getEnd();
            if (mappedBegin < max && mappedEnd <= max && mappedBegin >= 0 && mappedEnd > 0) {
                clone.setBegin(mappedBegin);
                clone.setEnd(mappedEnd);
                modview.addFsToIndexes((FeatureStructure)clone);
                indexedFs.add(clone);
                continue;
            }
            this.getContext().getLogger().log(Level.WARNING, "illegal annotation offset mapping");
        }
    }
}

