/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.feature.FeatureMatchExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class FeatureCondition
extends AbstractRutaCondition {
    private final IStringExpression featureStringExpression;
    private IRutaExpression argExpr;

    public FeatureCondition(IStringExpression feature, IRutaExpression argExpr) {
        this.featureStringExpression = feature;
        this.argExpr = argExpr;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        if (annotation == null) {
            return new EvaluatedCondition(this, false);
        }
        String typeWithFeature = annotation.getType().getName() + "." + this.featureStringExpression.getStringValue(context, stream);
        MatchReference mf = new MatchReference(typeWithFeature);
        FeatureMatchExpression fme = new FeatureMatchExpression(mf, "==", this.argExpr);
        boolean checkFeatureValue = fme.checkFeatureValue((FeatureStructure)annotation, context, stream);
        return new EvaluatedCondition(this, checkFeatureValue);
    }

    public IStringExpression getFeatureStringExpression() {
        return this.featureStringExpression;
    }

    public IRutaExpression getArgExpr() {
        return this.argExpr;
    }
}

