/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.apache.uima.ruta.ide.core.parser.DLTKTokenConverter;
import org.apache.uima.ruta.ide.core.parser.RutaParseUtils;
import org.apache.uima.ruta.ide.core.parser.RutaParser;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;

public class DLTKRutaErrorReporter {
    IProblemReporter reporter;
    DLTKTokenConverter converter;
    RutaParser parser;
    List problems = new ArrayList();

    public DLTKRutaErrorReporter(DLTKTokenConverter converter, IProblemReporter reporter, RutaParser parser) {
        this.converter = converter;
        this.reporter = reporter;
        this.parser = parser;
    }

    public void reportError(RecognitionException re) {
        if (this.reporter == null) {
            return;
        }
        if (re.token == null) {
            System.out.println("Token is null in ErrorReporter");
            return;
        }
        Token token = re.token;
        int line = re.token.getLine();
        int index = token.getTokenIndex();
        if (index < 0) {
            index = re.index;
            TokenStream tokenStream = this.parser.getTokenStream();
            if (index > 0) {
                token = tokenStream.get(index - 1);
                line = token.getLine();
            }
        }
        String message = re.getMessage();
        String m = "";
        if (message != null) {
            m = message;
        }
        String tokenText = token.getText() == null ? "" : token.getText();
        int[] bounds = RutaParseUtils.getBounds(token);
        int st = bounds[0];
        int et = bounds[1];
        String errorPrefix = "";
        if (re instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)re;
            errorPrefix = "Syntax error: ";
            m = errorPrefix + tokenText + nvae.grammarDecisionDescription;
            this.reportProblem(line, m, st, et);
        } else if (re instanceof MismatchedTokenException) {
            errorPrefix = "Mismatched Input: ";
            MismatchedTokenException mte = (MismatchedTokenException)re;
            int expecting = mte.expecting;
            String expectedToken = "";
            if (expecting > 0) {
                expectedToken = this.parser.getTokenNames()[expecting];
                errorPrefix = errorPrefix + "Expecting \"" + expectedToken;
                String msg = errorPrefix + "\" but found \"" + tokenText + "\".";
                this.reportProblem(line, msg, st, et);
            } else {
                this.reportDefaultProblem(line, m, tokenText, st, et, errorPrefix);
            }
        } else if (re instanceof FailedPredicateException) {
            errorPrefix = "Failed predicate: ";
            this.reportDefaultProblem(line, m, tokenText, st, et, errorPrefix);
        } else {
            String[] messages = new String[]{"Syntax Error:" + message, message};
            if (message == null) {
                messages[0] = re.toString();
            }
            DLTKToken convert = this.converter.convert(re.token);
            DefaultProblem defaultProblem = new DefaultProblem("", messages[0], 0, new String[0], ProblemSeverities.Error, st, et, re.token.getLine());
            if (!this.problems.contains(defaultProblem)) {
                this.reporter.reportProblem((IProblem)defaultProblem);
                this.problems.add(defaultProblem);
                System.out.println(messages[0] + " ### line " + re.token.getLine());
            }
        }
    }

    private void reportDefaultProblem(int line, String m, String tokenText, int st, int et, String errorPrefix) {
        String msg = errorPrefix + m + " : " + tokenText;
        this.reportProblem(line, msg, st, et);
    }

    private void reportProblem(int line, String msg, int st, int et) {
        DefaultProblem defaultProblem = this.createDefaultProblem(msg, st, et, line);
        if (!this.problems.contains(defaultProblem)) {
            this.reporter.reportProblem((IProblem)defaultProblem);
            this.problems.add(defaultProblem);
        }
    }

    private DefaultProblem createDefaultProblem(String m, int st, int et, int line) {
        return new DefaultProblem("", m, 0, new String[0], ProblemSeverities.Error, st, et, line);
    }

    public void reportThrowable(Throwable extre) {
        extre.printStackTrace();
    }

    public void reportMessage(String msg) {
    }

    public void reportErrorOld(RecognitionException re) {
        if (this.reporter == null) {
            return;
        }
        if (re.token == null) {
            System.out.println("Token is null in ErrorReporter");
            return;
        }
        Token token = re.token;
        int line = re.token.getLine();
        int index = token.getTokenIndex();
        if (index < 0) {
            index = re.index;
            TokenStream tokenStream = this.parser.getTokenStream();
            try {
                token = tokenStream.get(index - 1);
                line = token.getLine();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        String message = re.getMessage();
        String m = "unknown error";
        if (message != null) {
            m = message;
        }
        if (re instanceof NoViableAltException) {
            NoViableAltException ec = (NoViableAltException)re;
            m = message == null || ec.token.getText() == null ? ec.toString() : "Syntax Error:" + message + " : " + ec.token.getText();
            String[] messages = new String[]{m};
            int st = this.converter.convert(ec.token.getLine(), ec.token.getCharPositionInLine());
            String sm = ec.token.getText();
            int et = st + ec.token.getText().length();
            if (st == -1) {
                return;
            }
            DefaultProblem defaultProblem = new DefaultProblem("", messages[0], 0, new String[0], ProblemSeverities.Error, st, et, ec.token.getLine());
            if (!this.problems.contains(defaultProblem)) {
                this.reporter.reportProblem((IProblem)defaultProblem);
                this.problems.add(defaultProblem);
                System.out.println(messages[0] + " ### line " + ec.token.getLine());
            }
        } else if (re instanceof MismatchedTokenException) {
            DefaultProblem defaultProblem;
            int st;
            MismatchedTokenException ec = (MismatchedTokenException)re;
            m = message == null || ec.token.getText() == null ? ec.toString() : "mismatched input: " + message + " : " + ec.token.getText();
            String[] messages = new String[]{m};
            int et = st = this.converter.convert(ec.token.getLine(), ec.token.getCharPositionInLine());
            if (ec.token.getText() != null) {
                et = ec.token.getText().length() + st;
                if (et >= this.converter.length()) {
                    et = this.converter.length() - 1;
                    st -= 2;
                }
            } else {
                st = ((CommonToken)token).getStartIndex();
                et = ((CommonToken)token).getStopIndex();
            }
            if (!this.problems.contains(defaultProblem = new DefaultProblem("", messages[0], 0, new String[0], ProblemSeverities.Error, st, et, ec.line))) {
                this.reporter.reportProblem((IProblem)defaultProblem);
                this.problems.add(defaultProblem);
                System.out.println(messages[0] + " ### line " + ec.line);
            }
        } else if (re instanceof FailedPredicateException) {
            String[] messages = new String[]{"Syntax Error:" + message, message};
            if (message == null) {
                messages[0] = re.toString();
            }
            DLTKToken convert = this.converter.convert(re.token);
            int st = convert.getColumn();
            int et = convert.getColumn() + convert.getText().length();
            DefaultProblem defaultProblem = new DefaultProblem("", "Type not defined in this script: " + convert.getText(), 0, new String[0], ProblemSeverities.Warning, st, et, re.token.getLine());
            if (!this.problems.contains(defaultProblem)) {
                this.reporter.reportProblem((IProblem)defaultProblem);
                this.problems.add(defaultProblem);
                System.out.println(messages[0] + " ### line " + re.token.getLine());
            }
        } else {
            int et;
            DLTKToken convert;
            int st;
            DefaultProblem defaultProblem;
            String[] messages = new String[]{"Syntax Error:" + message, message};
            if (message == null) {
                messages[0] = re.toString();
            }
            if (!this.problems.contains(defaultProblem = new DefaultProblem("", messages[0], 0, new String[0], ProblemSeverities.Error, st = (convert = this.converter.convert(re.token)).getColumn(), et = convert.getColumn() + convert.getText().length(), re.token.getLine()))) {
                this.reporter.reportProblem((IProblem)defaultProblem);
                this.problems.add(defaultProblem);
                System.out.println(messages[0] + " ### line " + re.token.getLine());
            }
        }
    }
}

