/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.caseditor.view.tree.AbstractTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ArrayFeatureTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.FSFeatureTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;
import org.apache.uima.ruta.caseditor.view.tree.PrimitiveFeatureTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;
import org.eclipse.core.runtime.IAdaptable;

public class FSTreeNode
extends AbstractTreeNode
implements IAdaptable {
    protected FeatureStructure fs;

    public FSTreeNode(ITreeNode parent, FeatureStructure annotation) {
        this(parent, annotation, new ArrayList<Type>());
    }

    public FSTreeNode(ITreeNode parent, FeatureStructure annotation, List<Type> parentTypes) {
        super(parent);
        this.fs = annotation;
        parentTypes.add(this.fs.getType());
        for (Feature f : annotation.getType().getFeatures()) {
            this.addFeatures(this, f, annotation, parentTypes);
        }
    }

    @Override
    public String getName() {
        return this.fs.getType().getShortName();
    }

    @Override
    public Type getType() {
        return this.fs.getType();
    }

    public void addFeatures(ITreeNode parent, Feature f, FeatureStructure featureStructure, List<Type> parentTypes) {
        FeatureStructure featureValue;
        if (f.getRange().isArray()) {
            FeatureStructure featureValue2 = featureStructure.getFeatureValue(f);
            if (featureValue2 instanceof ArrayFS) {
                ArrayFS array = (ArrayFS)featureValue2;
                if (array != null) {
                    String text = "Array[" + array.size() + "]";
                    PrimitiveFeatureTreeNode arrayNode = new PrimitiveFeatureTreeNode(this, f, text);
                    parent.addChild(arrayNode);
                    int size = array.size();
                    for (int i = 0; i < size; ++i) {
                        AbstractTreeNode fsNode;
                        Type fsType;
                        FeatureStructure fs = array.get(i);
                        if (!(fs instanceof FeatureStructure) || !this.expandable(fsType = fs.getType(), parentTypes)) continue;
                        if (fs instanceof AnnotationFS) {
                            AnnotationFS faa = (AnnotationFS)fs;
                            fsNode = new AnnotationTreeNode((ITreeNode)arrayNode, faa, parentTypes);
                        } else {
                            fsNode = new TypeTreeNode(arrayNode, fsType);
                        }
                        arrayNode.addChild(fsNode);
                    }
                }
            } else if (featureValue2 instanceof CommonArrayFS) {
                CommonArrayFS array = (CommonArrayFS)featureValue2;
                String text = "[" + StringUtils.join((Object[])array.toStringArray(), (String)", ") + "]";
                parent.addChild(new ArrayFeatureTreeNode(this, f, text));
            }
        } else if (f.getRange().isPrimitive()) {
            if (!"uima.cas.AnnotationBase:sofa".equals(f.getName())) {
                parent.addChild(new PrimitiveFeatureTreeNode(this, f, featureStructure.getFeatureValueAsString(f)));
            }
        } else if (f.getRange() instanceof Type && (featureValue = featureStructure.getFeatureValue(f)) instanceof AnnotationFS && this.expandable(featureValue.getType(), parentTypes)) {
            parent.addChild(new FSFeatureTreeNode(this, f, featureValue, parentTypes));
        }
    }

    private boolean expandable(Type type, List<Type> parentTypes) {
        int frequency = Collections.frequency(parentTypes, type);
        return frequency < 5;
    }

    public Object getAdapter(Class adapter) {
        if (FSTreeNode.class.equals((Object)adapter)) {
            return this;
        }
        if (FeatureStructure.class.equals((Object)adapter)) {
            return this.fs;
        }
        return null;
    }
}

