/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveFeatureTreeNode
implements ITreeNode {
    private ITreeNode parent;
    private Feature f;
    private String value;
    private ArrayList<ITreeNode> children;

    public PrimitiveFeatureTreeNode(ITreeNode parent, Feature f, String value) {
        this.parent = parent;
        this.f = f;
        this.value = value;
        this.children = new ArrayList();
    }

    @Override
    public void addChild(ITreeNode child) {
        this.children.add(child);
    }

    @Override
    public ITreeNode[] getChildren() {
        return this.children.toArray(new ITreeNode[0]);
    }

    @Override
    public Iterator<ITreeNode> getChildrenIterator() {
        return this.children.iterator();
    }

    @Override
    public String getName() {
        return this.f.getShortName() + ": " + this.value;
    }

    @Override
    public void getNodes(LinkedList<ITreeNode> list) {
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    @Override
    public Type getType() {
        return this.f.getRange();
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Feature getFeature() {
        return this.f;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void sort(Comparator<ITreeNode> cp) {
    }

    public Object getAdapter(Class adapter) {
        if (PrimitiveFeatureTreeNode.class.equals((Object)adapter)) {
            return this;
        }
        if (Feature.class.equals((Object)adapter)) {
            return this.f;
        }
        return null;
    }
}

