/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.testing.evaluator.AbstractCasEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCasEvaluator
extends AbstractCasEvaluator {
    @Override
    public CAS evaluate(CAS test, CAS run, Collection<String> excludedTypes) throws CASRuntimeException, CASException {
        Type falsePositiveType = run.getTypeSystem().getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = run.getTypeSystem().getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositiveType = run.getTypeSystem().getType("org.apache.uima.ruta.type.TruePositive");
        Feature feature = falsePositiveType.getFeatureByBaseName("original");
        Type annotationType = test.getAnnotationType();
        Type stringType = run.getTypeSystem().getType("uima.cas.String");
        Type basicType = run.getTypeSystem().getType("org.apache.uima.ruta.type.RutaBasic");
        List allTypes = test.getTypeSystem().getProperlySubsumedTypes(annotationType);
        ArrayList<Type> types = new ArrayList<Type>();
        TypeSystem typeSystem = test.getTypeSystem();
        block0: for (Type eachType : allTypes) {
            if (excludedTypes.contains(eachType.getName())) continue;
            List features = eachType.getFeatures();
            for (Feature f : features) {
                Type range = f.getRange();
                if (!typeSystem.subsumes(annotationType, range) && !typeSystem.subsumes(stringType, range) || eachType.getName().startsWith("org.apache.uima.ruta.type") || typeSystem.subsumes(basicType, eachType)) continue;
                types.add(eachType);
                continue block0;
            }
        }
        Collection<FeatureStructure> runFSs = this.getFeatureStructures(types, run);
        Collection<FeatureStructure> testFSs = this.getFeatureStructures(types, test);
        HashSet<FeatureStructure> matched = new HashSet<FeatureStructure>();
        ArrayList<FeatureStructure> fp = new ArrayList<FeatureStructure>();
        ArrayList<FeatureStructure> fn = new ArrayList<FeatureStructure>();
        ArrayList<FeatureStructure> tp = new ArrayList<FeatureStructure>();
        for (FeatureStructure eachTest : testFSs) {
            FeatureStructure original;
            Type type;
            FeatureStructure createFS;
            boolean found = false;
            for (FeatureStructure eachRun : runFSs) {
                if (!this.match(eachTest, eachRun)) continue;
                matched.add(eachRun);
                found = true;
                break;
            }
            if (!found) {
                createFS = run.createFS(falseNegativeType);
                this.fillFS(eachTest, createFS, false);
                type = run.getTypeSystem().getType(eachTest.getType().getName());
                original = run.createFS(type);
                this.fillFS(eachTest, original, true);
                createFS.setFeatureValue(feature, original);
                fn.add(createFS);
                continue;
            }
            createFS = run.createFS(truePositiveType);
            this.fillFS(eachTest, createFS, false);
            type = run.getTypeSystem().getType(eachTest.getType().getName());
            original = run.createFS(type);
            this.fillFS(eachTest, original, true);
            createFS.setFeatureValue(feature, original);
            tp.add(createFS);
        }
        for (FeatureStructure each : runFSs) {
            if (matched.contains(each)) continue;
            FeatureStructure createFS = run.createFS(falsePositiveType);
            this.fillFS(each, createFS, false);
            Type type = run.getTypeSystem().getType(each.getType().getName());
            FeatureStructure original = run.createFS(type);
            this.fillFS(each, original, true);
            createFS.setFeatureValue(feature, original);
            fp.add(createFS);
        }
        for (FeatureStructure fs : fn) {
            run.addFsToIndexes(fs);
        }
        for (FeatureStructure fs : fp) {
            run.addFsToIndexes(fs);
        }
        for (FeatureStructure fs : tp) {
            run.addFsToIndexes(fs);
        }
        return run;
    }

    private void fillFS(FeatureStructure fs, FeatureStructure newFS, boolean withFeatures) {
        if (fs instanceof AnnotationFS) {
            Annotation a = (Annotation)newFS;
            a.setBegin(((AnnotationFS)fs).getBegin());
            a.setEnd(((AnnotationFS)fs).getEnd());
        }
        if (withFeatures) {
            CAS testCas = fs.getCAS();
            CAS runCas = newFS.getCAS();
            TypeSystem testTS = testCas.getTypeSystem();
            TypeSystem runTS = runCas.getTypeSystem();
            Type annotationType = testCas.getAnnotationType();
            List features = fs.getType().getFeatures();
            for (Feature feature : features) {
                Object valueTest;
                Type range = feature.getRange();
                if (testTS.subsumes(annotationType, range) && (valueTest = fs.getFeatureValue(feature)) instanceof AnnotationFS) {
                    AnnotationFS a1 = (AnnotationFS)valueTest;
                    Feature feature2 = newFS.getType().getFeatureByBaseName(feature.getShortName());
                    if (feature != null) {
                        Type range2 = runTS.getType(range.getName());
                        AnnotationFS createAnnotation = runCas.createAnnotation(range2, a1.getBegin(), a1.getEnd());
                        newFS.setFeatureValue(feature2, (FeatureStructure)createAnnotation);
                    }
                }
                if (!"uima.cas.String".equals(range.getName()) || (valueTest = fs.getFeatureValueAsString(feature)) == null) continue;
                Feature feature2 = newFS.getType().getFeatureByBaseName(feature.getShortName());
                newFS.setFeatureValueFromString(feature2, (String)valueTest);
            }
        }
    }

    private Collection<FeatureStructure> getFeatureStructures(List<Type> types, CAS cas) {
        TypeSystem typeSystem = cas.getTypeSystem();
        Type annotationType = cas.getAnnotationType();
        HashSet<FeatureStructure> result = new HashSet<FeatureStructure>();
        for (Type type : types) {
            if (type == null) continue;
            FSIterator iterator = cas.getIndexRepository().getAllIndexedFS(type);
            try {
                iterator = cas.getView("_InitialView").getJCas().getIndexRepository().getAllIndexedFS(type);
            }
            catch (CASException e) {
                e.printStackTrace();
            }
            while (iterator.isValid()) {
                FeatureStructure fs = iterator.get();
                List features = fs.getType().getFeatures();
                for (Feature feature : features) {
                    Type range = feature.getRange();
                    if (!typeSystem.subsumes(annotationType, range) && !"uima.cas.String".equals(range.getName())) continue;
                    result.add(fs);
                    break;
                }
                iterator.moveToNext();
            }
        }
        return result;
    }

    private boolean match(FeatureStructure a1, FeatureStructure a2) {
        AnnotationFS a22;
        AnnotationFS a11;
        Type type1 = a1.getType();
        Type type2 = a2.getType();
        if (!type1.getName().equals(type2.getName())) {
            return false;
        }
        if (a1 instanceof AnnotationFS && a2 instanceof AnnotationFS && (!this.contains(a11 = (AnnotationFS)a1, a22 = (AnnotationFS)a2) || !this.overlap(a11, a22))) {
            return false;
        }
        CAS cas = a1.getCAS();
        TypeSystem typeSystem = cas.getTypeSystem();
        Type annotationType = cas.getAnnotationType();
        List features1 = type1.getFeatures();
        boolean result = true;
        boolean allEmpty1 = true;
        boolean allEmpty2 = true;
        for (Feature eachFeature1 : features1) {
            Object featureValue2;
            Object featureValue1;
            Feature eachFeature2;
            String name;
            Type range = eachFeature1.getRange();
            if (typeSystem.subsumes(annotationType, range)) {
                name = eachFeature1.getShortName();
                eachFeature2 = type2.getFeatureByBaseName(name);
                featureValue1 = a1.getFeatureValue(eachFeature1);
                featureValue2 = a2.getFeatureValue(eachFeature2);
                allEmpty1 &= featureValue1 == null;
                allEmpty2 &= featureValue2 == null;
                if (featureValue1 instanceof AnnotationFS && featureValue2 instanceof AnnotationFS) {
                    result &= this.matchAnnotations((AnnotationFS)featureValue1, (AnnotationFS)featureValue2);
                } else if (featureValue1 != null && (featureValue1 != null || featureValue2 != null)) {
                    return false;
                }
            }
            if (!"uima.cas.String".equals(range.getName())) continue;
            name = eachFeature1.getShortName();
            eachFeature2 = type2.getFeatureByBaseName(name);
            featureValue1 = a1.getFeatureValueAsString(eachFeature1);
            featureValue2 = a2.getFeatureValueAsString(eachFeature2);
            if (StringUtils.isBlank((CharSequence)featureValue2) && featureValue1 == null) continue;
            if (((String)featureValue2).trim().toLowerCase().contains(((String)featureValue1).trim().toLowerCase())) {
                result &= true;
                continue;
            }
            if (featureValue1 == null && featureValue2 == null) continue;
            a1.setFeatureValueFromString(eachFeature1, ((String)featureValue1).toUpperCase());
            a2.setFeatureValueFromString(eachFeature2, ((String)featureValue2).toUpperCase());
            return false;
        }
        return result && allEmpty1 == allEmpty2;
    }

    private boolean matchAnnotations(AnnotationFS a1, AnnotationFS a2) {
        return a1 != null && a2 != null && (this.contains(a1, a2) || this.overlap(a1, a2)) && a1.getType().getName().equals(a2.getType().getName());
    }

    private boolean overlap(AnnotationFS a1, AnnotationFS a2) {
        return a1 != null && a2 != null && (a1.getBegin() <= a2.getBegin() && a1.getEnd() >= a2.getBegin() || a1.getBegin() >= a2.getBegin() && a1.getBegin() <= a2.getEnd());
    }

    private boolean contains(AnnotationFS a1, AnnotationFS a2) {
        return a1 != null && a2 != null && (a1.getBegin() <= a2.getBegin() && a1.getEnd() >= a2.getEnd() || a1.getBegin() >= a2.getBegin() && a1.getEnd() <= a2.getEnd());
    }
}

