/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import java.util.List;
import org.apache.uima.ruta.ide.parser.ast.RutaAbstractDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaFeatureDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaFunction;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.apache.uima.ruta.ide.validator.RutaCheckerDefaultProblem;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.ISourceLineTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaCheckerProblemFactory {
    private ISourceLineTracker linetracker;
    private String fileName;

    public RutaCheckerProblemFactory(String fileName, ISourceLineTracker linetracker) {
        this.fileName = fileName;
        this.linetracker = linetracker;
    }

    public IProblem createIdConflictsWithVariableProblem(RutaAbstractDeclaration varRef) {
        String message = this.generateVarAlreadyDeclaredProblemMsg(varRef);
        return new RutaCheckerDefaultProblem(this.fileName, message, varRef, this.getLine((ASTNode)varRef));
    }

    public IProblem createIdConflictsWithTypeProblem(RutaAbstractDeclaration varRef) {
        String message = this.generateVarConflictsWithTypeProblem(varRef);
        return new RutaCheckerDefaultProblem(this.fileName, message, varRef, this.getLine((ASTNode)varRef));
    }

    public IProblem createFileNotFoundProblem(ASTNode node, String localPath) {
        return new RutaCheckerDefaultProblem(this.fileName, this.generateFileNotFoundProblemMsg(localPath), node, this.getLine(node));
    }

    public IProblem createFileNotFoundProblem(ASTNode fileNode) {
        return this.createFileNotFoundProblem(fileNode, fileNode.toString());
    }

    public IProblem createDuplicateShortNameInImported(ASTNode node, String localPath, List<String> checkDuplicateShortNames, ProblemSeverity severity) {
        StringBuilder sb = new StringBuilder();
        for (String string : checkDuplicateShortNames) {
            sb.append(string);
            sb.append(", ");
        }
        return new RutaCheckerDefaultProblem(this.fileName, "Types in " + localPath + " share same short name, but with different namespaces: " + sb.toString(), node, this.getLine(node), severity);
    }

    public IProblem createDuplicateShortName(RutaAbstractDeclaration var, ProblemSeverity severity) {
        return new RutaCheckerDefaultProblem(this.fileName, "The type " + var.getName() + " conflicts with other types with same short name, but different namespace.", (ASTNode)var, this.getLine((ASTNode)var), severity);
    }

    public IProblem createXMLProblem(ASTNode node, String localPath) {
        return new RutaCheckerDefaultProblem(this.fileName, this.generateXMLProblemMsg(localPath), node, this.getLine(node));
    }

    public IProblem createTypeProblem(RutaVariableReference ref, ISourceModule currentFile) {
        String errMsgHead = "Type \"";
        String errMsgTailDefault = " \" not defined in this script/block!";
        String errMsg = errMsgHead + ref.getName() + errMsgTailDefault;
        RutaCheckerDefaultProblem problem = new RutaCheckerDefaultProblem(currentFile.getElementName(), errMsg, (ASTNode)ref, this.linetracker.getLineNumberOfOffset(ref.sourceStart()));
        return problem;
    }

    private String generateFileNotFoundProblemMsg(ASTNode node) {
        return this.generateFileNotFoundProblemMsg(node.toString());
    }

    private String generateFileNotFoundProblemMsg(String fileName) {
        return "error: \"" + fileName + "\" not found.";
    }

    private String generateXMLProblemMsg(String fileName) {
        return "error: " + fileName + " causes xml problem.";
    }

    private int getLine(ASTNode varRef) {
        return this.linetracker.getLineNumberOfOffset(varRef.sourceStart());
    }

    private String generateVarAlreadyDeclaredProblemMsg(RutaAbstractDeclaration var) {
        return "error: Id \"" + var.getName() + "\" conflicts with already declared variable.";
    }

    private String generateVarConflictsWithTypeProblem(RutaAbstractDeclaration var) {
        return "error: Identifier \"" + var.getName() + "\" conflicts with already declared annotation type.";
    }

    public IProblem createUnknownFeatureTypeProblem(RutaFeatureDeclaration var) {
        String message = "error: Type \"" + var.getType() + "\" of Feature \"" + var.getName() + "\" is not defined.";
        return new RutaCheckerDefaultProblem(this.fileName, message, var, this.getLine((ASTNode)var));
    }

    public IProblem createUnknownFeatureProblem(Expression var, String matchedType) {
        Object object2;
        List childs2;
        Object object;
        String feat = var.toString();
        List childs = var.getChilds();
        if (childs != null && !childs.isEmpty() && (object = childs.get(0)) instanceof ASTListNode && (childs2 = ((ASTListNode)object).getChilds()) != null && !childs2.isEmpty() && (object2 = childs2.get(0)) instanceof StringLiteral) {
            StringLiteral sl = (StringLiteral)object2;
            feat = sl.getValue().replaceAll("\"", "");
        }
        String message = "error: Feature \"" + feat + "\" is not defined.";
        if (matchedType != null) {
            message = "error: Feature \"" + feat + "\" is not defined for type \"" + matchedType + "\".";
        }
        return new RutaCheckerDefaultProblem(this.fileName, message, (ASTNode)var, this.getLine((ASTNode)var));
    }

    public IProblem createWrongArgumentTypeProblem(Expression was, String expected) {
        String message = "Wrong kind of argument: expected " + expected;
        return new RutaCheckerDefaultProblem(this.fileName, message, (ASTNode)was, this.getLine((ASTNode)was));
    }

    public IProblem createInheritenceFinalProblem(RutaVariableReference parent) {
        String message = "Type \"" + parent.getName() + "\" is final and cannot be used as a parent type.";
        return new RutaCheckerDefaultProblem(this.fileName, message, (ASTNode)parent, this.getLine((ASTNode)parent));
    }

    public IProblem createUnknownConditionProblem(RutaCondition cond) {
        String message = "error: Condition \"" + cond.getName() + "\" is not defined.";
        return new RutaCheckerDefaultProblem(this.fileName, message, (ASTNode)cond, this.getLine((ASTNode)cond));
    }

    public IProblem createUnknownActionProblem(RutaAction action) {
        String message = "error: Action \"" + action.getName() + "\" is not defined.";
        return new RutaCheckerDefaultProblem(this.fileName, message, (ASTNode)action, this.getLine((ASTNode)action));
    }

    public IProblem createWrongNumberOfArgumentsProblem(String name, Expression element, int expected) {
        String message = "error: The element " + name + " expects " + expected + " arguments.";
        return new RutaCheckerDefaultProblem(this.fileName, message, (ASTNode)element, this.getLine((ASTNode)element));
    }

    public IProblem createUnknownFunctionProblem(RutaFunction f) {
        String message = "error: Function \"" + f.getName() + "\" is not defined.";
        return new RutaCheckerDefaultProblem(this.fileName, message, (ASTNode)f, this.getLine((ASTNode)f));
    }
}

