/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.uima.ruta.ide.ui.ISemanticHighlightingExtension;
import org.apache.uima.ruta.ide.ui.RutaSemanticPositionUpdater;
import org.apache.uima.ruta.ide.ui.text.RutaPartitionScanner;
import org.apache.uima.ruta.ide.ui.text.RutaSourceViewerConfiguration;
import org.eclipse.dltk.core.SimpleClassDLTKExtensionManager;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingUpdater;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.texteditor.ITextEditor;

public class RutaTextTools
extends ScriptTextTools {
    private IPartitionTokenScanner fPartitionScanner;
    private SimpleClassDLTKExtensionManager extensions = new SimpleClassDLTKExtensionManager("org.apache.uima.ruta.ide.rutaSemanticHighlighting");
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__ruta_string", "__ruta_comment"};

    public RutaTextTools(boolean autoDisposeOnDisplayDispose) {
        super("__ruta_partitioning", LEGAL_CONTENT_TYPES, autoDisposeOnDisplayDispose);
        this.fPartitionScanner = new RutaPartitionScanner();
    }

    public ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        return new RutaSourceViewerConfiguration(this.getColorManager(), preferenceStore, editor, partitioning);
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    private ISemanticHighlightingExtension[] getExtensions() {
        Object[] objects = this.extensions.getObjects();
        ISemanticHighlightingExtension[] exts = new ISemanticHighlightingExtension[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            exts[i] = (ISemanticHighlightingExtension)objects[i];
        }
        return exts;
    }

    public SemanticHighlighting[] getSemanticHighlightings() {
        ArrayList<SemanticHighlighting> highlightings = new ArrayList<SemanticHighlighting>();
        ISemanticHighlightingExtension[] exts = this.getExtensions();
        for (int i = 0; i < exts.length; ++i) {
            SemanticHighlighting[] hl = exts[i].getHighlightings();
            if (hl == null) continue;
            highlightings.addAll(Arrays.asList(hl));
        }
        SemanticHighlighting[] ret = new SemanticHighlighting[highlightings.size()];
        for (int i = 0; i < highlightings.size(); ++i) {
            ret[i] = (SemanticHighlighting)highlightings.get(i);
        }
        return ret;
    }

    public ISemanticHighlightingUpdater getSemanticPositionUpdater(String natureId) {
        return new RutaSemanticPositionUpdater(this.getExtensions());
    }

    public static final class SH
    extends SemanticHighlighting {
        private final String preferenceKey;
        private final String bgColor;
        private final String description;

        public SH(String editorXmlTagNameColor, String bgColor, String desc) {
            this.preferenceKey = editorXmlTagNameColor;
            this.bgColor = bgColor;
            this.description = desc;
        }

        public boolean isSemanticOnly() {
            return this.description != null;
        }

        public String getPreferenceKey() {
            return this.preferenceKey;
        }

        public String getBackgroundPreferenceKey() {
            return this.bgColor;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.preferenceKey == null ? 0 : this.preferenceKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SH other = (SH)((Object)obj);
            return !(this.preferenceKey == null ? other.preferenceKey != null : !this.preferenceKey.equals(other.preferenceKey));
        }

        public String getDisplayName() {
            return this.description;
        }
    }
}

