/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.preferences;

import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.ide.RutaIdePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RutaConsolePreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text newPrompt;
    private Text appendPrompt;

    protected IPreferenceStore doGetPreferenceStore() {
        return RutaIdePlugin.getDefault().getPreferenceStore();
    }

    protected void createPrompt(Composite parent, Object data) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setLayoutData(data);
        group.setFont(font);
        group.setText("Prompt");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        Label newPromptLabel = new Label((Composite)group, 0);
        newPromptLabel.setFont(font);
        newPromptLabel.setText("New command:");
        this.newPrompt = new Text((Composite)group, 2048);
        this.newPrompt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RutaConsolePreferences.this.validateValues();
            }
        });
        this.newPrompt.setLayoutData((Object)new GridData(4, 0, true, false));
        Label appendCommandLabel = new Label((Composite)group, 0);
        appendCommandLabel.setFont(font);
        appendCommandLabel.setText("Append command:");
        this.appendPrompt = new Text((Composite)group, 2048);
        this.appendPrompt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RutaConsolePreferences.this.validateValues();
            }
        });
        this.appendPrompt.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        top.setLayout((Layout)layout);
        this.createPrompt(top, new GridData(4, 0, true, false));
        this.initializeValues();
        this.validateValues();
        return top;
    }

    protected void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.newPrompt.setText(store.getString("tmconsole.new_invitation"));
        this.appendPrompt.setText(store.getString("tmconsole.continue_invitation"));
    }

    protected void validateValues() {
        if (StringUtils.isEmpty((CharSequence)this.newPrompt.getText())) {
            this.setErrorMessage("Empty prompt");
            this.setValid(false);
        } else if (StringUtils.isEmpty((CharSequence)this.appendPrompt.getText())) {
            this.setErrorMessage("Empty prompt");
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.newPrompt.setText("=>");
        this.appendPrompt.setText("->");
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("tmconsole.new_invitation", this.newPrompt.getText());
        store.setValue("tmconsole.continue_invitation", this.appendPrompt.getText());
        return true;
    }
}

