/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.TypesWithNameSpaces;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class TypesWithNameSpaces32
implements IContentProposalProvider {
    private final SortedMap sortedNames;
    private CasTypeProposal[] proposalArray = null;

    public TypesWithNameSpaces32(TypesWithNameSpaces aBase) {
        this.sortedNames = aBase.sortedNames;
    }

    public void createProposalArray() {
        ArrayList<CasTypeProposal> r = new ArrayList<CasTypeProposal>(this.sortedNames.size() * 2);
        for (Map.Entry entry : this.sortedNames.entrySet()) {
            Set nameSpaces = (Set)entry.getValue();
            for (String nameSpace : nameSpaces) {
                String shortName = (String)entry.getKey();
                r.add(new CasTypeProposal(shortName, shortName, nameSpace));
                if (null == nameSpace) continue;
                r.add(new CasTypeProposal(nameSpace + "." + shortName, shortName, nameSpace));
            }
        }
        this.proposalArray = r.toArray(new CasTypeProposal[r.size()]);
        Arrays.sort(this.proposalArray);
    }

    public CasTypeProposal[] getProposalArray() {
        return this.proposalArray;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String keyString;
        CasTypeProposal key;
        int i;
        if (null == this.proposalArray) {
            this.createProposalArray();
        }
        if ((i = Arrays.binarySearch(this.proposalArray, key = new CasTypeProposal(keyString = contents.substring(0, position).toLowerCase(), null, null))) < 0) {
            i = Math.abs(i + 1);
        }
        ArrayList<CasTypeProposal> rl = new ArrayList<CasTypeProposal>(this.proposalArray.length - i);
        while (i < this.proposalArray.length && this.proposalArray[i].getCompareKey().startsWith(keyString)) {
            rl.add(this.proposalArray[i]);
            ++i;
        }
        return rl.toArray(new CasTypeProposal[rl.size()]);
    }

    public static class CasTypeProposal
    implements IContentProposal,
    Comparable {
        private final String labelForm;
        private final String fullName;
        private final String compareKey;

        CasTypeProposal(String aCompareKey, String shortName, String nameSpace) {
            this.fullName = null == nameSpace || "".equals(nameSpace) ? shortName : nameSpace + "." + shortName;
            this.labelForm = null == nameSpace || "".equals(nameSpace) ? shortName : shortName + " - " + nameSpace;
            this.compareKey = aCompareKey.toLowerCase();
        }

        public String getContent() {
            return this.fullName;
        }

        public int getCursorPosition() {
            return this.fullName.length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            if (this.labelForm.toLowerCase().startsWith(this.compareKey)) {
                return this.labelForm;
            }
            return this.fullName;
        }

        public String getCompareKey() {
            return this.compareKey;
        }

        public int compareTo(Object arg0) throws ClassCastException {
            CasTypeProposal c = (CasTypeProposal)arg0;
            return this.compareKey.compareTo(c.getCompareKey());
        }
    }
}

