/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.packages;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.ruta.ide.RutaIdeCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DLTKRutaHelper {
    private static final String DLTK_RUTA = "scripts/dltk.ruta";

    public static List getScriptOutput(InputStream stream) {
        ArrayList elements;
        block2: {
            elements = new ArrayList();
            final BufferedReader input = new BufferedReader(new InputStreamReader(stream));
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            String line;
                            while ((line = input.readLine()) != null) {
                                elements.add(line);
                            }
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block3;
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
            try {
                t.join(50000L);
            }
            catch (InterruptedException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return elements;
    }

    private static List deployExecute(IExecutionEnvironment exeEnv, String installLocation, String[] arguments, EnvironmentVariable[] env) {
        Process process;
        IDeployment deployment;
        block5: {
            deployment = exeEnv.createDeployment();
            IFileHandle script = DLTKRutaHelper.deploy(deployment);
            if (script == null) {
                return null;
            }
            IFileHandle workingDir = script.getParent();
            InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)script, (IFileHandle)workingDir, (EnvironmentVariable[])env);
            config.removeEnvVar("DISPLAY");
            if (arguments != null) {
                config.addScriptArgs(arguments);
            }
            process = null;
            try {
                process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)installLocation, (InterpreterConfig)config);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (process == null) {
            return new ArrayList();
        }
        List output = DLTKRutaHelper.getScriptOutput(process.getInputStream());
        DLTKRutaHelper.getScriptOutput(process.getErrorStream());
        process.destroy();
        deployment.dispose();
        return output;
    }

    private static IFileHandle deploy(IDeployment deployment) {
        IFileHandle script;
        try {
            IPath path = deployment.add(RutaIdeCorePlugin.getDefault().getBundle(), DLTK_RUTA);
            script = deployment.getFile(path);
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        return script;
    }

    public static String[] getDefaultPath(IFileHandle installLocation, EnvironmentVariable[] environment) {
        return new String[0];
    }

    public static RutaPackage[] getSrcs(IExecutionEnvironment exeEnv, IFileHandle installLocation, EnvironmentVariable[] environment, String packageName) {
        Process process;
        IDeployment deployment;
        block7: {
            deployment = exeEnv.createDeployment();
            IFileHandle script = DLTKRutaHelper.deploy(deployment);
            if (script == null) {
                return null;
            }
            IFileHandle workingDir = script.getParent();
            InterpreterConfig config = ScriptLaunchUtil.createInterpreterConfig((IExecutionEnvironment)exeEnv, (IFileHandle)script, (IFileHandle)workingDir, (EnvironmentVariable[])environment);
            String names = packageName;
            ByteArrayInputStream bais = new ByteArrayInputStream(names.getBytes());
            IPath packagesPath = null;
            try {
                packagesPath = deployment.add((InputStream)bais, "packages.txt");
            }
            catch (IOException e1) {
                if (DLTKCore.DEBUG) {
                    e1.printStackTrace();
                }
                return null;
            }
            IFileHandle file = deployment.getFile(packagesPath);
            config.removeEnvVar("DISPLAY");
            String[] arguments = new String[]{"get-srcs", "-fpkgs", file.toOSString()};
            config.addScriptArgs(arguments);
            process = null;
            try {
                process = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)installLocation.toOSString(), (InterpreterConfig)config);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block7;
                e.printStackTrace();
            }
        }
        if (process == null) {
            return null;
        }
        List output = DLTKRutaHelper.getScriptOutput(process.getInputStream());
        DLTKRutaHelper.getScriptOutput(process.getErrorStream());
        process.destroy();
        deployment.dispose();
        return DLTKRutaHelper.getPackagePath(output);
    }

    private static boolean isElementName(Node nde, String name) {
        return nde != null && nde.getNodeType() == 1 && name.equalsIgnoreCase(nde.getNodeName());
    }

    private static String[] getAutoPath(List content) {
        String text = DLTKRutaHelper.getXMLContent(content);
        Document document = DLTKRutaHelper.getDocument(text);
        HashSet<String> paths = new HashSet<String>();
        if (document != null) {
            Element element = document.getDocumentElement();
            NodeList childNodes = element.getChildNodes();
            int len = childNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Element el;
                String path;
                Node nde = childNodes.item(i);
                if (!DLTKRutaHelper.isElementName(nde, "path") || (path = (el = (Element)nde).getAttribute("name")).length() <= 0) continue;
                paths.add(path);
            }
        }
        return paths.toArray(new String[paths.size()]);
    }

    public static RutaPackage[] getPackagePath(List content) {
        String text = DLTKRutaHelper.getXMLContent(content);
        Document document = DLTKRutaHelper.getDocument(text);
        HashMap packages = new HashMap();
        if (document != null) {
            Element element = document.getDocumentElement();
            NodeList childNodes = element.getChildNodes();
            int len = childNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node nde = childNodes.item(i);
                if (!DLTKRutaHelper.isElementName(nde, "path")) continue;
                Element el = (Element)nde;
                NodeList elChilds = el.getChildNodes();
                for (int j = 0; j < elChilds.getLength(); ++j) {
                    Node pkgNde = elChilds.item(j);
                    if (!DLTKRutaHelper.isElementName(pkgNde, "package")) continue;
                    DLTKRutaHelper.populatePackage(packages, pkgNde);
                }
            }
        }
        return packages.values().toArray(new RutaPackage[packages.size()]);
    }

    private static void populatePackage(Map packages, Node pkgNde) {
        Element pkg = (Element)pkgNde;
        String pkgName = pkg.getAttribute("name");
        RutaPackage tclPackage = new RutaPackage(pkgName);
        if (packages.containsKey(tclPackage)) {
            tclPackage = (RutaPackage)packages.get(tclPackage);
        } else {
            packages.put(tclPackage, tclPackage);
        }
        NodeList childs = pkg.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            String name;
            Element el;
            Node nde = childs.item(i);
            if (DLTKRutaHelper.isElementName(nde, "source")) {
                el = (Element)nde;
                name = el.getAttribute("name");
                IPath path = new Path(name).removeLastSegments(1);
                tclPackage.getPaths().add(path);
                continue;
            }
            if (!DLTKRutaHelper.isElementName(nde, "require")) continue;
            el = (Element)nde;
            name = el.getAttribute("name");
            tclPackage.getDependencies().add(name);
        }
    }

    private static Document getDocument(String text) {
        try {
            DocumentBuilderFactory documentBuilderFactory = XMLUtils.createDocumentBuilderFactory();
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            Document document = parser.parse(new ByteArrayInputStream(text.getBytes()));
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static String getXMLContent(List content) {
        StringBuffer newList = new StringBuffer();
        if (content != null) {
            for (String line : content) {
                if (!line.trim().startsWith("<")) continue;
                newList.append(line).append("\n");
            }
        }
        return newList.toString();
    }

    public static Set getPackages(IInterpreterInstall install) {
        IExecutionEnvironment exeEnv = install.getExecEnvironment();
        List content = DLTKRutaHelper.deployExecute(exeEnv, install.getInstallLocation().toOSString(), new String[]{"get-pkgs"}, install.getEnvironmentVariables());
        HashSet<String> packages = new HashSet<String>();
        RutaPackage[] packagePath = DLTKRutaHelper.getPackagePath(content);
        for (int i = 0; i < packagePath.length; ++i) {
            packages.add(packagePath[i].getName());
        }
        return packages;
    }

    public static class RutaPackage {
        private String name;
        private Set paths = new HashSet();
        private Set dependencies = new HashSet();

        public RutaPackage(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RutaPackage other = (RutaPackage)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Set getPaths() {
            return this.paths;
        }

        public void setPaths(Set paths) {
            this.paths = paths;
        }

        public Set getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Set dependencies) {
            this.dependencies = dependencies;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(128);
            sb.append("RutaPackage");
            sb.append('{');
            sb.append("name=").append(this.name);
            sb.append(' ');
            sb.append("paths=").append(this.paths);
            sb.append(' ');
            sb.append("dependencies=").append(this.dependencies);
            sb.append('}');
            return sb.toString();
        }
    }
}

