/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;

public class TextRulerWordConstraint {
    private static final boolean AUTO_REGEXP = true;
    protected TextRulerAnnotation tokenAnnotation;
    protected boolean isRegExpType;

    public TextRulerWordConstraint(TextRulerWordConstraint copyFrom) {
        this.tokenAnnotation = copyFrom.tokenAnnotation;
        this.isRegExpType = copyFrom.isRegExpType;
    }

    public TextRulerWordConstraint(TextRulerAnnotation tokenAnnotation) {
        this.tokenAnnotation = tokenAnnotation;
        CAS cas = tokenAnnotation.getDocument().getCAS();
        TypeSystem ts = cas.getTypeSystem();
        Type wType = ts.getType("org.apache.uima.ruta.type.W");
        Type numType = ts.getType("org.apache.uima.ruta.type.NUM");
        Type markupType = ts.getType("org.apache.uima.ruta.type.MARKUP");
        Type specialType = ts.getType("org.apache.uima.ruta.type.SPECIAL");
        this.isRegExpType = ts.subsumes(wType, tokenAnnotation.getType()) || ts.subsumes(markupType, tokenAnnotation.getType()) || ts.subsumes(numType, tokenAnnotation.getType()) || ts.subsumes(specialType, tokenAnnotation.getType());
    }

    protected TextRulerWordConstraint(TextRulerAnnotation tokenAnnotation, boolean isRegExpType) {
        this.tokenAnnotation = tokenAnnotation;
        this.isRegExpType = isRegExpType;
    }

    public Type annotationType() {
        return this.tokenAnnotation.getType();
    }

    public String typeShortName() {
        return this.tokenAnnotation.getType().getShortName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(((TextRulerWordConstraint)o).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isRegExpConstraint() {
        return this.isRegExpType;
    }

    public String toString() {
        if (this.isRegExpConstraint()) {
            return TextRulerToolkit.escapeForStringParameter(TextRulerToolkit.escapeForRegExp(this.tokenAnnotation.getCoveredText()));
        }
        return this.tokenAnnotation.getType().getShortName();
    }

    public TextRulerWordConstraint copy() {
        return new TextRulerWordConstraint(this);
    }

    public TextRulerAnnotation getTokenAnnotation() {
        return this.tokenAnnotation;
    }
}

