/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.role;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fulcrum.yaafi.framework.role.RoleConfigurationParser;
import org.apache.fulcrum.yaafi.framework.role.RoleEntry;
import org.apache.fulcrum.yaafi.framework.role.RoleEntryImpl;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class RoleConfigurationParserImpl
implements RoleConfigurationParser {
    private String containerFlavour;

    public RoleConfigurationParserImpl(String containerFlavour) {
        Validate.notEmpty(containerFlavour, "containerFlavour");
        this.containerFlavour = containerFlavour;
    }

    @Override
    public RoleEntry[] parse(Configuration roleConfiguration) throws ConfigurationException {
        Validate.notNull(roleConfiguration, "roleConfiguration");
        if ("yaafi".equals(this.containerFlavour)) {
            return this.mapFromYaafi(roleConfiguration);
        }
        if ("phoenix".equals(this.containerFlavour)) {
            return this.mapFromPhoenix(roleConfiguration);
        }
        if ("fortress".equals(this.containerFlavour)) {
            return this.mapFromFortress(roleConfiguration);
        }
        String msg = "Don't know the following container flavour : " + this.containerFlavour;
        throw new IllegalArgumentException(msg);
    }

    private RoleEntry[] mapFromYaafi(Configuration roleConfiguration) throws ConfigurationException {
        Validate.notNull(roleConfiguration, "roleConfiguration");
        String clazzName = null;
        String name = null;
        String shorthand = null;
        boolean isEarlyInit = false;
        String description = null;
        String componentType = null;
        String componentFlavour = null;
        boolean hasProxy = false;
        ArrayList<String> interceptorList = null;
        String logCategory = null;
        RoleEntryImpl roleEntry = null;
        Configuration[] list = roleConfiguration.getChildren("role");
        RoleEntry[] result = new RoleEntry[list.length];
        int roleIndex = 0;
        for (Configuration entry : list) {
            clazzName = entry.getAttribute("default-class");
            name = entry.getAttribute("name", clazzName);
            shorthand = entry.getAttribute("shorthand", name);
            isEarlyInit = entry.getAttributeAsBoolean("early-init", true);
            description = entry.getAttribute("description", null);
            componentType = entry.getAttribute("component-type", "avalon");
            componentFlavour = entry.getAttribute("component-flavour", "yaafi");
            hasProxy = entry.getAttributeAsBoolean("has-proxy", true);
            logCategory = entry.getAttribute("logger", shorthand);
            Configuration[] interceptorConfigList = entry.getChild("interceptors").getChildren("interceptor");
            interceptorList = new ArrayList<String>();
            for (Configuration interceptorConfigEntry : interceptorConfigList) {
                interceptorList.add(interceptorConfigEntry.getValue("interceptor"));
            }
            roleEntry = new RoleEntryImpl(name, clazzName, shorthand, isEarlyInit, description, componentType, componentFlavour, hasProxy, interceptorList, logCategory);
            result[roleIndex++] = roleEntry;
        }
        return result;
    }

    private RoleEntry[] mapFromPhoenix(Configuration roleConfiguration) throws ConfigurationException {
        Validate.notNull(roleConfiguration, "roleConfiguration");
        throw new ConfigurationException("Not supported yet");
    }

    private RoleEntry[] mapFromFortress(Configuration roleConfiguration) throws ConfigurationException {
        Validate.notNull(roleConfiguration, "roleConfiguration");
        throw new ConfigurationException("Not supported yet");
    }
}

