/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.cli;

public class Getopt {
    private String prefix;
    private String[] args;

    public Getopt(String[] args) {
        this(args, "--");
    }

    public Getopt(String[] args, String prefix) {
        this.prefix = prefix;
        this.args = args == null ? new String[0] : args;
    }

    public boolean contains(String option) {
        return this.find(option) >= 0;
    }

    public int length() {
        return this.args.length;
    }

    public String getStringValue(String option) {
        return this.getValue(option);
    }

    public String getStringValue(String option, String defaultValue) {
        return this.getValue(option, defaultValue);
    }

    public boolean getBooleanValue(String option) {
        return Boolean.valueOf(this.getValue(option));
    }

    public boolean getBooleanValue(String option, boolean defaultValue) {
        String temp = Boolean.toString(defaultValue);
        return Boolean.valueOf(this.getValue(option, temp));
    }

    private String getArg(int index) {
        return this.args[index];
    }

    private int find(String option) {
        String strOption = this.prefix + option;
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].equals(strOption)) continue;
            return i;
        }
        return -1;
    }

    private boolean hasValue(int index) {
        if (index + 1 < this.length()) {
            String value = this.getArg(index + 1);
            return !value.startsWith(this.prefix);
        }
        return false;
    }

    private String getValue(String option) {
        String value = this.getValue(option, null);
        if (value == null) {
            String msg = "No value supplied for " + this.prefix + option;
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    private String getValue(String option, String defaultValue) {
        int index = this.find(option);
        if (index < 0) {
            return defaultValue;
        }
        if (this.hasValue(index)) {
            return this.getArg(index + 1);
        }
        String msg = "No value supplied for " + this.prefix + option;
        throw new IllegalArgumentException(msg);
    }
}

