/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.fulcrum.localization.LocalizationService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.services.localization.RundataLocalizationService;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;

public class LocalizationTool
implements ApplicationTool {
    private static Logger log = LogManager.getLogger(LocalizationTool.class);
    @TurbineService
    private LocalizationService localizationService;
    protected Locale locale;

    public LocalizationTool() {
        this.refresh();
    }

    public String get(String key) {
        try {
            return this.localizationService.getString(this.getBundleName(null), this.getLocale(), key);
        }
        catch (MissingResourceException noKey) {
            log.error((Object)noKey);
            return null;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String getBundleName(Object data) {
        return this.localizationService.getDefaultBundleName();
    }

    public String format(String key, Object ... args) {
        return this.localizationService.format(this.getBundleName(null), this.getLocale(), key, args);
    }

    @Override
    public void init(Object data) {
        if (data instanceof RunData) {
            this.locale = this.localizationService instanceof RundataLocalizationService ? ((RundataLocalizationService)this.localizationService).getLocale((RunData)data) : this.localizationService.getLocale(((RunData)data).getRequest());
        }
    }

    @Override
    public void refresh() {
        this.locale = null;
    }
}

