/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.turbine.annotation.AnnotationProcessor;
import org.apache.turbine.pipeline.Pipeline;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.Valve;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.pipeline.XmlValveAdapter;
import org.apache.turbine.util.TurbineException;

@XmlRootElement(name="pipeline")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TurbinePipeline
implements Pipeline,
ValveContext {
    public static final String CLASSIC_PIPELINE = "/WEB-INF/conf/turbine-classic-pipeline.xml";
    @XmlAttribute
    private String name;
    private CopyOnWriteArrayList<Valve> valves = new CopyOnWriteArrayList();
    private ThreadLocal<Iterator<Valve>> state = new ThreadLocal();

    @Override
    public void initialize() throws Exception {
        for (Valve v : this.valves) {
            AnnotationProcessor.process(v);
            v.initialize();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addValve(Valve valve) {
        this.valves.add(valve);
    }

    @Override
    @XmlElementWrapper(name="valves")
    @XmlElement(name="valve")
    @XmlJavaTypeAdapter(value=XmlValveAdapter.class)
    public Valve[] getValves() {
        return this.valves.toArray(new Valve[0]);
    }

    protected void setValves(Valve[] valves) {
        this.valves = new CopyOnWriteArrayList<Valve>(valves);
    }

    @Override
    public void removeValve(Valve valve) {
        this.valves.remove(valve);
    }

    @Override
    public void invoke(PipelineData pipelineData) throws TurbineException, IOException {
        this.state.set(Collections.unmodifiableCollection(this.valves).iterator());
        this.invokeNext(pipelineData);
    }

    @Override
    public void invokeNext(PipelineData pipelineData) throws TurbineException, IOException {
        Iterator<Valve> current = this.state.get();
        if (current.hasNext()) {
            current.next().invoke(pipelineData, this);
        }
    }
}

