/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Group;

@XmlRootElement(name="input-data")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AppData
implements Serializable {
    private static final long serialVersionUID = -3953843038383617960L;
    private List<Group> groups;
    private String basePackage = "";
    private String groupPrefix;

    public List<Group> getGroups() {
        return this.groups;
    }

    @XmlElement(name="group")
    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public Group getGroup(String groupName) throws IntakeException {
        if (groupName == null) {
            throw new IntakeException("Intake AppData.getGroup(groupName) is null");
        }
        String groupPrefix = this.getGroupPrefix();
        for (Group group : this.groups) {
            if (group.getIntakeGroupName().equals(groupName)) {
                return group;
            }
            if (groupPrefix == null) continue;
            StringBuilder qualifiedGroupName = new StringBuilder();
            qualifiedGroupName.append(groupPrefix).append(':').append(group.getIntakeGroupName());
            if (!qualifiedGroupName.toString().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    @XmlAttribute
    public void setBasePackage(String v) {
        this.basePackage = v == null ? "" : (v.endsWith(".") ? v : v + ".");
    }

    public String getGroupPrefix() {
        return this.groupPrefix;
    }

    @XmlAttribute
    public void setGroupPrefix(String groupPrefix) {
        this.groupPrefix = groupPrefix;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<input-data>\n");
        for (Group group : this.groups) {
            result.append(group);
        }
        result.append("</input-data>");
        return result.toString();
    }
}

