/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsonrpc;

import java.io.CharArrayWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jabsorb.JSONRPCBridge;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONProcessor {
    private static Logger log = LogManager.getLogger(JSONProcessor.class);

    public static Object processCall(CharArrayWriter cdata, JSONRPCBridge json_bridge, HttpServletRequest request) {
        JSONObject json_req = null;
        String json_res = null;
        try {
            json_req = new JSONObject(cdata.toString());
            if (log.isDebugEnabled()) {
                String methodName = json_req.getString("method");
                JSONArray arguments = json_req.getJSONArray("params");
                int object_id = json_req.optInt("objectID");
                StringBuilder sb = new StringBuilder(".doprocessCall(): call ");
                if (object_id != 0) {
                    sb.append("objectID=").append(object_id).append(" ");
                }
                sb.append(methodName).append("(").append(arguments).append(")");
                log.debug(sb.toString());
            }
            json_res = json_bridge.call(new Object[]{request}, json_req);
        }
        catch (JSONException e) {
            log.error(".processCall(): can't parse call: {}", (Object)cdata, (Object)e);
            json_res = "couldn't parse request arguments";
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = json_res::toString;
        log.debug(".processCall():  returns ", supplierArray);
        return json_res;
    }
}

