/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.whereclausebuilder;

import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.AbstractWhereClausePsPartBuilder;
import org.apache.torque.sql.whereclausebuilder.CombinedPreparedStatementPart;

public class NullValueBuilder
extends AbstractWhereClausePsPartBuilder {
    @Override
    public PreparedStatementPart buildPs(WhereClauseExpression whereClausePart, boolean ignoreCase, Query query, Adapter adapter) throws TorqueException {
        if (whereClausePart.getOperator().equals(SqlEnum.ISNULL) || whereClausePart.getOperator().equals(SqlEnum.ISNOTNULL)) {
            CombinedPreparedStatementPart result = new CombinedPreparedStatementPart(NullValueBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCase, query, adapter));
            result.appendSql(whereClausePart.getOperator().toString());
            return result;
        }
        if (whereClausePart.getOperator().equals(SqlEnum.EQUAL)) {
            CombinedPreparedStatementPart result = new CombinedPreparedStatementPart(NullValueBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCase, query, adapter));
            result.appendSql(SqlEnum.ISNULL.toString());
            return result;
        }
        if (whereClausePart.getOperator().equals(SqlEnum.NOT_EQUAL) || whereClausePart.getOperator().equals(SqlEnum.ALT_NOT_EQUAL)) {
            CombinedPreparedStatementPart result = new CombinedPreparedStatementPart(NullValueBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCase, query, adapter));
            result.appendSql(SqlEnum.ISNOTNULL.toString());
            return result;
        }
        throw new IllegalStateException("unknown operator " + whereClausePart.getOperator());
    }

    @Override
    public boolean isApplicable(WhereClauseExpression whereClauseExpression, Adapter adapter) {
        if (whereClauseExpression.getOperator().equals(SqlEnum.ISNULL) || whereClauseExpression.getOperator().equals(SqlEnum.ISNOTNULL)) {
            return true;
        }
        Object rValue = whereClauseExpression.getRValue();
        if (!(rValue == null || rValue instanceof ObjectKey && ((ObjectKey)rValue).getValue() == null)) {
            return false;
        }
        return whereClauseExpression.getOperator().equals(SqlEnum.EQUAL) || whereClauseExpression.getOperator().equals(SqlEnum.NOT_EQUAL) || whereClauseExpression.getOperator().equals(SqlEnum.ALT_NOT_EQUAL);
    }
}

