/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.manager;

import java.io.Serializable;
import org.apache.commons.jcs.access.GroupCacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.TorqueException;
import org.apache.torque.manager.MethodCacheKey;

public class MethodResultCache {
    private GroupCacheAccess<MethodCacheKey, Object> jcsCache;
    private static final Logger log = LogManager.getLogger(MethodResultCache.class);

    public MethodResultCache(GroupCacheAccess<MethodCacheKey, Object> cache) {
        this.jcsCache = cache;
    }

    protected MethodResultCache() {
    }

    public void clear() {
        if (this.jcsCache != null) {
            try {
                this.jcsCache.clear();
            }
            catch (CacheException ce) {
                log.error((Object)new TorqueException("Could not clear cache due to internal JCS error.", ce));
            }
        }
    }

    protected Object getImpl(MethodCacheKey key) {
        Object result = null;
        if (this.jcsCache != null) {
            result = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
        }
        if (result != null) {
            log.debug("MethodResultCache saved expensive operation: {}", (Object)key);
        }
        return result;
    }

    protected Object putImpl(MethodCacheKey key, Object value) throws TorqueException {
        String group = key.getGroupKey();
        Object old = null;
        if (this.jcsCache != null) {
            try {
                old = this.jcsCache.getFromGroup((Object)key, group);
                this.jcsCache.putInGroup((Object)key, group, value);
            }
            catch (CacheException ce) {
                throw new TorqueException("Could not cache due to internal JCS error", ce);
            }
        }
        return old;
    }

    protected Object removeImpl(MethodCacheKey key) {
        Object old = null;
        if (this.jcsCache != null) {
            old = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
            this.jcsCache.removeFromGroup((Object)key, key.getGroupKey());
        }
        return old;
    }

    public <T> T get(Serializable instanceOrClass, String method, Serializable ... arg) {
        Object result = null;
        if (this.jcsCache != null) {
            MethodCacheKey key = new MethodCacheKey(instanceOrClass, method, arg);
            result = this.getImpl(key);
        }
        return (T)result;
    }

    public <T> void put(T value, Serializable instanceOrClass, String method, Serializable ... arg) {
        try {
            MethodCacheKey key = new MethodCacheKey(instanceOrClass, method, arg);
            this.putImpl(key, value);
        }
        catch (TorqueException e) {
            log.error("Problem putting object into cache", (Throwable)e);
        }
    }

    public void removeAll(Serializable instanceOrClass, String method) {
        if (this.jcsCache != null) {
            MethodCacheKey key = new MethodCacheKey(instanceOrClass, method, new Serializable[0]);
            String groupName = key.getGroupKey();
            this.jcsCache.invalidateGroup(groupName);
        }
    }

    public <T> T remove(Serializable instanceOrClass, String method, Serializable ... arg) {
        Object result = null;
        if (this.jcsCache != null) {
            MethodCacheKey key = new MethodCacheKey(instanceOrClass, method, arg);
            result = this.removeImpl(key);
        }
        return (T)result;
    }
}

