/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.lookup;

import java.util.Collections;
import java.util.Map;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class StepLookup
extends Step {
    private final String lookupName;
    private final Map<String, String> lookup;
    private final String defaultValue;
    private final boolean canFail;

    private StepLookup() {
        this.lookupName = "<< Should not be seen anywhere >>";
        this.lookup = Collections.emptyMap();
        this.defaultValue = "<< Should not be seen anywhere >>";
        this.canFail = false;
    }

    public StepLookup(String lookupName, Map<String, String> lookup, String defaultValue) {
        this.lookupName = lookupName;
        this.lookup = lookup;
        this.defaultValue = defaultValue;
        this.canFail = defaultValue == null;
    }

    @Override
    public boolean canFail() {
        return this.canFail;
    }

    @Override
    public boolean mustHaveInput() {
        return this.canFail;
    }

    @Override
    public WalkList.WalkResult walk(ParseTree tree, String value) {
        String actualValue = this.getActualValue(tree, value);
        String result = null;
        if (actualValue != null) {
            result = this.lookup.get(actualValue.toLowerCase());
        }
        if (result == null) {
            if (this.defaultValue == null) {
                return null;
            }
            return this.walkNextStep(tree, this.defaultValue);
        }
        return this.walkNextStep(tree, result);
    }

    public String toString() {
        return "Lookup(@" + this.lookupName + " ; default=" + this.defaultValue + ")";
    }
}

