/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.GlobalCacheService;
import org.apache.fulcrum.cache.ObjectExpiredException;
import org.apache.fulcrum.cache.RefreshableCachedObject;

public class EHCacheService
extends AbstractLogEnabled
implements GlobalCacheService,
Runnable,
Configurable,
Disposable,
Initializable,
ThreadSafe {
    public static final long DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    private long cacheCheckFrequency;
    private String configFile;
    private static final String DEFAULT_CACHE_NAME = "fulcrum";
    private String cacheName;
    private Thread refreshing;
    private boolean continueThread;
    private CacheManager cacheManager;
    private Cache cache;

    public void configure(Configuration config) throws ConfigurationException {
        this.cacheCheckFrequency = config.getChild("cacheCheckFrequency").getValueAsLong(5000L);
        this.cacheName = config.getChild("cacheName").getValue(DEFAULT_CACHE_NAME);
        this.configFile = config.getChild("configurationFile").getValue(null);
    }

    public void initialize() throws Exception {
        if (this.configFile == null) {
            this.cacheManager = new CacheManager();
            this.cacheManager.addCache(this.cacheName);
        } else {
            this.cacheManager = new CacheManager(this.configFile);
        }
        this.cache = this.cacheManager.getCache(this.cacheName);
        this.continueThread = true;
        this.refreshing = new Thread(this);
        this.refreshing.setDaemon(true);
        this.refreshing.setName("EHCacheService Refreshing");
        this.refreshing.start();
        this.getLogger().debug("EHCacheService started!");
    }

    public void dispose() {
        this.continueThread = false;
        this.refreshing.interrupt();
        this.cacheManager.shutdown();
        this.cacheManager = null;
        this.cache = null;
        this.getLogger().debug("EHCacheService stopped!");
    }

    @Override
    public <T> void addObject(String objectId, CachedObject<T> object) {
        Element cacheElement = new Element((Serializable)((Object)objectId), object);
        if (object instanceof RefreshableCachedObject) {
            cacheElement.setEternal(true);
        } else {
            cacheElement.setEternal(false);
            cacheElement.setTimeToLive((int)(object.getExpires() + 500L) / 1000);
        }
        this.cache.put(cacheElement);
    }

    @Override
    public void flushCache() {
        this.cache.removeAll();
    }

    @Override
    public List<CachedObject<?>> getCachedObjects() {
        ArrayList values = new ArrayList();
        for (String key : this.getKeys()) {
            Element cachedElement = this.cache.get((Serializable)((Object)key));
            if (cachedElement == null) continue;
            values.add((CachedObject)cachedElement.getObjectValue());
        }
        return values;
    }

    @Override
    public int getCacheSize() throws IOException {
        return (int)this.cache.calculateInMemorySize();
    }

    @Override
    public List<String> getKeys() {
        List keysWithExpiryCheck = this.cache.getKeysWithExpiryCheck();
        return keysWithExpiryCheck;
    }

    @Override
    public int getNumberOfObjects() {
        return this.getKeys().size();
    }

    @Override
    public <T> CachedObject<T> getObject(String objectId) throws ObjectExpiredException {
        RefreshableCachedObject refreshableCachedObject;
        Element cachedElement = this.cache.get((Serializable)((Object)objectId));
        if (cachedElement == null) {
            throw new ObjectExpiredException();
        }
        CachedObject cachedObject = (CachedObject)cachedElement.getObjectValue();
        if (cachedObject.isStale()) {
            if (cachedObject instanceof RefreshableCachedObject) {
                refreshableCachedObject = (RefreshableCachedObject)cachedObject;
                if (refreshableCachedObject.isUntouched()) {
                    this.removeObject(objectId);
                    throw new ObjectExpiredException();
                }
                refreshableCachedObject.refresh();
                if (refreshableCachedObject.isStale()) {
                    this.removeObject(objectId);
                    throw new ObjectExpiredException();
                }
            } else {
                this.removeObject(objectId);
                throw new ObjectExpiredException();
            }
        }
        if (cachedObject instanceof RefreshableCachedObject) {
            refreshableCachedObject = (RefreshableCachedObject)cachedObject;
            refreshableCachedObject.touch();
        }
        return cachedObject;
    }

    @Override
    public void removeObject(String objectId) {
        this.cache.remove((Serializable)((Object)objectId));
    }

    @Override
    public void run() {
        while (this.continueThread) {
            block6: {
                try {
                    Thread.sleep(this.cacheCheckFrequency);
                }
                catch (InterruptedException exc) {
                    if (this.continueThread) break block6;
                    return;
                }
            }
            for (String key : this.getKeys()) {
                Element cachedElement = this.cache.get((Serializable)((Object)key));
                if (cachedElement == null) {
                    this.cache.remove((Serializable)((Object)key));
                    continue;
                }
                Object object = cachedElement.getObjectValue();
                if (!(object instanceof RefreshableCachedObject)) continue;
                RefreshableCachedObject refreshableObject = (RefreshableCachedObject)object;
                if (refreshableObject.isUntouched()) {
                    this.cache.remove((Serializable)((Object)key));
                    continue;
                }
                if (!refreshableObject.isStale()) continue;
                refreshableObject.refresh();
            }
        }
    }
}

