/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc.mysql;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheFactory;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.MySQLDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.MySQLDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.MySQLTableOptimizer;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.util.ScheduleParser;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MySQLDiskCacheFactory
extends JDBCDiskCacheFactory {
    private static final Log log = LogFactory.getLog(MySQLDiskCacheFactory.class);

    @Override
    public <K, V> MySQLDiskCache<K, V> createCache(AuxiliaryCacheAttributes rawAttr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) throws SQLException {
        MySQLDiskCacheAttributes cattr = (MySQLDiskCacheAttributes)rawAttr;
        TableState tableState = this.getTableState(cattr.getTableName());
        DataSourceFactory dsFactory = this.getDataSourceFactory(cattr, compositeCacheManager.getConfigurationProperties());
        MySQLDiskCache cache = new MySQLDiskCache(cattr, dsFactory, tableState, compositeCacheManager);
        cache.setCacheEventLogger(cacheEventLogger);
        cache.setElementSerializer(elementSerializer);
        this.createShrinkerWhenNeeded(cattr, cache);
        this.scheduleOptimizations(cattr, tableState, cache.getDataSource());
        return cache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void scheduleOptimizations(MySQLDiskCacheAttributes attributes, TableState tableState, DataSource ds) {
        if (attributes == null) return;
        if (attributes.getOptimizationSchedule() != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will try to configure optimization for table [" + attributes.getTableName() + "] on schedule [" + attributes.getOptimizationSchedule() + "]"));
            }
            MySQLTableOptimizer optimizer = new MySQLTableOptimizer(attributes, tableState, ds);
            try {
                Date[] dates = ScheduleParser.createDatesForSchedule(attributes.getOptimizationSchedule());
                if (dates == null) return;
                for (int i = 0; i < dates.length; ++i) {
                    this.scheduleOptimization(dates[i], optimizer);
                }
                return;
            }
            catch (ParseException e) {
                log.warn((Object)("Problem creating optimization schedule for table [" + attributes.getTableName() + "]"), (Throwable)e);
                return;
            }
        } else {
            if (!log.isInfoEnabled()) return;
            log.info((Object)("Optimization is not configured for table [" + attributes.getTableName() + "]"));
        }
    }

    protected void scheduleOptimization(Date startTime, MySQLTableOptimizer optimizer) {
        if (log.isInfoEnabled()) {
            log.info((Object)("startTime [" + startTime + "] for optimizer " + optimizer));
        }
        OptimizerTask runnable = new OptimizerTask(optimizer);
        Date now = new Date();
        long initialDelay = startTime.getTime() - now.getTime();
        this.getScheduledExecutorService().scheduleAtFixedRate(runnable, initialDelay, 86400000L, TimeUnit.MILLISECONDS);
    }

    private static class OptimizerTask
    implements Runnable {
        private MySQLTableOptimizer optimizer = null;

        public OptimizerTask(MySQLTableOptimizer optimizer) {
            this.optimizer = optimizer;
        }

        @Override
        public void run() {
            if (this.optimizer != null) {
                boolean success = this.optimizer.optimizeTable();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Optimization success status [" + success + "]"));
                }
            } else {
                log.warn((Object)"OptimizerRunner: The optimizer is null.  Could not optimize table.");
            }
        }
    }
}

