/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.whereclausebuilder;

import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.AbstractWhereClausePsPartBuilder;

public class LikeBuilder
extends AbstractWhereClausePsPartBuilder {
    private static final char BACKSLASH = '\\';

    public PreparedStatementPart buildPs(WhereClauseExpression whereClausePart, boolean ignoreCase, Adapter adapter) throws TorqueException {
        PreparedStatementPart result;
        int position;
        if (!(whereClausePart.getRValue() instanceof String)) {
            throw new TorqueException("rValue must be a String for the operator " + whereClausePart.getOperator());
        }
        String value = (String)whereClausePart.getRValue();
        StringBuffer sb = new StringBuffer();
        boolean replaceWithEquals = true;
        for (position = 0; position < value.length(); ++position) {
            char checkWildcard = value.charAt(position);
            switch (checkWildcard) {
                case '\\': {
                    char escapedChar;
                    if (position + 1 >= value.length()) break;
                    if ((escapedChar = value.charAt(++position)) != '*' && escapedChar != '?') {
                        sb.append(checkWildcard);
                    }
                    checkWildcard = escapedChar;
                    break;
                }
                case '%': 
                case '_': {
                    replaceWithEquals = false;
                    break;
                }
                case '*': {
                    replaceWithEquals = false;
                    checkWildcard = '%';
                    break;
                }
                case '?': {
                    replaceWithEquals = false;
                    checkWildcard = '_';
                    break;
                }
            }
            sb.append(checkWildcard);
        }
        value = sb.toString();
        if (ignoreCase) {
            if (adapter.useIlike() && !replaceWithEquals) {
                if (SqlEnum.LIKE.equals(whereClausePart.getOperator())) {
                    whereClausePart.setOperator(SqlEnum.ILIKE);
                } else if (SqlEnum.NOT_LIKE.equals(whereClausePart.getOperator())) {
                    whereClausePart.setOperator(SqlEnum.NOT_ILIKE);
                }
                result = LikeBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), false, adapter);
            } else {
                result = LikeBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), true, adapter);
            }
        } else {
            result = LikeBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCase, adapter);
        }
        if (replaceWithEquals) {
            if (whereClausePart.getOperator().equals(SqlEnum.NOT_LIKE) || whereClausePart.getOperator().equals(SqlEnum.NOT_ILIKE)) {
                result.getSql().append(SqlEnum.NOT_EQUAL);
            } else {
                result.getSql().append(SqlEnum.EQUAL);
            }
            sb = new StringBuffer();
            for (position = 0; position < value.length(); ++position) {
                char checkWildcard = value.charAt(position);
                if (checkWildcard == '\\' && position + 1 < value.length()) {
                    checkWildcard = value.charAt(++position);
                }
                sb.append(checkWildcard);
            }
            value = sb.toString();
        } else {
            result.getSql().append(whereClausePart.getOperator());
        }
        String rValueSql = "?";
        if (ignoreCase && (!adapter.useIlike() || replaceWithEquals)) {
            rValueSql = adapter.ignoreCase(rValueSql);
        }
        if (!replaceWithEquals && adapter.useEscapeClauseForLike()) {
            rValueSql = rValueSql + SqlEnum.ESCAPE + "'\\'";
        }
        result.getPreparedStatementReplacements().add(value);
        result.getSql().append(rValueSql);
        return result;
    }

    public boolean isApplicable(WhereClauseExpression whereClauseExpression, Adapter adapter) {
        return whereClauseExpression.getOperator().equals(SqlEnum.LIKE) || whereClauseExpression.getOperator().equals(SqlEnum.NOT_LIKE) || whereClauseExpression.getOperator().equals(SqlEnum.ILIKE) || whereClauseExpression.getOperator().equals(SqlEnum.NOT_ILIKE);
    }
}

