/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.classify;

import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.classify.DeviceClass;

public final class UserAgentClassifier {
    private UserAgentClassifier() {
    }

    public static DeviceClass getDeviceClass(UserAgent userAgent) {
        switch (userAgent.getValue("DeviceClass")) {
            case "Desktop": {
                return DeviceClass.Desktop;
            }
            case "Anonymized": {
                return DeviceClass.Anonymized;
            }
            case "Mobile": {
                return DeviceClass.Mobile;
            }
            case "Tablet": {
                return DeviceClass.Tablet;
            }
            case "Phone": {
                return DeviceClass.Phone;
            }
            case "Watch": {
                return DeviceClass.Watch;
            }
            case "Virtual Reality": {
                return DeviceClass.VirtualReality;
            }
            case "eReader": {
                return DeviceClass.eReader;
            }
            case "Set-top box": {
                return DeviceClass.SetTopBox;
            }
            case "TV": {
                return DeviceClass.TV;
            }
            case "Game Console": {
                return DeviceClass.GameConsole;
            }
            case "Handheld Game Console": {
                return DeviceClass.HandheldGameConsole;
            }
            case "Robot": {
                return DeviceClass.Robot;
            }
            case "Robot Mobile": {
                return DeviceClass.RobotMobile;
            }
            case "Spy": {
                return DeviceClass.Spy;
            }
            case "Hacker": {
                return DeviceClass.Hacker;
            }
            case "Unknown": {
                return DeviceClass.Unknown;
            }
        }
        return DeviceClass.Unclassified;
    }

    public static boolean isNormalConsumerDevice(UserAgent userAgent) {
        switch (UserAgentClassifier.getDeviceClass(userAgent)) {
            case Desktop: 
            case Mobile: 
            case Tablet: 
            case Phone: 
            case Watch: 
            case VirtualReality: 
            case eReader: 
            case SetTopBox: 
            case TV: 
            case GameConsole: 
            case HandheldGameConsole: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMobile(UserAgent userAgent) {
        switch (UserAgentClassifier.getDeviceClass(userAgent)) {
            case Mobile: 
            case Tablet: 
            case Phone: 
            case Watch: 
            case VirtualReality: 
            case eReader: 
            case HandheldGameConsole: 
            case RobotMobile: {
                return true;
            }
        }
        return false;
    }

    public static boolean isHuman(UserAgent userAgent) {
        switch (UserAgentClassifier.getDeviceClass(userAgent)) {
            case Desktop: 
            case Mobile: 
            case Tablet: 
            case Phone: 
            case Watch: 
            case VirtualReality: 
            case eReader: 
            case SetTopBox: 
            case TV: 
            case GameConsole: 
            case HandheldGameConsole: 
            case Anonymized: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDeliberateMisuse(UserAgent userAgent) {
        switch (UserAgentClassifier.getDeviceClass(userAgent)) {
            case Anonymized: 
            case Spy: 
            case Hacker: {
                return true;
            }
        }
        return false;
    }
}

